/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.controller.participants;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.battles.controller.BattleControllerBase;
import com.pixelmonmod.pixelmon.battles.controller.ai.MoveChoice;
import com.pixelmonmod.pixelmon.battles.controller.participants.BattleParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.ParticipantType;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.controller.participants.PlayerParticipant;
import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import com.pixelmonmod.pixelmon.entities.npcs.NPCTrainer;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.links.PokemonLink;
import com.pixelmonmod.pixelmon.enums.EnumBossMode;
import com.pixelmonmod.pixelmon.enums.battle.EnumBattleAIMode;
import com.pixelmonmod.pixelmon.storage.PlayerStorage;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextComponentBase;
import net.minecraft.util.text.TextComponentString;

public class TrainerParticipant
extends BattleParticipant {
    public NPCTrainer trainer;

    public TrainerParticipant(NPCTrainer trainer, EntityPlayer opponent, int numPokemon) throws IllegalStateException {
        super(numPokemon);
        this.setTrainer(trainer, opponent);
    }

    public TrainerParticipant(NPCTrainer trainer, EntityPlayer opponent, int numPokemon, List<PokemonLink> teamSelection) throws IllegalStateException {
        super(numPokemon);
        this.setTrainer(trainer, opponent);
        this.loadParty(teamSelection);
    }

    private void setTrainer(NPCTrainer trainer, EntityPlayer opponent) throws IllegalStateException {
        if (!trainer.canStartBattle(opponent, true)) {
            throw new IllegalStateException("NPC Trainer already battled: " + trainer.func_70005_c_());
        }
        this.trainer = trainer;
        this.loadParty(trainer.getPokemonStorage());
    }

    public TrainerParticipant(NPCTrainer trainer, int numPokemon) throws IllegalStateException {
        super(numPokemon);
        if (trainer.battleController != null) {
            throw new IllegalStateException("NPC Trainer already battled: " + trainer.func_70005_c_());
        }
        this.trainer = trainer;
        this.loadParty(trainer.getPokemonStorage());
    }

    @Override
    public void startBattle(BattleControllerBase bc) {
        PlayerStorage storage = this.trainer.getPokemonStorage();
        if (this.trainer.getBossMode() != EnumBossMode.NotBoss) {
            int lvl = 1;
            for (BattleParticipant p : bc.participants) {
                if (p.team == this.team || !(p instanceof PlayerParticipant)) continue;
                lvl = Math.max(lvl, ((PlayerParticipant)p).getHighestLevel());
            }
            lvl += this.trainer.getBossMode().extraLevels;
            for (PixelmonWrapper pw : this.allPokemon) {
                pw.bc = bc;
                pw.setTempLevel(lvl);
            }
        } else {
            storage.updateStatsTrainer();
        }
        EntityPixelmon[] released = this.releasePokemon();
        ArrayList<EntityPixelmon> realReleased = new ArrayList<EntityPixelmon>();
        for (EntityPixelmon aReleased : released) {
            if (aReleased == null) continue;
            realReleased.add(aReleased);
        }
        int i = 0;
        while (i < realReleased.size()) {
            EntityPixelmon p = (EntityPixelmon)((Object)realReleased.get(i));
            PixelmonWrapper pw = this.getPokemonFromParty(p);
            this.controlledPokemon.add(pw);
            pw.battlePosition = i++;
        }
        super.startBattle(bc);
        for (PixelmonWrapper pw : this.allPokemon) {
            pw.setHealth(pw.getMaxHealth());
        }
        EnumBattleAIMode battleAIMode = this.trainer.getBattleAIMode();
        if (battleAIMode == EnumBattleAIMode.Default) {
            battleAIMode = PixelmonConfig.battleAITrainer;
        }
        this.setBattleAI(battleAIMode.createAI(this));
        this.trainer.setBattleController(bc);
        this.trainer.startBattle(bc.getOpponents(this).get(0));
    }

    private EntityPixelmon[] releasePokemon() {
        EntityPixelmon[] pokemon = new EntityPixelmon[this.numControlledPokemon];
        for (int i = 0; i < this.numControlledPokemon; ++i) {
            if (this.allPokemon.length <= i) continue;
            pokemon[i] = this.trainer.releasePokemon(this.allPokemon[i].getPokemonID());
        }
        return pokemon;
    }

    @Override
    public ParticipantType getType() {
        return ParticipantType.Trainer;
    }

    @Override
    public boolean hasMorePokemonReserve() {
        return this.countAblePokemon() > this.getActiveUnfaintedPokemon().size() + this.switchingOut.size();
    }

    @Override
    public boolean canGainXP() {
        return false;
    }

    @Override
    public void endBattle() {
        ArrayList opponents = (ArrayList)this.bc.participants.stream().filter(p -> p.team != this.team).collect(Collectors.toList());
        if (this.trainer.battleController != null) {
            if (this.hasMorePokemon() || !opponents.stream().anyMatch(p -> p.hasMorePokemon())) {
                this.trainer.winBattle(opponents);
            } else {
                this.trainer.loseBattle(opponents);
            }
        }
        for (PixelmonWrapper p2 : this.controlledPokemon) {
            p2.getBattleStats().clearBattleStats();
            p2.clearStatus();
            if (p2.pokemon == null) continue;
            p2.pokemon.endBattle();
            p2.pokemon.func_70106_y();
            p2.pokemon.unloadEntity();
        }
        this.trainer.setAttackTargetPix(null);
        this.trainer.healAllPokemon();
        this.trainer.setBattleController(null);
    }

    @Override
    public void getNextPokemon(int position) {
        for (PixelmonWrapper pw : this.controlledPokemon) {
            if (pw.battlePosition != position) continue;
            this.bc.switchPokemon(pw.getPokemonID(), this.getBattleAI().getNextSwitch(pw), true);
            return;
        }
    }

    @Override
    public int[] getNextPokemonID() {
        return this.trainer.getNextPokemonID();
    }

    private String getTranslatedName() {
        String loc = null;
        for (BattleParticipant p : this.bc.getOpponents(this)) {
            if (!(p instanceof PlayerParticipant)) continue;
            loc = ((EntityPlayerMP)p.getEntity()).field_71148_cg;
        }
        if (loc == null) {
            return this.trainer.func_70005_c_();
        }
        return this.trainer.getName(loc);
    }

    @Override
    public TextComponentBase getName() {
        return new TextComponentString(this.getTranslatedName());
    }

    @Override
    public MoveChoice getMove(PixelmonWrapper p) {
        return this.getBattleAI().getNextMove(p);
    }

    @Override
    public PixelmonWrapper switchPokemon(PixelmonWrapper oldPokemon, int[] newPixelmonId) {
        int index = oldPokemon.getControlledIndex();
        if (index == -1 && this.bc.simulateMode) {
            index = 0;
        }
        String beforeName = oldPokemon.getNickname();
        oldPokemon.beforeSwitch();
        if (!oldPokemon.isFainted() && !oldPokemon.nextSwitchIsMove) {
            this.bc.sendToOthers("playerparticipant.withdrew", this, this.getTranslatedName(), beforeName);
        }
        PixelmonWrapper newWrapper = this.getPokemonFromParty(newPixelmonId);
        if (!this.bc.simulateMode) {
            EntityPixelmon pixelmon;
            oldPokemon.pokemon.catchInPokeball();
            oldPokemon.pokemon = null;
            newWrapper.pokemon = pixelmon = this.trainer.releasePokemon(newPixelmonId);
        }
        if (this.trainer.getBossMode() != EnumBossMode.NotBoss) {
            int lvl = 1;
            for (BattleParticipant p : this.bc.participants) {
                if (p.team == this.team || !(p instanceof PlayerParticipant)) continue;
                lvl = Math.max(lvl, ((PlayerParticipant)p).getHighestLevel());
            }
            newWrapper.getLevel().setLevel(lvl += this.trainer.getBossMode().extraLevels);
        }
        this.controlledPokemon.set(index, newWrapper);
        newWrapper.getBattleAbility().beforeSwitch(newWrapper);
        if (!this.bc.simulateMode) {
            this.bc.sendToOthers("pixelmon.battletext.sentout", this, this.getTranslatedName(), newWrapper.getNickname());
            this.bc.participants.forEach(BattleParticipant::updateOtherPokemon);
        }
        newWrapper.afterSwitch();
        return newWrapper;
    }

    @Override
    public boolean checkPokemon() {
        for (NBTTagCompound n : this.trainer.getPokemonStorage().getList()) {
            if (n == null || n.func_74762_e("PixelmonNumberMoves") != 0) continue;
            if (PixelmonConfig.printErrors) {
                Pixelmon.LOGGER.info("Couldn't load Pok\u00e9mon's moves.");
            }
            return false;
        }
        return true;
    }

    @Override
    public void updatePokemon(PixelmonWrapper p) {
    }

    public EntityLiving getEntity() {
        return this.trainer.getEntity();
    }

    @Override
    public void updateOtherPokemon() {
    }

    @Override
    public String getDisplayName() {
        return this.getTranslatedName();
    }

    @Override
    public PlayerStorage getStorage() {
        return this.trainer.getPokemonStorage();
    }
}

