/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.rules.clauses;

import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.rules.clauses.BattleClause;
import com.pixelmonmod.pixelmon.entities.pixelmon.Entity3HasStats;
import com.pixelmonmod.pixelmon.entities.pixelmon.abilities.AbilityBase;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.BaseStats;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.links.PokemonLink;
import com.pixelmonmod.pixelmon.enums.EnumPokemon;
import com.pixelmonmod.pixelmon.items.ItemHeld;
import com.pixelmonmod.pixelmon.items.heldItems.ItemMegaStone;
import com.pixelmonmod.pixelmon.util.helpers.ArrayHelper;
import java.util.Optional;

public class AbilityClause
extends BattleClause {
    private Class<? extends AbilityBase>[] abilities;

    public AbilityClause(String id, Class<? extends AbilityBase> ... abilities) {
        super(id);
        this.abilities = abilities;
        ArrayHelper.validateArrayNonNull(abilities);
    }

    @Override
    public boolean validateSingle(PokemonLink pokemon) {
        EnumPokemon species;
        ItemHeld heldItem = pokemon.getHeldItem();
        if (PixelmonWrapper.canMegaEvolve(heldItem, species = pokemon.getBaseStats().pokemon, pokemon.getForm())) {
            ItemMegaStone megaStone = (ItemMegaStone)heldItem;
            Optional<BaseStats> megaStats = Entity3HasStats.getBaseStats(species, megaStone.form);
            if (megaStats.isPresent()) {
                Class<?> megaAbilityClass;
                AbilityBase megaAbility = AbilityBase.getAbility(megaStats.get().abilities[0]).orElse(null);
                Class<?> clazz = megaAbilityClass = megaAbility == null ? null : megaAbility.getClass();
                if (ArrayHelper.contains(this.abilities, megaAbilityClass)) {
                    return false;
                }
            }
        }
        return !pokemon.getAbility().isAbility(this.abilities);
    }
}

