/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.blocks.tileEntities;

import com.pixelmonmod.pixelmon.blocks.enums.EnumPokechestVisibility;
import com.pixelmonmod.pixelmon.blocks.tileEntities.EnumPokegiftType;
import com.pixelmonmod.pixelmon.config.PixelmonEntityList;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.util.LootClaim;
import java.util.ArrayList;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.WorldServer;

public class TileEntityPokegift
extends TileEntity {
    private EnumPokechestVisibility visibility = EnumPokechestVisibility.Visible;
    private UUID ownerID = null;
    private boolean chestOneTime = true;
    private boolean dropOneTime = true;
    private EntityPixelmon pixelmon = null;
    private NBTTagCompound nbtPixelmon = new NBTTagCompound();
    private ArrayList<EntityPixelmon> specialPixelmon = new ArrayList();
    private ArrayList<NBTTagCompound> nbtSpecialPixelmon = new ArrayList();
    private EnumPokegiftType type = EnumPokegiftType.GIFT;
    private ArrayList<LootClaim> claimed = new ArrayList();

    public void setOwner(UUID id) {
        this.ownerID = id;
    }

    public UUID getOwner() {
        return this.ownerID;
    }

    public void setType(EnumPokegiftType t) {
        this.type = t;
    }

    public EnumPokegiftType getType() {
        return this.type;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tagger) {
        int i;
        super.func_189515_b(tagger);
        tagger.func_74772_a("ownerIDMost", this.ownerID == null ? -1L : this.ownerID.getMostSignificantBits());
        tagger.func_74772_a("ownerIDLeast", this.ownerID == null ? -1L : this.ownerID.getLeastSignificantBits());
        tagger.func_74757_a("chestOneTime", this.chestOneTime);
        tagger.func_74757_a("dropOneTime", this.dropOneTime);
        if (!this.claimed.isEmpty()) {
            NBTTagCompound claimedTag = new NBTTagCompound();
            for (i = 0; i < this.claimed.size(); ++i) {
                NBTTagCompound playerInfoTag = new NBTTagCompound();
                LootClaim playerClaim = this.claimed.get(i);
                playerInfoTag.func_74772_a("most", playerClaim.getPlayerID().getMostSignificantBits());
                playerInfoTag.func_74772_a("least", playerClaim.getPlayerID().getLeastSignificantBits());
                playerInfoTag.func_74772_a("timeClaimed", playerClaim.getTimeClaimed());
                claimedTag.func_74782_a("player" + i, (NBTBase)playerInfoTag);
            }
            tagger.func_74782_a("claimedPlayers", (NBTBase)claimedTag);
        }
        tagger.func_74768_a("type", this.type.ordinal());
        if (!this.nbtPixelmon.func_82582_d()) {
            if (this.pixelmon != null) {
                this.pixelmon.func_70014_b(this.nbtPixelmon);
            }
            tagger.func_74782_a("pixelmon", (NBTBase)this.nbtPixelmon);
        } else if (this.type == EnumPokegiftType.EVENT) {
            if (!this.specialPixelmon.isEmpty()) {
                for (EntityPixelmon p : this.specialPixelmon) {
                    NBTTagCompound nbt = new NBTTagCompound();
                    p.func_70014_b(nbt);
                    this.nbtSpecialPixelmon.add(nbt);
                }
            }
            if (!this.nbtSpecialPixelmon.isEmpty()) {
                NBTTagCompound specialTag = new NBTTagCompound();
                for (i = 0; i < this.nbtSpecialPixelmon.size(); ++i) {
                    specialTag.func_74782_a("special" + i, (NBTBase)this.nbtSpecialPixelmon.get(i));
                }
                tagger.func_74782_a("specials", (NBTBase)specialTag);
            }
        }
        return tagger;
    }

    public void func_145839_a(NBTTagCompound tagger) {
        int i;
        if (tagger.func_74763_f("ownerIDMost") != -1L) {
            this.ownerID = new UUID(tagger.func_74763_f("ownerIDMost"), tagger.func_74763_f("ownerIDLeast"));
        }
        this.chestOneTime = tagger.func_74767_n("chestOneTime");
        this.dropOneTime = tagger.func_74767_n("dropOneTime");
        if (tagger.func_74764_b("claimedPlayers")) {
            NBTTagCompound claimedTag = (NBTTagCompound)tagger.func_74781_a("claimedPlayers");
            i = 0;
            while (claimedTag.func_74764_b("player" + i)) {
                NBTTagCompound playerTag = (NBTTagCompound)claimedTag.func_74781_a("player" + i);
                this.claimed.add(new LootClaim(new UUID(playerTag.func_74763_f("most"), playerTag.func_74763_f("least")), playerTag.func_74763_f("timeClaimed")));
                ++i;
            }
        }
        this.type = EnumPokegiftType.values()[tagger.func_74762_e("type")];
        if (this.type == EnumPokegiftType.GIFT) {
            this.nbtPixelmon = tagger.func_74775_l("pixelmon");
        } else if (tagger.func_74764_b("specials")) {
            NBTTagCompound specialTag = (NBTTagCompound)tagger.func_74781_a("specials");
            i = 0;
            while (specialTag.func_74764_b("special" + i)) {
                NBTTagCompound nbt = (NBTTagCompound)specialTag.func_74781_a("special" + i);
                this.nbtSpecialPixelmon.add(nbt);
                ++i;
            }
        }
        super.func_145839_a(tagger);
    }

    public boolean canClaim(UUID playerID) {
        if (!this.dropOneTime) {
            return true;
        }
        LootClaim claim = this.getLootClaim(playerID);
        return claim == null;
    }

    public LootClaim getLootClaim(UUID playerID) {
        for (LootClaim claim : this.claimed) {
            if (!claim.getPlayerID().toString().equals(playerID.toString())) continue;
            return claim;
        }
        return null;
    }

    public void addClaimer(UUID playerID) {
        if (this.dropOneTime) {
            this.claimed.add(new LootClaim(playerID, System.currentTimeMillis()));
        }
    }

    public void removeClaimer(UUID playerID) {
        this.claimed.remove(this.getLootClaim(playerID));
    }

    public boolean shouldBreakBlock() {
        return this.chestOneTime;
    }

    public void setChestOneTime(boolean val) {
        this.chestOneTime = val;
    }

    public boolean getChestMode() {
        return this.chestOneTime;
    }

    public void setDropOneTime(boolean val) {
        this.dropOneTime = val;
    }

    public boolean getDropMode() {
        return this.dropOneTime;
    }

    public boolean isUsableByPlayer(EntityPlayer player) {
        return this.field_145850_b.func_175625_s(this.field_174879_c) == this && player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) < 64.0;
    }

    public EntityPixelmon getPixelmon() {
        if (this.pixelmon == null && !this.nbtPixelmon.func_82582_d()) {
            this.pixelmon = (EntityPixelmon)PixelmonEntityList.createEntityFromNBT(this.nbtPixelmon, this.field_145850_b);
        }
        return this.pixelmon;
    }

    public ArrayList<EntityPixelmon> getSpecialPixelmon() {
        if (this.specialPixelmon.isEmpty() && !this.nbtSpecialPixelmon.isEmpty()) {
            for (NBTTagCompound nbt : this.nbtSpecialPixelmon) {
                EntityPixelmon p = (EntityPixelmon)PixelmonEntityList.createEntityFromNBT(nbt, this.field_145850_b);
                this.specialPixelmon.add(p);
            }
        }
        return this.specialPixelmon;
    }

    public void setPixelmon(EntityPixelmon pixelmon) {
        this.pixelmon = pixelmon;
        pixelmon.func_70014_b(this.nbtPixelmon);
    }

    public void setAllSpecialPixelmon(ArrayList<EntityPixelmon> pixelmon) {
        this.specialPixelmon.clear();
        this.specialPixelmon.addAll(pixelmon);
    }

    public void setSpecialPixelmon(EntityPixelmon pixelmon) {
        this.specialPixelmon.add(pixelmon);
    }

    public EnumPokechestVisibility getVisibility() {
        return this.visibility;
    }

    public void setVisibility(EnumPokechestVisibility visible) {
        this.visibility = visible;
        ((WorldServer)this.field_145850_b).func_184164_w().func_180244_a(this.field_174879_c);
    }
}

