/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.pokechecker;

import com.pixelmonmod.pixelmon.client.ServerStorageDisplay;
import com.pixelmonmod.pixelmon.client.SoundHelper;
import com.pixelmonmod.pixelmon.client.gui.GuiHelper;
import com.pixelmonmod.pixelmon.client.gui.GuiResources;
import com.pixelmonmod.pixelmon.client.gui.pc.GuiPC;
import com.pixelmonmod.pixelmon.client.gui.pokechecker.GuiPokeCheckerTabs;
import com.pixelmonmod.pixelmon.client.gui.pokechecker.GuiRenamePokemon;
import com.pixelmonmod.pixelmon.client.gui.pokechecker.GuiScreenPokeCheckerMoves;
import com.pixelmonmod.pixelmon.client.gui.pokechecker.GuiScreenPokeCheckerStats;
import com.pixelmonmod.pixelmon.client.gui.pokechecker.GuiScreenPokeCheckerWarningLevel;
import com.pixelmonmod.pixelmon.comm.PixelmonData;
import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import com.pixelmonmod.pixelmon.entities.pixelmon.Entity1Base;
import com.pixelmonmod.pixelmon.enums.EnumType;
import com.pixelmonmod.pixelmon.gui.ContainerEmpty;
import java.io.IOException;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.inventory.Container;
import net.minecraft.util.text.translation.I18n;
import org.lwjgl.opengl.GL11;

public class GuiScreenPokeChecker
extends GuiContainer {
    protected PixelmonData targetPacket;
    GuiButton nameButton;
    boolean renameButton;
    boolean isPC;
    int box;

    public GuiScreenPokeChecker(PixelmonData PixelmonData2, boolean b) {
        super((Container)new ContainerEmpty());
        this.targetPacket = PixelmonData2;
        this.isPC = b;
    }

    public GuiScreenPokeChecker(PixelmonData selected, boolean b, int box) {
        this(selected, b);
        this.box = box;
    }

    public boolean func_73868_f() {
        return true;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.clear();
        this.field_146292_n.add(new GuiPokeCheckerTabs(3, 0, this.field_146294_l / 2 + 107, this.field_146295_m / 2 + 80, 17, 15, ""));
        this.field_146292_n.add(new GuiPokeCheckerTabs(1, 1, this.field_146294_l / 2 - 34, this.field_146295_m / 2 + 80, 69, 15, I18n.func_74838_a((String)"gui.screenpokechecker.moves")));
        this.field_146292_n.add(new GuiPokeCheckerTabs(2, 2, this.field_146294_l / 2 + 36, this.field_146295_m / 2 + 80, 69, 15, I18n.func_74838_a((String)"gui.screenpokechecker.stats")));
        this.field_146292_n.add(new GuiPokeCheckerTabs(4, 4, this.field_146294_l / 2 - 44, this.field_146295_m / 2 - 107, 9, 9, "", this.targetPacket));
        this.field_146292_n.add(new GuiPokeCheckerTabs(7, 5, this.field_146294_l / 2 - 44, this.field_146295_m / 2 - 1, 9, 8, "", this.targetPacket));
    }

    public void func_146284_a(GuiButton button) {
        switch (button.field_146127_k) {
            case 0: {
                this.closeScreen();
                break;
            }
            case 1: {
                this.field_146297_k.func_147108_a((GuiScreen)new GuiScreenPokeCheckerMoves(this.targetPacket, this.isPC, this.box));
                break;
            }
            case 2: {
                this.field_146297_k.func_147108_a((GuiScreen)new GuiScreenPokeCheckerStats(this.targetPacket, this.isPC, this.box));
                break;
            }
            case 3: {
                if (!PixelmonConfig.allowNicknames || this.targetPacket.isEgg) break;
                this.field_146297_k.func_147108_a((GuiScreen)new GuiRenamePokemon(this.targetPacket, this));
                break;
            }
            case 4: {
                this.field_146297_k.func_147108_a((GuiScreen)new GuiScreenPokeCheckerWarningLevel(this, this.targetPacket));
                break;
            }
            case 5: {
                if (!PixelmonConfig.allowNicknames || this.targetPacket.isEgg) break;
                this.field_146297_k.func_147108_a((GuiScreen)new GuiRenamePokemon(this.targetPacket, this));
            }
        }
    }

    private void closeScreen() {
        if (!this.isPC) {
            this.field_146297_k.field_71439_g.func_71053_j();
        } else {
            GuiPC gui = new GuiPC(this.targetPacket, this.box);
            this.field_146297_k.func_147108_a((GuiScreen)gui);
        }
    }

    public void func_146281_b() {
        super.func_146281_b();
    }

    protected void func_73869_a(char par1, int par2) {
        if (par2 == 1) {
            this.closeScreen();
        }
    }

    protected void func_73864_a(int x, int y, int par3) throws IOException {
        ScaledResolution var5 = new ScaledResolution(this.field_146297_k);
        int var6 = var5.func_78326_a();
        int var7 = var5.func_78328_b();
        super.func_73864_a(x, y, par3);
        if (x > var6 / 2 - 125 && x < var6 / 2 - 40 && y > var7 / 2 - 15 && y < var7 / 2 + 5) {
            if (par3 == 1 && !this.renameButton) {
                this.nameButton = new GuiButton(3, x, y, 50, 20, I18n.func_74838_a((String)"gui.screenpokechecker.rename"));
                this.field_146292_n.add(this.nameButton);
                this.renameButton = true;
            } else if (par3 != 1 && this.renameButton) {
                this.field_146292_n.remove(this.nameButton);
                this.renameButton = false;
            } else if (par3 == 1 && this.renameButton) {
                this.field_146292_n.remove(this.nameButton);
                this.nameButton = new GuiButton(3, x, y, 50, 20, I18n.func_74838_a((String)"gui.screenpokechecker.rename"));
                this.field_146292_n.add(this.nameButton);
            }
        }
        this.arrowsMouseClicked(x, y);
    }

    public void func_146979_b(int par1, int par2) {
        GL11.glNormal3f((float)0.0f, (float)-1.0f, (float)0.0f);
        if (!this.targetPacket.isEgg) {
            this.func_73731_b(this.field_146297_k.field_71466_p, I18n.func_74838_a((String)"gui.screenpokechecker.lvl") + " " + this.targetPacket.lvl, 10, -14, 0xFFFFFF);
            this.func_73731_b(this.field_146297_k.field_71466_p, I18n.func_74838_a((String)"gui.screenpokechecker.number") + " " + String.valueOf(this.targetPacket.getNationalPokedexNumber()), -30, -14, 0xFFFFFF);
            if (this.targetPacket.isFainted) {
                this.func_73731_b(this.field_146297_k.field_71466_p, I18n.func_74838_a((String)"gui.screenpokechecker.fainted"), 117, -13, 0xFFFFFF);
            } else {
                this.func_73732_a(this.field_146297_k.field_71466_p, this.targetPacket.health + "/" + this.targetPacket.hp, 140, -13, 0xDDDDDD);
            }
        } else {
            this.func_73731_b(this.field_146297_k.field_71466_p, I18n.func_74838_a((String)"gui.screenpokechecker.lvl") + " ???", 10, -14, 0xFFFFFF);
            this.func_73731_b(this.field_146297_k.field_71466_p, I18n.func_74838_a((String)"gui.screenpokechecker.number") + " ???", -30, -14, 0xFFFFFF);
            this.func_73732_a(this.field_146297_k.field_71466_p, "???/???", 140, -13, 0xDDDDDD);
        }
        this.func_73731_b(this.field_146297_k.field_71466_p, I18n.func_74838_a((String)"gui.screenpokechecker.status"), -9, 113, 0xFFFFFF);
        this.func_73731_b(this.field_146297_k.field_71466_p, I18n.func_74838_a((String)"gui.screenpokechecker.texp"), 107, 40, 0xFFFFFF);
        this.func_73732_a(this.field_146297_k.field_71466_p, I18n.func_74838_a((String)"gui.screenpokechecker.levelup"), 134, 74, 0xFFFFFF);
        if (!this.targetPacket.isEgg) {
            this.func_73732_a(this.field_146297_k.field_71466_p, String.valueOf(this.targetPacket.xp), 135, 55, 0xFFFFFF);
            this.func_73732_a(this.field_146297_k.field_71466_p, String.valueOf(this.targetPacket.nextLvlXP), 135, 90, 0xFFFFFF);
        } else {
            this.func_73732_a(this.field_146297_k.field_71466_p, String.valueOf("???"), 135, 55, 0xFFFFFF);
            this.func_73732_a(this.field_146297_k.field_71466_p, String.valueOf("???"), 135, 90, 0xFFFFFF);
        }
        this.func_73731_b(this.field_146297_k.field_71466_p, I18n.func_74838_a((String)"gui.screenpokechecker.summary"), -15, 166, 0xFFFFFF);
        this.func_73731_b(this.field_146297_k.field_71466_p, I18n.func_74838_a((String)"gui.screenpokechecker.ability"), 75, 117, 0xFFFFFF);
        if (!this.targetPacket.isEgg) {
            try {
                this.func_73731_b(this.field_146297_k.field_71466_p, I18n.func_74838_a((String)("ability." + this.targetPacket.ability + ".name")), 130, 117, 0xFFFFFF);
                this.drawSplitString(I18n.func_74838_a((String)("ability." + this.targetPacket.ability + ".description")), 62, 130, 145, 0xFFFFFF);
            }
            catch (Exception e) {
                this.func_73731_b(this.field_146297_k.field_71466_p, I18n.func_74838_a((String)"ability.ComingSoon.name"), 130, 117, 0xFFFFFF);
                this.drawSplitString(I18n.func_74838_a((String)"ability.ComingSoon.description"), 62, 130, 145, 0xFFFFFF);
            }
        } else {
            this.func_73731_b(this.field_146297_k.field_71466_p, I18n.func_74838_a((String)"ability.Egg.name"), 130, 117, 0xFFFFFF);
            this.drawSplitString(this.targetPacket.eggDescription, 62, 130, 145, 0xFFFFFF);
        }
        this.drawBasePokemonInfo();
    }

    protected void drawBasePokemonInfo() {
        GuiHelper.bindPokemonSprite(this.targetPacket, this.field_146297_k);
        if (this.targetPacket.isGen6Sprite()) {
            GuiHelper.drawImageQuad(-33.0, 9.0, 76.0, 76.0f, 0.0, 0.0, 1.0, 1.0, this.field_73735_i);
        } else {
            GuiHelper.drawImageQuad(-33.0, -2.0, 84.0, 84.0f, 0.0, 0.0, 1.0, 1.0, this.field_73735_i);
        }
        if (!this.targetPacket.isEgg) {
            EnumType type1 = this.targetPacket.getType1();
            EnumType type2 = this.targetPacket.getType2();
            float x = type1.textureX;
            float y = type1.textureY;
            float x1 = 0.0f;
            float y1 = 0.0f;
            if (type2 != null) {
                x1 = type2.textureX;
                y1 = type2.textureY;
            }
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.field_146297_k.field_71446_o.func_110577_a(GuiResources.types);
            if (type2 != EnumType.Mystery && type2 != null) {
                GuiHelper.drawImageQuad(8.0, 0.0, 21.0, 21.0f, x1 / 495.0f, y1 / 392.0f, (x1 + 98.0f) / 495.0f, (y1 + 98.0f) / 392.0f, this.field_73735_i);
                GuiHelper.drawImageQuad(-14.0, 0.0, 21.0, 21.0f, x / 495.0f, y / 392.0f, (x + 98.0f) / 495.0f, (y + 98.0f) / 392.0f, this.field_73735_i);
            } else {
                GuiHelper.drawImageQuad(-2.0, 0.0, 21.0, 21.0f, x / 495.0f, y / 392.0f, (x + 98.0f) / 495.0f, (y + 98.0f) / 392.0f, this.field_73735_i);
            }
        }
        if (this.targetPacket.isShiny) {
            this.field_146297_k.field_71446_o.func_110577_a(GuiResources.shiny);
            GuiHelper.drawImageQuad(-35.0, 73.0, 10.0, 10.0f, 0.0, 0.0, 1.0, 1.0, this.field_73735_i);
        }
    }

    public void func_146976_a(float f, int i, int i1) {
        ScaledResolution var5 = new ScaledResolution(this.field_146297_k);
        var5.func_78326_a();
        var5.func_78328_b();
        this.field_146297_k.field_71446_o.func_110577_a(GuiResources.summarySummary);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.func_73729_b((this.field_146294_l - this.field_146999_f) / 2 - 40, (this.field_146295_m - this.field_147000_g) / 2 - 25, 0, 0, 256, 204);
        this.func_73729_b((this.field_146294_l - this.field_146999_f) / 2 - 15, (this.field_146295_m - this.field_147000_g) / 2 + 127, 23, 225, 44, 28);
        this.drawHealthBar((this.field_146294_l - this.field_146999_f) / 2 + 59, (this.field_146295_m - this.field_147000_g) / 2 - 18, 154, 14, this.targetPacket);
        this.func_73729_b((this.field_146294_l - this.field_146999_f) / 2 + 59, (this.field_146295_m - this.field_147000_g) / 2 - 18, 103, 222, 150, 16);
        this.drawExpBar((this.field_146294_l - this.field_146999_f) / 2 + 86, (this.field_146295_m - this.field_147000_g) / 2, 122, 14, this.targetPacket);
        this.func_73729_b((this.field_146294_l - this.field_146999_f) / 2 + 59, (this.field_146295_m - this.field_147000_g) / 2, 104, 239, 150, 16);
        float[] texturePair = this.targetPacket.getStatusTexture();
        float textureX1 = texturePair[0];
        float textureY1 = texturePair[1];
        this.field_146297_k.field_71446_o.func_110577_a(GuiResources.status);
        if (textureX1 != -1.0f) {
            GuiHelper.drawImageQuad((this.field_146294_l - this.field_146999_f) / 2 - 29, (float)((this.field_146295_m - this.field_147000_g) / 2) + 126.5f, 72.0, 31.5f, textureX1 / 299.0f, textureY1 / 210.0f, (textureX1 + 147.0f) / 299.0f, (textureY1 + 68.0f) / 210.0f, this.field_73735_i);
        } else {
            GuiHelper.drawImageQuad((this.field_146294_l - this.field_146999_f) / 2 - 29, (float)((this.field_146295_m - this.field_147000_g) / 2) + 126.5f, 72.0, 31.5f, 0.0033444815780967474, 0.6761904954910278, 0.4949832856655121, 1.0, this.field_73735_i);
        }
        this.drawPokemonName();
        this.drawArrows(i, i1);
    }

    protected void drawPokemonName() {
        if (this.targetPacket.isEgg) {
            this.drawCenteredStringWithoutShadow(Entity1Base.getLocalizedName("Egg"), (this.field_146294_l - this.field_146999_f) / 2 + 7, (this.field_146295_m - this.field_147000_g) / 2 + 88, 0xFFFFFF);
        } else {
            this.drawCenteredStringWithoutShadow("(" + Entity1Base.getLocalizedName(this.targetPacket.name) + ")", (this.field_146294_l - this.field_146999_f) / 2 + 7, (this.field_146295_m - this.field_147000_g) / 2 + 91, 0xFFFFFF);
            this.drawCenteredStringWithoutShadow(this.targetPacket.getNickname(), (this.field_146294_l - this.field_146999_f) / 2 + 7, (this.field_146295_m - this.field_147000_g) / 2 + 83, 0xFFFFFF);
        }
    }

    public void arrowsMouseClicked(int x, int y) {
        if (this.isPC) {
            return;
        }
        int l1 = (this.field_146294_l - this.field_146999_f) / 2 + 220;
        int l2 = (this.field_146294_l - this.field_146999_f) / 2 - 62;
        int w = 16;
        int t = (this.field_146295_m - this.field_147000_g) / 2;
        int h = 21;
        if (y > t && y < t + h) {
            if (x > l1 && x < l1 + w) {
                SoundHelper.playButtonPressSound();
                this.getNextPokemon();
            }
            if (x > l2 && x < l2 + w) {
                SoundHelper.playButtonPressSound();
                this.getPrevPokemon();
            }
        }
    }

    private void getPrevPokemon() {
        if (!this.isPC) {
            int pos = this.targetPacket.order;
            this.targetPacket = ServerStorageDisplay.getPrevFromPos(pos);
        }
    }

    private void getNextPokemon() {
        if (!this.isPC) {
            int pos = this.targetPacket.order;
            this.targetPacket = ServerStorageDisplay.getNextFromPos(pos);
        }
    }

    public void drawArrows(int mouseX, int mouseY) {
        if (this.isPC) {
            return;
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.field_71446_o.func_110577_a(GuiResources.summaryMoves);
        int l1 = (this.field_146294_l - this.field_146999_f) / 2 + 220;
        int l2 = (this.field_146294_l - this.field_146999_f) / 2 - 62;
        int w = 16;
        int t = (this.field_146295_m - this.field_147000_g) / 2;
        int h = 21;
        this.func_73729_b(l1, t, 24, 207, w, h);
        this.func_73729_b(l2, t, 42, 207, w, h);
        if (mouseY > t && mouseY < t + h) {
            if (mouseX > l1 && mouseX < l1 + w) {
                this.func_73729_b(l1, t, 60, 207, w, h);
            }
            if (mouseX > l2 && mouseX < l2 + w) {
                this.func_73729_b(l2, t, 78, 207, w, h);
            }
        }
    }

    private void drawExpBar(int x, int y, int width, int height, PixelmonData p) {
        GlStateManager.func_179091_B();
        GlStateManager.func_179142_g();
        GlStateManager.func_179094_E();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        GlStateManager.func_179090_x();
        int barWidth = !p.isEgg ? (int)((float)p.xp / (float)p.nextLvlXP * ((float)width - 6.0f)) : (int)(0.0f * ((float)width - 6.0f));
        buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        buffer.func_181662_b((double)x, (double)y, 0.0).func_181666_a(0.0f, 0.0f, 0.4f, 1.0f).func_181675_d();
        buffer.func_181662_b((double)x, (double)(y + height), 0.0).func_181666_a(0.0f, 0.0f, 0.4f, 1.0f).func_181675_d();
        buffer.func_181662_b((double)(x + width), (double)(y + height), 0.0).func_181666_a(0.0f, 0.0f, 0.4f, 1.0f).func_181675_d();
        buffer.func_181662_b((double)(x + width), (double)y, 0.0).func_181666_a(0.0f, 0.0f, 0.4f, 1.0f).func_181675_d();
        buffer.func_181662_b((double)x, (double)y, 0.0).func_181666_a(0.3f, 1.0f, 1.0f, 1.0f).func_181675_d();
        buffer.func_181662_b((double)x, (double)(y + height), 0.0).func_181666_a(0.3f, 1.0f, 1.0f, 1.0f).func_181675_d();
        buffer.func_181662_b((double)(x + barWidth), (double)(y + height), 0.0).func_181666_a(0.3f, 1.0f, 1.0f, 1.0f).func_181675_d();
        buffer.func_181662_b((double)(x + barWidth), (double)y, 0.0).func_181666_a(0.3f, 1.0f, 1.0f, 1.0f).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179121_F();
        GlStateManager.func_179098_w();
        GlStateManager.func_179101_C();
        GlStateManager.func_179119_h();
    }

    public void drawHealthBar(int x, int y, int width, int height, PixelmonData p) {
        GlStateManager.func_179091_B();
        GlStateManager.func_179142_g();
        GlStateManager.func_179094_E();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        GlStateManager.func_179090_x();
        int barWidth = width - 6;
        buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        buffer.func_181662_b((double)x, (double)y, 0.0).func_181666_a(1.0f, 0.2f, 0.2f, 1.0f).func_181675_d();
        buffer.func_181662_b((double)x, (double)(y + height), 0.0).func_181666_a(1.0f, 0.2f, 0.2f, 1.0f).func_181675_d();
        buffer.func_181662_b((double)(x + barWidth), (double)(y + height), 0.0).func_181666_a(1.0f, 0.2f, 0.2f, 1.0f).func_181675_d();
        buffer.func_181662_b((double)(x + barWidth), (double)y, 0.0).func_181666_a(1.0f, 0.2f, 0.2f, 1.0f).func_181675_d();
        float healthFraction = p.isEgg ? 1.0f : (float)p.health / (float)p.hp;
        barWidth = (int)(healthFraction * ((float)width - 24.0f)) + 18;
        buffer.func_181662_b((double)x, (double)y, 0.0).func_181666_a(0.2f, 1.0f, 0.2f, 1.0f).func_181675_d();
        buffer.func_181662_b((double)x, (double)(y + height), 0.0).func_181666_a(0.2f, 1.0f, 0.2f, 1.0f).func_181675_d();
        buffer.func_181662_b((double)(x + barWidth), (double)(y + height), 0.0).func_181666_a(0.2f, 1.0f, 0.2f, 1.0f).func_181675_d();
        buffer.func_181662_b((double)(x + barWidth), (double)y, 0.0).func_181666_a(0.2f, 1.0f, 0.2f, 1.0f).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179121_F();
        GlStateManager.func_179098_w();
        GlStateManager.func_179101_C();
        GlStateManager.func_179119_h();
    }

    public void drawCenteredStringWithoutShadow(String par2Str, int par3, int par4, int par5) {
        this.field_146297_k.field_71466_p.func_78276_b(par2Str, par3 - this.field_146297_k.field_71466_p.func_78256_a(par2Str) / 2, par4, par5);
    }

    public void drawSplitString(String par2str, int par3, int par4, int par5, int par6) {
        this.field_146297_k.field_71466_p.func_78279_b(par2str, par3, par4, par5, par6);
    }
}

