/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.pokemoneditor;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.client.gui.GuiHelper;
import com.pixelmonmod.pixelmon.client.gui.GuiResources;
import com.pixelmonmod.pixelmon.client.gui.pokemoneditor.GuiImportExport;
import com.pixelmonmod.pixelmon.client.gui.pokemoneditor.GuiIndividualEditorBase;
import com.pixelmonmod.pixelmon.client.gui.pokemoneditor.GuiPokemonEditorParty;
import com.pixelmonmod.pixelmon.client.gui.pokemoneditor.IImportableContainer;
import com.pixelmonmod.pixelmon.client.gui.pokemoneditor.ImportExportConverter;
import com.pixelmonmod.pixelmon.comm.PixelmonData;
import com.pixelmonmod.pixelmon.gui.ContainerEmpty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.inventory.Container;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public abstract class GuiPartyEditorBase
extends GuiContainer
implements IImportableContainer {
    private static final int BUTTON_OKAY = 1;
    private static final int BUTTON_RANDOM = 10;
    private static final int BUTTON_IMPORT_EXPORT = 11;
    public List<PixelmonData> pokemonList;
    private List<GuiButton> pokemonButtons = new ArrayList<GuiButton>();

    protected GuiPartyEditorBase(List<PixelmonData> pokemonList) {
        super((Container)new ContainerEmpty());
        this.pokemonList = pokemonList;
    }

    public void func_73866_w_() {
        this.field_146292_n.add(new GuiButton(1, this.field_146294_l / 2 + 155, this.field_146295_m / 2 + 90, 30, 20, I18n.func_74838_a((String)"gui.guiItemDrops.ok")));
        this.field_146292_n.add(new GuiButton(10, this.field_146294_l / 2 - 160, this.field_146295_m / 2 + 90, 100, 20, I18n.func_74838_a((String)"gui.trainereditor.randomise")));
        this.field_146292_n.add(new GuiButton(11, this.field_146294_l / 2 + 20, this.field_146295_m / 2 + 90, 100, 20, I18n.func_74838_a((String)"gui.pokemoneditor.importexport")));
        super.func_73866_w_();
        for (int i = 0; i < 6; ++i) {
            GuiButton pokeButton = new GuiButton(i + 2, this.field_146294_l / 2 + 40, this.field_146295_m / 2 - 50 + i * 20, 80, 20, I18n.func_74838_a((String)"gui.trainereditor.edit"));
            this.field_146292_n.add(pokeButton);
            this.pokemonButtons.add(pokeButton);
        }
    }

    protected void func_146976_a(float f, int i, int j) {
        int k;
        for (int z = 0; z < 6; ++z) {
            GuiButton pokemonButton = this.pokemonButtons.get(z);
            pokemonButton.field_146126_j = z < this.pokemonList.size() && this.pokemonList.get(z) != null ? I18n.func_74838_a((String)"gui.trainereditor.edit") : I18n.func_74838_a((String)"gui.trainereditor.add");
        }
        this.field_146297_k.field_71446_o.func_110577_a(GuiResources.cwPanel);
        GuiHelper.drawImageQuad(this.field_146294_l / 2 - 200, this.field_146295_m / 2 - 120, 400.0, 240.0f, 0.0, 0.0, 1.0, 1.0, this.field_73735_i);
        RenderHelper.func_74518_a();
        String title = this.getTitle();
        this.field_146297_k.field_71466_p.func_78276_b(title, this.field_146294_l / 2 - this.field_146297_k.field_71466_p.func_78256_a(title) / 2, this.field_146295_m / 2 - 90, 0);
        this.field_146297_k.field_71466_p.func_78276_b(I18n.func_74838_a((String)"gui.trainereditor.name"), this.field_146294_l / 2 - 130, this.field_146295_m / 2 - 65, 0);
        this.field_146297_k.field_71466_p.func_78276_b(I18n.func_74838_a((String)"gui.trainereditor.lvl"), this.field_146294_l / 2 - 40, this.field_146295_m / 2 - 65, 0);
        for (k = 0; k < 6; ++k) {
            if (k % 2 != 1) continue;
            GuiPartyEditorBase.func_73734_a((int)(this.field_146294_l / 2 - 160), (int)(this.field_146295_m / 2 - 50 + k * 20), (int)(this.field_146294_l / 2 + 40), (int)(this.field_146295_m / 2 - 30 + k * 20), (int)-1777215);
        }
        for (k = 0; k < this.pokemonList.size(); ++k) {
            PixelmonData p = this.pokemonList.get(k);
            if (p == null) continue;
            this.field_146297_k.field_71466_p.func_78276_b(p.getNickname(), this.field_146294_l / 2 - 130, this.field_146295_m / 2 - 44 + k * 20, 0);
            this.field_146297_k.field_71466_p.func_78276_b("" + p.lvl, this.field_146294_l / 2 - 40, this.field_146295_m / 2 - 44 + k * 20, 0);
            GuiHelper.bindPokemonSprite(p, this.field_146297_k);
            GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
            GuiHelper.drawImageQuad(this.field_146294_l / 2 - 157, this.field_146295_m / 2 - 53 - (p.isGen6Sprite() ? -3 : 0) + k * 20, 20.0, 20.0f, 0.0, 0.0, 1.0, 1.0, 1.0f);
        }
    }

    public abstract String getTitle();

    protected void func_73869_a(char key, int par2) throws IOException {
        if (par2 == 1 || par2 == 28) {
            this.exitScreen();
        }
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        super.func_146284_a(button);
        if (button.field_146124_l) {
            if (button.field_146127_k == 1) {
                this.exitScreen();
            } else if (button.field_146127_k == 10) {
                this.randomizeParty();
            } else if (button.field_146127_k >= 2 && button.field_146127_k < 8) {
                int partySlot = button.field_146127_k - 2;
                if (this.pokemonButtons.get((int)partySlot).field_146126_j.equalsIgnoreCase(I18n.func_74838_a((String)"gui.trainereditor.add"))) {
                    this.addPokemon(partySlot);
                } else {
                    this.editPokemon(partySlot);
                }
            } else if (button.field_146127_k == 11) {
                this.field_146297_k.func_147108_a((GuiScreen)new GuiImportExport(this, this.getTitle()));
            }
        }
    }

    protected abstract void exitScreen();

    protected abstract void randomizeParty();

    protected abstract void addPokemon(int var1);

    protected abstract void editPokemon(int var1);

    public static void editPokemonPacket(int partySlot) {
        GuiIndividualEditorBase individualEditor;
        PixelmonData currentPokemon;
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71462_r instanceof GuiPartyEditorBase) {
            GuiPartyEditorBase partyEditor = (GuiPartyEditorBase)mc.field_71462_r;
            partyEditor.editPokemon(partySlot);
        } else if (mc.field_71462_r instanceof GuiIndividualEditorBase && (currentPokemon = (individualEditor = (GuiIndividualEditorBase)mc.field_71462_r).getPokemonList().get(partySlot)) != null) {
            individualEditor.p = currentPokemon;
            individualEditor.func_73866_w_();
        }
    }

    @Override
    public String getExportText() {
        StringBuilder exportText = new StringBuilder();
        for (int i = 0; i < this.pokemonList.size(); ++i) {
            PixelmonData data = this.pokemonList.get(i);
            if (data == null) continue;
            if (i > 0) {
                exportText.append("\n");
            }
            exportText.append(ImportExportConverter.getExportText(data));
        }
        return exportText.toString();
    }

    @Override
    public String importText(String importText) {
        String[] pokemonSplit = (importText = importText.trim()).split("\n\n");
        if (pokemonSplit.length < 1 || pokemonSplit.length > 6) {
            return "";
        }
        PixelmonData[] importData = new PixelmonData[6];
        for (int i = 0; i < importData.length; ++i) {
            if (i >= pokemonSplit.length) continue;
            importData[i] = new PixelmonData();
            String errorText = ImportExportConverter.importText(pokemonSplit[i], importData[i]);
            if (errorText == null) continue;
            return i + 1 + ", " + errorText;
        }
        try {
            this.pokemonList.clear();
        }
        catch (UnsupportedOperationException i) {
            // empty catch block
        }
        for (int i = 0; i < importData.length; ++i) {
            PixelmonData oldPokemon = null;
            int pokemonListSize = this.pokemonList.size();
            if (pokemonListSize > i) {
                oldPokemon = this.pokemonList.get(i);
            }
            if (importData[i] != null) {
                importData[i].pokemonID = oldPokemon == null ? new int[]{-1, -1} : oldPokemon.pokemonID;
                importData[i].order = i;
                importData[i].OT = GuiPokemonEditorParty.editedPlayerName;
                if (importData[i].OT == null) {
                    importData[i].OT = "";
                }
            }
            if (pokemonListSize > i) {
                this.pokemonList.set(i, importData[i]);
                continue;
            }
            this.pokemonList.add(importData[i]);
        }
        Pixelmon.network.sendToServer(this.getImportSavePacket());
        return null;
    }

    protected abstract IMessage getImportSavePacket();

    @Override
    public GuiScreen getScreen() {
        return this;
    }
}

