/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.pokemoneditor;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.client.ServerStorageDisplay;
import com.pixelmonmod.pixelmon.client.gui.pokemoneditor.GuiIndividualEditorBase;
import com.pixelmonmod.pixelmon.client.gui.pokemoneditor.GuiPokemonEditorParty;
import com.pixelmonmod.pixelmon.comm.PixelmonData;
import com.pixelmonmod.pixelmon.comm.packetHandlers.pokemoneditor.ChangePokemon;
import com.pixelmonmod.pixelmon.comm.packetHandlers.pokemoneditor.DeletePokemon;
import com.pixelmonmod.pixelmon.comm.packetHandlers.pokemoneditor.UpdatePlayerPokemon;
import com.pixelmonmod.pixelmon.config.PixelmonItems;
import com.pixelmonmod.pixelmon.config.PixelmonItemsPokeballs;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.extraStats.LakeTrioStats;
import com.pixelmonmod.pixelmon.enums.EnumPokemon;
import com.pixelmonmod.pixelmon.items.ItemPokeball;
import java.io.IOException;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class GuiPokemonEditorIndividual
extends GuiIndividualEditorBase {
    private GuiTextField pokeBallText;
    private GuiTextField cloneText;
    private GuiTextField lakeText;
    private ItemStack pokeBall;

    GuiPokemonEditorIndividual(PixelmonData p, String titleText) {
        super(p, titleText);
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.pokeBallText = new GuiTextField(16, this.field_146297_k.field_71466_p, this.field_146294_l / 2 - 120, this.field_146295_m / 2 + 72, 90, 17);
        this.pokeBall = new ItemStack((Item)this.p.pokeball.getItem());
        this.pokeBallText.func_146180_a(this.pokeBall.func_82833_r());
        this.textFields.add(this.pokeBallText);
        int formOffset = 20;
        if (this.formText != null) {
            this.formText.field_146210_g += formOffset;
            this.textFields.remove(this.formText);
            this.textFields.add(this.formText);
        } else if (this.p.getSpecies() == EnumPokemon.Mew) {
            this.cloneText = this.createExtraTextField(17);
            this.cloneText.field_146210_g += formOffset;
            this.cloneText.func_146180_a(Integer.toString(this.p.numClones));
            this.textFields.add(this.cloneText);
        } else if (this.p.getNationalPokedexNumber() <= 482 && this.p.getNationalPokedexNumber() >= 480) {
            this.lakeText = this.createExtraTextField(17);
            this.lakeText.field_146210_g += formOffset;
            this.lakeText.func_146180_a(Integer.toString(this.p.numEnchanted));
            this.textFields.add(this.lakeText);
        }
    }

    @Override
    protected void drawBackgroundUnderMenus(float f, int i, int j) {
        super.drawBackgroundUnderMenus(f, i, j);
        if (this.pokeBallText != null) {
            this.pokeBallText.func_146194_f();
            this.field_146297_k.field_71466_p.func_78276_b(I18n.func_74838_a((String)"gui.pokemoneditor.pokeball"), this.field_146294_l / 2 - 180, this.field_146295_m / 2 + 75, 0);
            this.field_146296_j.func_180450_b(this.pokeBall, this.field_146294_l / 2 - 28, this.field_146295_m / 2 + 72);
        }
        this.drawExtraText(this.cloneText, "gui.pokemoneditor.clones");
        this.drawExtraText(this.lakeText, "gui.pokemoneditor.lake_enchants");
    }

    @Override
    protected void func_73869_a(char key, int keyCode) throws IOException {
        super.func_73869_a(key, keyCode);
        if (this.pokeBallText != null) {
            this.pokeBallText.func_146201_a(key, keyCode);
            if (this.pokeBallText.func_146206_l()) {
                this.updatePokeBall();
            }
        }
        if (this.cloneText != null) {
            this.cloneText.func_146201_a(key, keyCode);
        }
        if (this.lakeText != null) {
            this.lakeText.func_146201_a(key, keyCode);
        }
    }

    private void updatePokeBall() {
        Item item = PixelmonItems.getItemFromName(this.pokeBallText.func_146179_b());
        if (!(item instanceof ItemPokeball)) {
            item = PixelmonItemsPokeballs.pokeBall;
        }
        ItemPokeball newPokeBall = (ItemPokeball)item;
        this.pokeBall = new ItemStack((Item)newPokeBall);
        this.p.pokeball = newPokeBall.type;
    }

    @Override
    protected void mouseClickedUnderMenus(int x, int y, int mouseButton) throws IOException {
        super.mouseClickedUnderMenus(x, y, mouseButton);
        for (GuiTextField textField : new GuiTextField[]{this.pokeBallText, this.cloneText, this.lakeText}) {
            if (textField == null) continue;
            textField.func_146192_a(x, y, mouseButton);
        }
    }

    @Override
    protected void changePokemon(EnumPokemon newPokemon) {
        Pixelmon.network.sendToServer((IMessage)new ChangePokemon(this.p.order, newPokemon));
    }

    @Override
    protected void deletePokemon() {
        Pixelmon.network.sendToServer((IMessage)new DeletePokemon(this.p.order));
        this.field_146297_k.func_147108_a((GuiScreen)new GuiPokemonEditorParty());
    }

    @Override
    protected void saveAndClose() {
        Pixelmon.network.sendToServer((IMessage)new UpdatePlayerPokemon(this.p));
        this.field_146297_k.func_147108_a((GuiScreen)new GuiPokemonEditorParty());
    }

    @Override
    public List<PixelmonData> getPokemonList() {
        return ServerStorageDisplay.editedPokemon;
    }

    @Override
    protected boolean checkFields() {
        boolean valid = super.checkFields();
        if (this.cloneText != null) {
            try {
                int numClones = Integer.parseInt(this.cloneText.func_146179_b());
                if (numClones < 0) {
                    this.cloneText.func_146180_a("0");
                    valid = false;
                } else if (numClones > 3) {
                    this.cloneText.func_146180_a(Integer.toString(3));
                    valid = false;
                } else {
                    this.p.numClones = numClones;
                }
            }
            catch (NumberFormatException e) {
                this.cloneText.func_146180_a("");
                valid = false;
            }
        }
        if (this.lakeText != null) {
            try {
                int enchants = Integer.parseInt(this.lakeText.func_146179_b());
                if (enchants < 0) {
                    this.lakeText.func_146180_a("0");
                    valid = false;
                } else if (enchants > LakeTrioStats.MAX_ENCHANTED) {
                    this.lakeText.func_146180_a(Integer.toString(LakeTrioStats.MAX_ENCHANTED));
                    valid = false;
                } else {
                    this.p.numEnchanted = enchants;
                }
            }
            catch (NumberFormatException e) {
                this.lakeText.func_146180_a("");
                valid = false;
            }
        }
        return valid;
    }
}

