/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.pokemoneditor;

import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic.HiddenPower;
import com.pixelmonmod.pixelmon.client.gui.pokemoneditor.FormData;
import com.pixelmonmod.pixelmon.client.gui.pokemoneditor.ImportExportForm;
import com.pixelmonmod.pixelmon.comm.PixelmonData;
import com.pixelmonmod.pixelmon.comm.PixelmonMovesetData;
import com.pixelmonmod.pixelmon.config.PixelmonItems;
import com.pixelmonmod.pixelmon.config.PixelmonServerConfig;
import com.pixelmonmod.pixelmon.entities.pixelmon.Entity3HasStats;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.BaseStats;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.FriendShip;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.Gender;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.IVStore;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.Stats;
import com.pixelmonmod.pixelmon.enums.EnumBossMode;
import com.pixelmonmod.pixelmon.enums.EnumGrowth;
import com.pixelmonmod.pixelmon.enums.EnumNature;
import com.pixelmonmod.pixelmon.enums.EnumPokemon;
import com.pixelmonmod.pixelmon.enums.EnumType;
import com.pixelmonmod.pixelmon.enums.items.EnumPokeballs;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class ImportExportConverter {
    private static final String GENDER_TEXT = "Gender";
    private static final String ABILITY_TEXT = "Ability";
    private static final String LEVEL_TEXT = "Level";
    private static final String SHINY_TEXT = "Shiny";
    private static final String HAPPINESS_TEXT = "Happiness";
    private static final String EV_TEXT = "EVs";
    private static final String NATURE_TEXT = "Nature";
    private static final String IV_TEXT = "IVs";
    private static final String POKE_BALL_TEXT = "Poke Ball";
    private static final String GROWTH_TEXT = "Growth";
    private static final String CLONES_TEXT = "Clones";
    private static final String MOVE_TEXT = "Moves";
    private static final String[] STAT_TEXT = new String[]{"HP", "Atk", "Def", "SpA", "SpD", "Spe"};
    private static final char MALE_SYMBOL = 'M';
    private static final char FEMALE_SYMBOL = 'F';
    private static final String SHINY_YES = "Yes";
    private static final String SPECIAL_TEXTURE = "Special";
    private static Map<String, String> importNameMap;

    private ImportExportConverter() {
    }

    public static String getExportText(PixelmonData data) {
        StringBuilder exportText = new StringBuilder();
        String exportName = ImportExportForm.getInstance().getFormName(data.getSpecies(), data.form);
        String nickname = data.getNickname();
        if (nickname.equals(exportName)) {
            exportText.append(exportName);
        } else {
            exportText.append(nickname);
            exportText.append(" (");
            exportText.append(exportName);
            exportText.append(")");
        }
        if (data.gender != Gender.None) {
            exportText.append(" (");
            exportText.append(data.gender == Gender.Male ? (char)'M' : 'F');
            exportText.append(")");
        }
        if (!data.heldItem.func_190926_b()) {
            exportText.append(" @ ");
            exportText.append(data.heldItem.func_82833_r());
        }
        exportText.append("\n");
        ImportExportConverter.addColonSeparated(exportText, ABILITY_TEXT, ImportExportConverter.convertCamelCaseToWords(data.ability));
        if (data.lvl != PixelmonServerConfig.maxLevel) {
            ImportExportConverter.addColonSeparated(exportText, LEVEL_TEXT, data.lvl);
        }
        if (data.isShiny || data.specialTexture != 0) {
            ImportExportConverter.addColonSeparated(exportText, SHINY_TEXT, data.isShiny ? SHINY_YES : SPECIAL_TEXTURE);
        }
        if (data.friendship < FriendShip.getMaxFriendship()) {
            ImportExportConverter.addColonSeparated(exportText, HAPPINESS_TEXT, data.friendship);
        }
        ImportExportConverter.writeStats(exportText, data.evs, EV_TEXT, 0);
        exportText.append(data.nature.toString());
        exportText.append(" ");
        exportText.append(NATURE_TEXT);
        exportText.append("\n");
        ImportExportConverter.writeStats(exportText, data.ivs, IV_TEXT, 31);
        if (data.pokeball != EnumPokeballs.PokeBall) {
            ImportExportConverter.addColonSeparated(exportText, POKE_BALL_TEXT, data.pokeball);
        }
        ImportExportConverter.addColonSeparated(exportText, GROWTH_TEXT, (Object)data.growth);
        if (data.numClones > 0) {
            ImportExportConverter.addColonSeparated(exportText, CLONES_TEXT, data.numClones);
        }
        for (int i = 0; i < data.moveset.length; ++i) {
            Attack attack;
            if (data.moveset[i] == null || (attack = data.moveset[i].getAttack()) == null) continue;
            exportText.append("- ");
            exportText.append(attack.baseAttack.getUnLocalizedName());
            exportText.append("\n");
        }
        return exportText.toString();
    }

    public static void addLine(StringBuilder builder, String label) {
        builder.append(label);
        builder.append("\n");
    }

    public static void addColonSeparated(StringBuilder builder, String label, Object value) {
        builder.append(label);
        builder.append(": ");
        builder.append(value.toString());
        builder.append("\n");
    }

    private static String convertCamelCaseToWords(String text) {
        if (text == null || text.length() < 2) {
            return text;
        }
        StringBuilder newText = new StringBuilder();
        int textLength = text.length();
        for (int i = 0; i < textLength; ++i) {
            char currentChar = text.charAt(i);
            if (currentChar >= 'A' && currentChar <= 'Z' && i > 0 && i < textLength) {
                newText.append(' ');
            }
            newText.append(currentChar);
        }
        return newText.toString();
    }

    private static void writeStats(StringBuilder exportText, int[] statArray, String statType, int defaultValue) {
        boolean defaultStats = true;
        for (int stat : statArray) {
            if (stat == defaultValue) continue;
            defaultStats = false;
            break;
        }
        if (!defaultStats) {
            exportText.append(statType);
            exportText.append(": ");
            boolean hasPrevious = false;
            for (int i = 0; i < statArray.length; ++i) {
                if (statArray[i] == defaultValue) continue;
                if (hasPrevious) {
                    exportText.append(" / ");
                }
                exportText.append(statArray[i]);
                exportText.append(" ");
                exportText.append(STAT_TEXT[i]);
                hasPrevious = true;
            }
            exportText.append("\n");
        }
    }

    public static String importText(String importText, PixelmonData data) {
        int i;
        PixelmonData tempData = new PixelmonData();
        String[] importTextSplit = importText.split("\n");
        try {
            String heldItemName;
            Item heldItem;
            BaseStats stats;
            int atIndex;
            int rightParenthesesIndex;
            String nextField;
            String currentLine = importTextSplit[0];
            int leftParenthesesIndex = currentLine.lastIndexOf(40);
            int genderIndex = -1;
            if (leftParenthesesIndex > -1 && (nextField = currentLine.substring(leftParenthesesIndex + 1, rightParenthesesIndex = currentLine.indexOf(41, leftParenthesesIndex)).trim()).length() == 1) {
                genderIndex = leftParenthesesIndex;
                char genderChar = nextField.charAt(0);
                if (genderChar == 'M') {
                    tempData.gender = Gender.Male;
                } else if (genderChar == 'F') {
                    tempData.gender = Gender.Female;
                } else {
                    return GENDER_TEXT;
                }
                leftParenthesesIndex = currentLine.lastIndexOf(40, leftParenthesesIndex - 1);
            }
            if (leftParenthesesIndex > -1) {
                tempData.nickname = currentLine.substring(0, leftParenthesesIndex).trim();
                rightParenthesesIndex = currentLine.indexOf(41, leftParenthesesIndex);
                tempData.name = currentLine.substring(leftParenthesesIndex + 1, rightParenthesesIndex);
                atIndex = currentLine.indexOf(64, rightParenthesesIndex);
            } else {
                atIndex = currentLine.indexOf(64);
                tempData.name = genderIndex > -1 ? currentLine.substring(0, genderIndex) : (atIndex > -1 ? currentLine.substring(0, atIndex) : currentLine);
                tempData.nickname = "";
            }
            tempData.name = tempData.name.trim();
            Optional<FormData> formDataOptional = ImportExportForm.getInstance().getFormData(tempData.name);
            if (formDataOptional.isPresent()) {
                FormData formData = formDataOptional.get();
                tempData.name = formData.species.name;
                tempData.form = formData.form;
            } else {
                tempData.name = tempData.name.trim();
                tempData.name = ImportExportConverter.convertName(tempData.name);
            }
            try {
                stats = Entity3HasStats.getBaseStats(tempData.name).get();
            }
            catch (NoSuchElementException e) {
                return "Pok\u00e9mon";
            }
            tempData.nationalPokedexNumber = stats.nationalPokedexNumber;
            if (atIndex > -1 && (heldItem = PixelmonItems.getItemFromName(heldItemName = currentLine.substring(atIndex + 1).trim())) != null) {
                tempData.heldItem = new ItemStack(heldItem);
            }
            tempData.friendship = -1;
            for (int i2 = 0; i2 < data.evs.length; ++i2) {
                tempData.ivs[i2] = 31;
            }
            boolean setIVs = false;
            for (int currentIndex = 1; currentIndex < importTextSplit.length; ++currentIndex) {
                currentLine = importTextSplit[currentIndex];
                if (tempData.ability == null && currentLine.startsWith(ABILITY_TEXT)) {
                    String parsedAbility = ImportExportConverter.getStringAfterColon(currentLine).replace(" ", "");
                    if (parsedAbility.equals("BattleArmor") || parsedAbility.equals("ShellArmor")) {
                        parsedAbility = parsedAbility.replaceAll("o", "ou");
                    }
                    for (String ability : stats.abilities) {
                        if (!parsedAbility.equals(ability)) continue;
                        tempData.ability = parsedAbility;
                        break;
                    }
                    if (tempData.ability != null) continue;
                    return ABILITY_TEXT;
                }
                if (tempData.lvl == 0 && currentLine.startsWith(LEVEL_TEXT)) {
                    int level = Integer.parseInt(ImportExportConverter.getStringAfterColon(currentLine));
                    if (level > 0 && level <= PixelmonServerConfig.maxLevel) {
                        tempData.lvl = level;
                        continue;
                    }
                    return LEVEL_TEXT;
                }
                if (!tempData.isShiny && currentLine.startsWith(SHINY_TEXT)) {
                    String shinyText = ImportExportConverter.getStringAfterColon(currentLine);
                    if (SHINY_YES.equals(shinyText)) {
                        tempData.isShiny = true;
                        continue;
                    }
                    if (SPECIAL_TEXTURE.equals(shinyText)) {
                        tempData.specialTexture = (short)tempData.getSpecies().getSpecialTexture().id;
                        continue;
                    }
                    if ("No".equals(shinyText)) continue;
                    return SHINY_TEXT;
                }
                if (tempData.friendship == -1 && currentLine.startsWith(HAPPINESS_TEXT)) {
                    int friendship = Integer.parseInt(ImportExportConverter.getStringAfterColon(currentLine));
                    if (friendship >= 0 && friendship <= FriendShip.getMaxFriendship()) {
                        tempData.friendship = friendship;
                        continue;
                    }
                    return HAPPINESS_TEXT;
                }
                if (currentLine.startsWith(EV_TEXT)) {
                    ImportExportConverter.parseStats(currentLine, tempData.evs, new StatValidator(){

                        @Override
                        public int validateStat(int statValue, int totalStats) {
                            int limitedStatValue = Math.max(0, Math.min(255, statValue));
                            return Math.min(limitedStatValue, 510 - totalStats);
                        }
                    });
                    continue;
                }
                if (tempData.nature == null && currentLine.endsWith(NATURE_TEXT)) {
                    String natureText = currentLine.substring(0, currentLine.indexOf(32));
                    tempData.nature = EnumNature.natureFromString(natureText);
                    continue;
                }
                if (currentLine.startsWith(IV_TEXT)) {
                    setIVs = true;
                    ImportExportConverter.parseStats(currentLine, tempData.ivs, new StatValidator(){

                        @Override
                        public int validateStat(int statValue, int totalStats) {
                            return Math.max(0, Math.min(31, statValue));
                        }
                    });
                    continue;
                }
                if (tempData.pokeball == null && currentLine.startsWith(POKE_BALL_TEXT)) {
                    try {
                        tempData.pokeball = EnumPokeballs.valueOf(ImportExportConverter.getStringAfterColon(currentLine));
                        continue;
                    }
                    catch (IllegalArgumentException e) {
                        return POKE_BALL_TEXT;
                    }
                }
                if (tempData.growth == null && currentLine.startsWith(GROWTH_TEXT)) {
                    tempData.growth = EnumGrowth.growthFromString(ImportExportConverter.getStringAfterColon(currentLine));
                    if (tempData.growth != null) continue;
                    return GROWTH_TEXT;
                }
                if (currentLine.startsWith(CLONES_TEXT)) {
                    int numClones = Integer.parseInt(ImportExportConverter.getStringAfterColon(currentLine));
                    if (stats.pokemon == EnumPokemon.Mew && numClones >= 0 && numClones <= 3) {
                        tempData.numClones = numClones;
                        continue;
                    }
                    return CLONES_TEXT;
                }
                if (currentLine.isEmpty() || currentLine.charAt(0) != '-' || (currentLine = currentLine.trim()).length() <= 1) continue;
                if (tempData.numMoves >= 4) {
                    return MOVE_TEXT;
                }
                String moveText = currentLine.substring(1).trim();
                if ((moveText = ImportExportConverter.convertName(moveText)).contains("Hidden Power")) {
                    if (!setIVs) {
                        String typeText = moveText.replace("Hidden Power ", "").replace("[", "").replace("]", "");
                        EnumType hiddenPowerType = EnumType.parseType(typeText);
                        if (hiddenPowerType == null) {
                            return MOVE_TEXT;
                        }
                        IVStore ivs = HiddenPower.getOptimalIVs(hiddenPowerType);
                        tempData.ivs = ivs.getArray();
                    }
                    moveText = "Hidden Power";
                }
                if (!Attack.hasAttack(moveText)) {
                    return MOVE_TEXT;
                }
                Attack move = new Attack(moveText);
                tempData.moveset[tempData.numMoves++] = PixelmonMovesetData.createPacket(move);
            }
            if (tempData.ability == null) {
                return ABILITY_TEXT;
            }
            if (tempData.numMoves == 0) {
                return MOVE_TEXT;
            }
            if (tempData.gender == null) {
                tempData.gender = Entity3HasStats.getRandomGender(stats);
            }
            if (tempData.lvl == 0) {
                tempData.lvl = PixelmonServerConfig.maxLevel;
            }
            if (tempData.friendship == -1) {
                tempData.friendship = FriendShip.getMaxFriendship();
            }
            if (tempData.nature == null) {
                tempData.nature = EnumNature.Hardy;
            }
            if (tempData.pokeball == null) {
                tempData.pokeball = EnumPokeballs.PokeBall;
            }
            if (tempData.growth == null) {
                tempData.growth = EnumGrowth.Ordinary;
            }
        }
        catch (IndexOutOfBoundsException | NullPointerException | NumberFormatException | NoSuchElementException e) {
            return "";
        }
        data.nickname = tempData.nickname;
        data.name = tempData.name;
        data.nationalPokedexNumber = tempData.nationalPokedexNumber;
        data.gender = tempData.gender;
        data.heldItem = tempData.heldItem;
        data.ability = tempData.ability;
        data.lvl = tempData.lvl;
        data.isShiny = tempData.isShiny;
        data.specialTexture = tempData.specialTexture;
        data.friendship = tempData.friendship;
        for (i = 0; i < data.evs.length; ++i) {
            data.evs[i] = tempData.evs[i];
            data.ivs[i] = tempData.ivs[i];
        }
        data.nature = tempData.nature;
        data.pokeball = tempData.pokeball;
        data.growth = tempData.growth;
        data.numMoves = tempData.numMoves;
        for (i = 0; i < data.numMoves; ++i) {
            data.moveset[i] = tempData.moveset[i];
        }
        data.bossMode = EnumBossMode.NotBoss;
        data.form = tempData.form;
        data.numClones = tempData.numClones;
        Stats.calculateStatsForData(data);
        return null;
    }

    public static int getIntAfterColon(String string) {
        return Integer.parseInt(ImportExportConverter.getStringAfterColon(string));
    }

    public static String getStringAfterColon(String string) {
        return string.substring(string.indexOf(58) + 1).trim();
    }

    private static void parseStats(String statString, int[] statArray, StatValidator validator) {
        String[] splitStats = ImportExportConverter.getStringAfterColon(statString).split("\\/");
        int totalStats = 0;
        for (String stat : splitStats) {
            stat = stat.trim();
            String statType = stat.substring(stat.lastIndexOf(32) + 1, stat.length());
            for (int i = 0; i < STAT_TEXT.length; ++i) {
                if (!STAT_TEXT[i].equalsIgnoreCase(statType)) continue;
                int statAmount = Integer.parseInt(stat.substring(0, stat.indexOf(32)));
                statArray[i] = statAmount = validator.validateStat(statAmount, totalStats);
                totalStats += statAmount;
            }
        }
    }

    private static String convertName(String nameText) {
        importNameMap = null;
        if (importNameMap == null) {
            ImportExportConverter.initializeNameMap();
        }
        return importNameMap.containsKey(nameText) ? importNameMap.get(nameText) : nameText;
    }

    private static void initializeNameMap() {
        importNameMap = new HashMap<String, String>();
        importNameMap.put("Mime Jr.", "Mime_Jr.");
        importNameMap.put("Mr. Mime", "MrMime");
        importNameMap.put("Nidoran-F", "Nidoranfemale");
        importNameMap.put("Nidoran-M", "Nidoranmale");
        importNameMap.put("Ancient Power", "AncientPower");
        importNameMap.put("Bubble Beam", "BubbleBeam");
        importNameMap.put("Double Slap", "DoubleSlap");
        importNameMap.put("Dragon Breath", "DragonBreath");
        importNameMap.put("Dynamic Punch", "DynamicPunch");
        importNameMap.put("Extreme Speed", "ExtremeSpeed");
        importNameMap.put("Feather Dance", "FeatherDance");
        importNameMap.put("Feint Attack", "Faint Attack");
        importNameMap.put("Grass Whistle", "GrassWhistle");
        importNameMap.put("High Jump Kick", "Hi Jump Kick");
        importNameMap.put("Sand Attack", "Sand-Attack");
        importNameMap.put("Self-Destruct", "Selfdestruct");
        importNameMap.put("Smelling Salts", "SmellingSalt");
        importNameMap.put("Smokescreen", "SmokeScreen");
        importNameMap.put("Soft-Boiled", "Softboiled");
        importNameMap.put("Solar Beam", "SolarBeam");
        importNameMap.put("Sonic Boom", "SonicBoom");
        importNameMap.put("Thunder Shock", "ThunderShock");
        importNameMap.put("U-turn", "U-Turn");
    }

    private static interface StatValidator {
        public int validateStat(int var1, int var2);
    }
}

