/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.keybindings;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.PixelmonMethods;
import com.pixelmonmod.pixelmon.client.ServerStorageDisplay;
import com.pixelmonmod.pixelmon.client.gui.GuiPixelmonOverlay;
import com.pixelmonmod.pixelmon.client.keybindings.TargetKeyBinding;
import com.pixelmonmod.pixelmon.comm.PixelmonData;
import com.pixelmonmod.pixelmon.comm.packetHandlers.EnumKeyPacketMode;
import com.pixelmonmod.pixelmon.comm.packetHandlers.KeyPacket;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.entities.pixelmon.externalMoves.ExternalMoveBase;
import com.pixelmonmod.pixelmon.storage.playerData.ExternalMoveData;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.RayTraceResult;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class ExternalMoveKey
extends TargetKeyBinding {
    public ExternalMoveKey() {
        super("key.pokemonexternal", 34, "key.categories.pixelmon");
    }

    @SubscribeEvent
    public void keyDown(InputEvent.KeyInputEvent event) {
        if (this.func_151468_f()) {
            WorldClient world = Minecraft.func_71410_x().field_71441_e;
            if (world == null) {
                return;
            }
            PixelmonData poke = ServerStorageDisplay.getPokemon()[GuiPixelmonOverlay.selectedPixelmon];
            if (poke == null || !poke.outside) {
                return;
            }
            ExternalMoveData[] moves = poke.getExternalMoves();
            if (moves.length > 0) {
                ExternalMoveBase selectedMove;
                short selectedIndex = poke.selectedMoveIndex;
                if (selectedIndex >= moves.length) {
                    selectedIndex = 0;
                    poke.selectedMoveIndex = 0;
                }
                if ((selectedMove = moves[selectedIndex].getBaseExternalMove()).targetsBlocks()) {
                    this.targetLiquids = true;
                }
            }
            RayTraceResult objectMouseOver = ExternalMoveKey.getTarget(this.targetLiquids);
            boolean isSamePokemon = false;
            if (objectMouseOver == null) {
                return;
            }
            if (objectMouseOver.field_72308_g instanceof EntityPixelmon && PixelmonMethods.isIDSame((EntityPixelmon)objectMouseOver.field_72308_g, poke.pokemonID)) {
                isSamePokemon = true;
            }
            if (moves.length > 0) {
                short selectedIndex = poke.selectedMoveIndex;
                ExternalMoveBase selectedMove = moves[selectedIndex].getBaseExternalMove();
                if (world.func_82737_E() < moves[selectedIndex].timeLastUsed + (long)selectedMove.getCooldown(poke)) {
                    return;
                }
                if (selectedMove.isTargetted()) {
                    if (objectMouseOver.field_72313_a == RayTraceResult.Type.ENTITY && !isSamePokemon) {
                        Entity entity = objectMouseOver.field_72308_g;
                        Pixelmon.network.sendToServer((IMessage)new KeyPacket(poke.pokemonID, (int)selectedIndex, entity.func_145782_y()));
                    } else if (objectMouseOver.field_72313_a == RayTraceResult.Type.BLOCK) {
                        Pixelmon.network.sendToServer((IMessage)new KeyPacket(poke.pokemonID, selectedIndex, objectMouseOver.func_178782_a(), objectMouseOver.field_178784_b));
                    } else {
                        Pixelmon.network.sendToServer((IMessage)new KeyPacket(poke.pokemonID, -1, EnumKeyPacketMode.ActionKeyEntity));
                    }
                } else {
                    Pixelmon.network.sendToServer((IMessage)new KeyPacket(poke.pokemonID, (int)selectedIndex, EnumKeyPacketMode.ExternalMove));
                }
                poke.outsideEntity.func_70642_aH();
            }
        }
    }
}

