/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.render;

import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import com.pixelmonmod.pixelmon.entities.npcs.EntityNPC;
import com.pixelmonmod.pixelmon.entities.npcs.NPCTrainer;
import com.pixelmonmod.pixelmon.enums.EnumBossMode;
import javax.vecmath.Vector3f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.translation.I18n;
import org.lwjgl.opengl.GL11;

public class RenderNPC
extends RenderLiving<EntityNPC> {
    private int defaultNameRenderDistance = 8;
    private int defaultBossNameRenderDistanceExtension = 8;
    private int configNameRenderMultiplier = Math.max(1, Math.min(PixelmonConfig.nameplateRangeModifier, 3));
    private int nameRenderDistanceNormal = this.defaultNameRenderDistance * this.configNameRenderMultiplier;
    private int nameRenderDistanceBoss = this.nameRenderDistanceNormal + this.defaultBossNameRenderDistanceExtension;

    public RenderNPC(RenderManager manager) {
        super(manager, null, 0.5f);
    }

    public void doRender(EntityNPC npc, double d, double d1, double d2, float f, float f1) {
        float renderdistance;
        this.field_77045_g = npc.getModel();
        if (this.field_77045_g == null) {
            return;
        }
        float var10 = npc.func_70032_d(this.field_76990_c.field_78734_h);
        float f2 = renderdistance = npc.getBossMode() != EnumBossMode.NotBoss ? (float)this.nameRenderDistanceBoss : (float)this.nameRenderDistanceNormal;
        if (var10 <= renderdistance) {
            this.drawNameTag((EntityLiving)npc, d, d1, d2);
        }
        super.func_76986_a((EntityLiving)npc, d, d1, d2, f, f1);
    }

    public void drawNameTag(EntityLiving entityliving, double x, double y, double z) {
        if (Minecraft.func_71382_s()) {
            try {
                EntityNPC npc = (EntityNPC)entityliving;
                String displayText = npc.getDisplayText();
                String subtitleText = npc.getSubTitleText();
                if (!displayText.equals("")) {
                    this.renderLivingLabel(npc, displayText, subtitleText, x, y, z);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void renderLivingLabel(EntityNPC npc, String displayText, String subtitleText, double x, double y, double z) {
        FontRenderer fontRenderer = this.func_76983_a();
        float var13 = 1.6f;
        float var14 = 0.016666668f * var13;
        GlStateManager.func_179094_E();
        if (npc.getScale().y < 1.0f) {
            GlStateManager.func_179109_b((float)((float)x), (float)((float)y + 1.1f + 1.0f), (float)((float)z));
        } else {
            GlStateManager.func_179109_b((float)((float)x), (float)((float)y + 1.1f + 1.4f), (float)((float)z));
        }
        GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(-this.field_76990_c.field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)this.field_76990_c.field_78732_j, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179152_a((float)(-var14), (float)(-var14), (float)var14);
        GlStateManager.func_179140_f();
        GlStateManager.func_179126_j();
        GlStateManager.func_179118_c();
        GlStateManager.func_179098_w();
        if (npc instanceof NPCTrainer && ((NPCTrainer)npc).getBossMode() != EnumBossMode.NotBoss) {
            EnumBossMode enumBossMode = ((NPCTrainer)npc).getBossMode();
            String bossTag = I18n.func_74838_a((String)"gui.boss.text");
            String bossMode = enumBossMode.getBossText();
            int bossTagWidth = fontRenderer.func_78256_a(bossMode);
            int bossTagpos = bossTagWidth / 2 * -1;
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)(-2.5 + (double)bossTagpos), (double)-4.5, (double)0.0);
            GlStateManager.func_179139_a((double)0.5, (double)0.5, (double)0.5);
            fontRenderer.func_78276_b(bossTag, 0, 0, 0x20FFFFFF);
            GlStateManager.func_179121_F();
            fontRenderer.func_78276_b(bossMode, bossTagpos, 0, enumBossMode.getColourInt());
        } else {
            if (subtitleText != null) {
                int displayTextWidth = fontRenderer.func_78256_a(displayText);
                int displayTextPos = displayTextWidth / 2 * -1;
                GlStateManager.func_179094_E();
                GlStateManager.func_179137_b((double)(-2.5 + (double)displayTextPos), (double)-4.5, (double)0.0);
                GlStateManager.func_179139_a((double)0.5, (double)0.5, (double)0.5);
                fontRenderer.func_78276_b(subtitleText, 0, 0, 0x20FFFFFF);
                GlStateManager.func_179121_F();
                fontRenderer.func_78276_b(displayText, displayTextPos, 0, 0x20FFFFFF);
            }
            fontRenderer.func_78276_b(displayText, -fontRenderer.func_78256_a(displayText) / 2, 0, 0x20FFFFFF);
            GlStateManager.func_179132_a((boolean)true);
        }
        GlStateManager.func_179145_e();
        GlStateManager.func_179084_k();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179121_F();
    }

    protected boolean bindEntityTexture(EntityNPC entity) {
        if (!entity.bindTexture()) {
            return super.func_180548_c((Entity)entity);
        }
        return true;
    }

    protected ResourceLocation getEntityTexture(EntityNPC entity) {
        return new ResourceLocation(entity.getTexture());
    }

    protected void preRenderCallback(EntityNPC npc, float partialTickTime) {
        Vector3f scale = npc.getScale();
        GlStateManager.func_179152_a((float)scale.x, (float)scale.y, (float)scale.z);
        super.func_77041_b((EntityLivingBase)npc, partialTickTime);
    }
}

