/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers;

import com.pixelmonmod.pixelmon.comm.ChatHandler;
import com.pixelmonmod.pixelmon.comm.EnumUpdateType;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.storage.PixelmonStorage;
import com.pixelmonmod.pixelmon.storage.PlayerStorage;
import io.netty.buffer.ByteBuf;
import java.util.Optional;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class DeleteMove
implements IMessage {
    int[] pokemonId;
    int removeIndex;

    public DeleteMove() {
    }

    public DeleteMove(int[] pokemonId, int removeIndex) {
        this.pokemonId = pokemonId;
        this.removeIndex = removeIndex;
    }

    public void fromBytes(ByteBuf buffer) {
        this.pokemonId = new int[]{buffer.readInt(), buffer.readInt()};
        this.removeIndex = buffer.readInt();
    }

    public void toBytes(ByteBuf buffer) {
        buffer.writeInt(this.pokemonId[0]);
        buffer.writeInt(this.pokemonId[1]);
        buffer.writeInt(this.removeIndex);
    }

    public static class Handler
    implements IMessageHandler<DeleteMove, IMessage> {
        public IMessage onMessage(DeleteMove message, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            Optional<PlayerStorage> optstorage = PixelmonStorage.pokeBallManager.getPlayerStorage(player);
            if (optstorage.isPresent()) {
                PlayerStorage storage = optstorage.get();
                Optional<EntityPixelmon> pixelmonOptional = storage.getAlreadyExists(message.pokemonId, player.field_70170_p);
                EntityPixelmon p = pixelmonOptional.isPresent() ? pixelmonOptional.get() : storage.sendOut(message.pokemonId, player.field_70170_p);
                ChatHandler.sendChat((Entity)player, "deletemove.forgot", new TextComponentTranslation("pixelmon." + p.getLocalizedName().toLowerCase() + ".name", new Object[0]), new TextComponentTranslation("attack." + p.getMoveset().get((int)message.removeIndex).baseAttack.getLocalizedName().toLowerCase() + ".name", new Object[0]));
                p.getMoveset().remove(message.removeIndex);
                storage.update(p, EnumUpdateType.Moveset);
            }
            return null;
        }
    }
}

