/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.events.KeyEvent;
import com.pixelmonmod.pixelmon.api.events.PixelmonSendOutEvent;
import com.pixelmonmod.pixelmon.battles.BattleRegistry;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import com.pixelmonmod.pixelmon.comm.EnumUpdateType;
import com.pixelmonmod.pixelmon.comm.packetHandlers.EnumKeyPacketMode;
import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import com.pixelmonmod.pixelmon.entities.pixelmon.Entity1Base;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.entities.pokeballs.EntityOccupiedPokeball;
import com.pixelmonmod.pixelmon.enums.battle.EnumBattleEndCause;
import com.pixelmonmod.pixelmon.enums.items.EnumPokeballs;
import com.pixelmonmod.pixelmon.storage.PixelmonStorage;
import com.pixelmonmod.pixelmon.storage.PlayerStorage;
import io.netty.buffer.ByteBuf;
import java.util.Optional;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class KeyPacket
implements IMessage {
    int[] pokemonID;
    int entityID;
    int moveIndex;
    int x;
    int y;
    int z;
    int side;
    EnumKeyPacketMode mode;
    static long lastThrownTime = -1L;

    public KeyPacket() {
    }

    public KeyPacket(int[] id) {
        this.pokemonID = id;
        this.mode = EnumKeyPacketMode.SendPokemon;
    }

    public KeyPacket(int[] id, int entityId, EnumKeyPacketMode mode) {
        this.pokemonID = id;
        this.entityID = entityId;
        this.mode = mode;
    }

    public KeyPacket(int[] id, int moveIndex, int entityId) {
        this.pokemonID = id;
        this.moveIndex = moveIndex;
        this.entityID = entityId;
        this.mode = EnumKeyPacketMode.ExternalMoveEntity;
    }

    public KeyPacket(int[] id, int moveIndex, BlockPos pos, EnumFacing side) {
        this.pokemonID = id;
        this.moveIndex = moveIndex;
        this.x = pos.func_177958_n();
        this.y = pos.func_177956_o();
        this.z = pos.func_177952_p();
        this.mode = EnumKeyPacketMode.ExternalMoveBlock;
        this.side = side.func_176745_a();
    }

    public void fromBytes(ByteBuf buffer) {
        this.mode = EnumKeyPacketMode.getFromOrdinal(buffer.readByte());
        this.pokemonID = new int[]{buffer.readInt(), buffer.readInt()};
        switch (this.mode) {
            case ExternalMove: 
            case ActionKeyEntity: {
                this.entityID = buffer.readInt();
                break;
            }
            case ExternalMoveEntity: {
                this.entityID = buffer.readInt();
                this.moveIndex = buffer.readInt();
                break;
            }
            case ExternalMoveBlock: {
                this.moveIndex = buffer.readInt();
                this.x = buffer.readInt();
                this.y = buffer.readInt();
                this.z = buffer.readInt();
                this.side = buffer.readInt();
            }
        }
    }

    public void toBytes(ByteBuf buffer) {
        buffer.writeByte(this.mode.ordinal());
        buffer.writeInt(this.pokemonID[0]);
        buffer.writeInt(this.pokemonID[1]);
        switch (this.mode) {
            case ExternalMove: 
            case ActionKeyEntity: {
                buffer.writeInt(this.entityID);
                break;
            }
            case ExternalMoveEntity: {
                buffer.writeInt(this.entityID);
                buffer.writeInt(this.moveIndex);
                break;
            }
            case ExternalMoveBlock: {
                buffer.writeInt(this.moveIndex);
                buffer.writeInt(this.x);
                buffer.writeInt(this.y);
                buffer.writeInt(this.z);
                buffer.writeInt(this.side);
            }
        }
    }

    public static class Handler
    implements IMessageHandler<KeyPacket, IMessage> {
        public IMessage onMessage(KeyPacket message, MessageContext ctx) {
            EnumKeyPacketMode mode = message.mode;
            KeyEvent event = new KeyEvent(ctx.getServerHandler().field_147369_b, mode);
            if (Pixelmon.EVENT_BUS.post((Event)event)) {
                return null;
            }
            if (mode == EnumKeyPacketMode.SendPokemon) {
                this.sendPokemon(message, ctx);
                return null;
            }
            ctx.getServerHandler().field_147369_b.func_184102_h().func_152344_a(() -> {
                World world = ctx.getServerHandler().field_147369_b.field_70170_p;
                Optional<EntityPixelmon> pixelmonOptional = this.getPokemon(world, message.pokemonID, ctx);
                if (pixelmonOptional.isPresent()) {
                    Optional<PlayerStorage> optstorage;
                    EntityPixelmon p = pixelmonOptional.get();
                    if (mode == EnumKeyPacketMode.ExternalMove && (optstorage = p.getStorage()).isPresent()) {
                        PlayerStorage storage = optstorage.get();
                        storage.moves.get(message.pokemonID, message.entityID).execute(ctx.getServerHandler().field_147369_b, p, null);
                    }
                    if (mode.isEntity()) {
                        EntityLivingBase entity = (EntityLivingBase)world.func_73045_a(message.entityID);
                        if (mode == EnumKeyPacketMode.ActionKeyEntity) {
                            p.func_70624_b(entity);
                        } else {
                            p.setAttackTarget(entity, message.moveIndex);
                        }
                    } else {
                        p.setBlockTarget(message.x, message.y, message.z, EnumFacing.values()[message.side], message.moveIndex);
                    }
                    if (mode.isAction()) {
                        p.update(EnumUpdateType.Target);
                    }
                }
            });
            return null;
        }

        private Optional<EntityPixelmon> getPokemon(World world, int[] pokemonId, MessageContext ctx) {
            Optional<PlayerStorage> optstorage = PixelmonStorage.pokeBallManager.getPlayerStorage(ctx.getServerHandler().field_147369_b);
            if (optstorage.isPresent()) {
                PlayerStorage storage = optstorage.get();
                return storage.getAlreadyExists(pokemonId, world);
            }
            return Optional.empty();
        }

        private void sendPokemon(KeyPacket message, MessageContext ctx) {
            if (!Pixelmon.canSendOutPokemon) {
                return;
            }
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            int[] pokemonID = message.pokemonID;
            Optional<PlayerStorage> optstorage = PixelmonStorage.pokeBallManager.getPlayerStorage(player);
            if (optstorage.isPresent()) {
                PlayerStorage storage = optstorage.get();
                NBTTagCompound nbt = storage.getNBT(pokemonID);
                if (nbt == null || nbt.func_74767_n("isEgg")) {
                    return;
                }
                PixelmonSendOutEvent sendOutEvent = new PixelmonSendOutEvent(player, nbt);
                if (Pixelmon.EVENT_BUS.post((Event)sendOutEvent)) {
                    return;
                }
                MinecraftServer server = ctx.getServerHandler().field_147369_b.func_184102_h();
                server.func_152344_a(() -> {
                    String nickname = !PixelmonConfig.allowNicknames || nbt.func_74779_i("Nickname").isEmpty() ? Entity1Base.getLocalizedName(nbt.func_74779_i("Name").toLowerCase()) : nbt.func_74779_i("Nickname");
                    if (storage.isFainted(pokemonID)) {
                        ChatHandler.sendChat((Entity)player, "sendpixelmon.cantbattle", new TextComponentTranslation(nickname, new Object[0]));
                    } else if (storage.isInWorld(pokemonID)) {
                        Optional<EntityPixelmon> pixelmonOptional = storage.getAlreadyExists(pokemonID, player.field_70170_p);
                        if (!pixelmonOptional.isPresent()) {
                            storage.setInWorld(pokemonID, false);
                            return;
                        }
                        EntityPixelmon pixelmon = pixelmonOptional.get();
                        if (pixelmon.battleController != null) {
                            pixelmon.battleController.endBattle(EnumBattleEndCause.FORCE);
                            BattleRegistry.deRegisterBattle(BattleRegistry.getBattle((EntityPlayer)player));
                            return;
                        }
                        BattleRegistry.deRegisterBattle(BattleRegistry.getBattle((EntityPlayer)player));
                        if (pixelmon.func_184179_bs() == player) {
                            player.func_184210_p();
                        }
                        if (pixelmon.func_70902_q() == null) {
                            pixelmon.unloadEntity();
                        } else if (pixelmon.func_70902_q() == player) {
                            pixelmon.catchInPokeball();
                            ChatHandler.sendChat((Entity)player, "sendpixelmon.retrieved", new TextComponentTranslation(nickname, new Object[0]));
                        }
                    } else {
                        long worldTime = player.field_70170_p.func_72820_D();
                        if (lastThrownTime - worldTime < 300L && storage.thrownPokeball != null && !storage.thrownPokeball.field_70128_L) {
                            return;
                        }
                        EnumPokeballs caughtBall = EnumPokeballs.getFromIndex(nbt.func_74762_e("CaughtBall"));
                        storage.thrownPokeball = new EntityOccupiedPokeball(player.field_70170_p, (EntityLivingBase)player, pokemonID, caughtBall);
                        if (player.field_70170_p.func_72838_d((Entity)storage.thrownPokeball)) {
                            player.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187737_v, SoundCategory.NEUTRAL, 0.5f, 0.4f / (player.field_70170_p.field_73012_v.nextFloat() * 0.4f + 0.8f));
                            ChatHandler.sendChat((Entity)player, "sendpixelmon.sentout", new TextComponentTranslation(nickname, new Object[0]));
                            lastThrownTime = worldTime;
                        } else {
                            storage.thrownPokeball = null;
                        }
                    }
                });
            }
        }
    }
}

