/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.comm.packetHandlers.SendExtraData;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.storage.BackpackType;
import com.pixelmonmod.pixelmon.storage.PixelmonStorage;
import com.pixelmonmod.pixelmon.storage.PlayerExtraData;
import com.pixelmonmod.pixelmon.storage.PlayerExtras;
import com.pixelmonmod.pixelmon.storage.PlayerStorage;
import io.netty.buffer.ByteBuf;
import java.util.Optional;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class PlayerExtrasPacket
implements IMessage {
    private Mode mode;
    private boolean sashEnabled = true;
    private PlayerExtras.HatType hatType = PlayerExtras.HatType.NONE;
    private BackpackType backpackType = BackpackType.NONE;
    private int[] colours = new int[]{-1, -1, -1};
    private int[] capColours = new int[]{0, 0, 0};
    private int slot;

    public PlayerExtrasPacket() {
    }

    public PlayerExtrasPacket(PlayerExtraData data) {
        this.mode = Mode.SET_DISPLAY;
        this.sashEnabled = data.sashEnabled;
        this.hatType = data.getHatType();
        this.colours = data.colours;
        this.capColours = data.capColours;
    }

    private PlayerExtrasPacket(Mode mode, int slot) {
        this.mode = mode;
        this.slot = slot;
    }

    public static PlayerExtrasPacket getRefreshPacket() {
        return new PlayerExtrasPacket(Mode.REFRESH, 0);
    }

    public static PlayerExtrasPacket getSetTexturePacket(int slot) {
        return new PlayerExtrasPacket(Mode.SET_TEXTURE, slot);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeByte(this.mode.ordinal());
        if (this.mode == Mode.SET_DISPLAY) {
            buf.writeBoolean(this.sashEnabled);
            buf.writeByte(this.hatType.id);
            buf.writeByte(this.backpackType.getID());
            buf.writeShort(this.colours[0]).writeShort(this.colours[1]).writeShort(this.colours[2]);
            buf.writeShort(this.capColours[0]).writeShort(this.capColours[1]).writeShort(this.capColours[2]);
        } else if (this.mode == Mode.SET_TEXTURE) {
            buf.writeByte(this.slot);
        }
    }

    public void fromBytes(ByteBuf buf) {
        this.mode = Mode.values()[buf.readByte()];
        if (this.mode == Mode.SET_DISPLAY) {
            this.sashEnabled = buf.readBoolean();
            this.hatType = PlayerExtras.HatType.getFromId(buf.readByte());
            this.backpackType = BackpackType.getFromID(buf.readByte());
            this.colours = new int[]{buf.readShort(), buf.readShort(), buf.readShort()};
            this.capColours = new int[]{buf.readShort(), buf.readShort(), buf.readShort()};
        } else if (this.mode == Mode.SET_TEXTURE) {
            this.slot = buf.readByte();
        }
    }

    public static class Handler
    implements IMessageHandler<PlayerExtrasPacket, IMessage> {
        public IMessage onMessage(PlayerExtrasPacket message, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            if (message.mode == Mode.REFRESH && FMLCommonHandler.instance().getSide() != Side.CLIENT) {
                PlayerExtras.refreshExtras(player);
            } else if (message.mode == Mode.SET_DISPLAY) {
                PlayerExtraData data = PlayerExtras.getExtras(player);
                if (FMLCommonHandler.instance().getSide() != Side.CLIENT && !data.hasData()) {
                    if (data.shouldRefresh()) {
                        PlayerExtras.checkDataOnline(data.id, playerExtraData -> {
                            Optional<PlayerStorage> optstorage;
                            if (playerExtraData.hasData() && (optstorage = PixelmonStorage.pokeBallManager.getPlayerStorage(player)).isPresent()) {
                                PlayerStorage storage = optstorage.get();
                                storage.getExtraData().setDataValues((PlayerExtraData)playerExtraData);
                                data.sashEnabled = message.sashEnabled;
                                data.setHatType(message.hatType);
                                data.setBackpackType(message.backpackType);
                                data.colours = message.colours;
                                data.capColours = message.capColours;
                                Pixelmon.network.sendToAll((IMessage)new SendExtraData(data));
                            }
                        });
                    }
                } else {
                    data.sashEnabled = message.sashEnabled;
                    data.setHatType(message.hatType);
                    data.setBackpackType(message.backpackType);
                    data.colours = message.colours;
                    data.capColours = message.capColours;
                    Pixelmon.network.sendToAll((IMessage)new SendExtraData(data));
                }
            } else {
                player.func_184102_h().func_152344_a(() -> {
                    Optional<PlayerStorage> optstorage = PixelmonStorage.pokeBallManager.getPlayerStorage(player);
                    if (optstorage.isPresent()) {
                        int[] id;
                        PlayerStorage storage = optstorage.get();
                        Optional<EntityPixelmon> entityPixelmonOptional = storage.getAlreadyExists(id = storage.getIDFromPosition(message.slot - 1), player.field_70170_p);
                        EntityPixelmon pokemon = entityPixelmonOptional.isPresent() ? entityPixelmonOptional.get() : storage.sendOut(id, player.field_70170_p);
                        PlayerExtras.checkOnlineData(player, pokemon);
                    }
                });
            }
            return null;
        }
    }

    private static enum Mode {
        REFRESH,
        SET_DISPLAY,
        SET_TEXTURE;

    }
}

