/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.clientStorage;

import com.pixelmonmod.pixelmon.enums.EnumMegaItem;
import com.pixelmonmod.pixelmon.storage.ClientData;
import io.netty.buffer.ByteBuf;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class UpdateClientPlayerData
implements IMessage {
    private ClientDataType type;
    private int playerMoney;
    private EnumMegaItem megaItem;
    private boolean giveChoice;

    public UpdateClientPlayerData() {
    }

    public UpdateClientPlayerData(int playerMoney) {
        this.playerMoney = playerMoney;
        this.type = ClientDataType.Currency;
    }

    public UpdateClientPlayerData(EnumMegaItem megaItem, boolean openMegaItemGui) {
        this.megaItem = megaItem;
        this.type = ClientDataType.MegaItem;
        this.giveChoice = openMegaItemGui;
    }

    public void fromBytes(ByteBuf buf) {
        this.type = ClientDataType.values()[buf.readInt()];
        switch (this.type) {
            case Currency: {
                this.playerMoney = buf.readInt();
                break;
            }
            case MegaItem: {
                this.megaItem = EnumMegaItem.values()[buf.readInt()];
                this.giveChoice = buf.readBoolean();
            }
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.type.ordinal());
        switch (this.type) {
            case Currency: {
                buf.writeInt(this.playerMoney);
                break;
            }
            case MegaItem: {
                buf.writeInt(this.megaItem.ordinal());
                buf.writeBoolean(this.giveChoice);
            }
        }
    }

    public static class Handler
    implements IMessageHandler<UpdateClientPlayerData, IMessage> {
        public IMessage onMessage(UpdateClientPlayerData message, MessageContext ctx) {
            switch (message.type) {
                case Currency: {
                    ClientData.playerMoney = message.playerMoney;
                    break;
                }
                case MegaItem: {
                    ClientData.openMegaItemGui = message.giveChoice;
                }
            }
            return null;
        }
    }

    public static enum ClientDataType {
        Currency,
        MegaItem;

    }
}

