/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.pokemoneditor;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.PixelmonMethods;
import com.pixelmonmod.pixelmon.client.gui.pokemoneditor.GuiPokemonEditorParty;
import com.pixelmonmod.pixelmon.comm.packetHandlers.pokemoneditor.ChangePokemonOpenGUI;
import com.pixelmonmod.pixelmon.config.PixelmonEntityList;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.enums.EnumPokemon;
import com.pixelmonmod.pixelmon.items.ItemPokemonEditor;
import com.pixelmonmod.pixelmon.storage.PixelmonStorage;
import com.pixelmonmod.pixelmon.storage.PlayerStorage;
import io.netty.buffer.ByteBuf;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class ChangePokemon
implements IMessage {
    UUID playerID;
    int slot;
    EnumPokemon newPokemon;

    public ChangePokemon() {
    }

    public ChangePokemon(int slot, EnumPokemon newPokemon) {
        this.playerID = GuiPokemonEditorParty.editedPlayerUUID;
        this.slot = slot;
        this.newPokemon = newPokemon;
    }

    public void toBytes(ByteBuf buf) {
        PixelmonMethods.toBytesUUID(buf, this.playerID);
        buf.writeInt(this.slot);
        buf.writeInt(this.newPokemon.ordinal());
    }

    public void fromBytes(ByteBuf buf) {
        this.playerID = PixelmonMethods.fromBytesUUID(buf);
        this.slot = buf.readInt();
        this.newPokemon = EnumPokemon.getFromOrdinal(buf.readInt());
    }

    public static class Handler
    implements IMessageHandler<ChangePokemon, IMessage> {
        public IMessage onMessage(ChangePokemon message, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            ctx.getServerHandler().field_147369_b.func_184102_h().func_152344_a(() -> {
                Optional<PlayerStorage> optstorage;
                if (ItemPokemonEditor.checkPermission(player) && (optstorage = PixelmonStorage.pokeBallManager.getPlayerStorageFromUUID(player.func_184102_h(), message.playerID)).isPresent()) {
                    PlayerStorage storage = optstorage.get();
                    EntityPixelmon pokemon = (EntityPixelmon)PixelmonEntityList.createEntityByName(message.newPokemon.name, player.func_130014_f_());
                    pokemon.friendship.initFromCapture();
                    if (message.slot == -1) {
                        storage.addToParty(pokemon);
                    } else {
                        storage.addToParty(pokemon, message.slot);
                    }
                    EntityPlayerMP editingPlayer = ctx.getServerHandler().field_147369_b;
                    ItemPokemonEditor.updateSinglePokemon(editingPlayer, message.playerID, message.slot);
                    Pixelmon.network.sendTo((IMessage)new ChangePokemonOpenGUI(message.slot), editingPlayer);
                }
            });
            return null;
        }
    }
}

