/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.config;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.database.DatabaseHelper;
import com.pixelmonmod.pixelmon.enums.EnumType;
import com.pixelmonmod.pixelmon.items.ItemHM;
import com.pixelmonmod.pixelmon.items.ItemTM;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class PixelmonItemsTMs {
    public static ArrayList<Item> TMs = new ArrayList();
    public static ArrayList<Item> HMs = new ArrayList();

    static void load() {
        Pixelmon.LOGGER.info("Loading TM/HMs.");
        try {
            ItemTM item;
            Connection conn = DatabaseHelper.getConnection();
            Statement stat = conn.createStatement();
            ResultSet rs = stat.executeQuery("select * from MOVES where TMID IS NOT NULL ORDER BY TMID");
            while (rs.next()) {
                try {
                    item = new ItemTM(rs.getString("NAME"), rs.getInt("TMID"), EnumType.parseTypeFromDBID(rs.getInt("TYPEID")), false);
                    TMs.add(item);
                }
                catch (Exception e) {
                    System.out.println("Problem loading TMs");
                }
            }
            rs = stat.executeQuery("select * from MOVES where HMID IS NOT NULL ORDER BY HMID");
            while (rs.next()) {
                try {
                    item = new ItemHM(rs.getString("NAME"), rs.getInt("HMID"), EnumType.parseTypeFromDBID(rs.getInt("TYPEID")));
                    HMs.add(item);
                }
                catch (Exception e) {
                    System.out.println("Problem loading HMs");
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static void registerItems(RegistryEvent.Register<Item> event) {
        PixelmonItemsTMs.load();
        for (Item item : TMs) {
            event.getRegistry().register((IForgeRegistryEntry)item);
        }
        for (Item item : HMs) {
            event.getRegistry().register((IForgeRegistryEntry)item);
        }
    }

    static void registerRenderers() {
        try {
            for (Item item : TMs) {
                ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation(item.getRegistryName(), "inventory"));
            }
            for (Item item : HMs) {
                ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation(item.getRegistryName(), "inventory"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

