/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.npcs;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.comm.packetHandlers.npc.SetNPCData;
import com.pixelmonmod.pixelmon.comm.packetHandlers.npc.SetNPCEditData;
import com.pixelmonmod.pixelmon.comm.packetHandlers.npc.SetShopkeeperClient;
import com.pixelmonmod.pixelmon.database.SpawnLocation;
import com.pixelmonmod.pixelmon.entities.npcs.EntityIndexedNPC;
import com.pixelmonmod.pixelmon.entities.npcs.registry.BaseShopItem;
import com.pixelmonmod.pixelmon.entities.npcs.registry.ServerNPCRegistry;
import com.pixelmonmod.pixelmon.entities.npcs.registry.ShopItem;
import com.pixelmonmod.pixelmon.entities.npcs.registry.ShopItemWithVariation;
import com.pixelmonmod.pixelmon.entities.npcs.registry.ShopkeeperChat;
import com.pixelmonmod.pixelmon.entities.npcs.registry.ShopkeeperData;
import com.pixelmonmod.pixelmon.enums.EnumGui;
import com.pixelmonmod.pixelmon.gui.ContainerEmpty;
import com.pixelmonmod.pixelmon.items.ItemNPCEditor;
import java.util.ArrayList;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class NPCShopkeeper
extends EntityIndexedNPC {
    private long lastUpdatedTime = 0L;
    private ArrayList<ShopItemWithVariation> itemList;
    ArrayList<UUID> playerList = new ArrayList();

    public NPCShopkeeper(World world) {
        super(world);
    }

    public void init(ShopkeeperData data) {
        this.npcIndex = data.id;
        this.nameIndex = data.getRandomNameIndex();
        this.chatIndex = data.getRandomChatIndex();
        this.setCustomSteveTexture(data.getRandomTexture());
        if (this.getId() == -1) {
            this.setId(idIndex++);
        }
    }

    @Override
    public void init(String name) {
        super.init(name);
        if (this.getCustomSteveTexture().equals("")) {
            this.setCustomSteveTexture("npcchat1.png");
        }
    }

    public void initRandom(String biomeID) {
        ShopkeeperData data = ServerNPCRegistry.shopkeepers.getRandomSpawning(biomeID);
        if (data == null) {
            this.func_70106_y();
        } else {
            this.init(data);
        }
        this.npcLocation = SpawnLocation.LandNPC;
    }

    @Override
    public String getTexture() {
        return "pixelmon:textures/steve/" + this.getCustomSteveTexture();
    }

    @Override
    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.initDefaultAI();
        if (nbt.func_74764_b("ShopItems")) {
            NBTTagList list = nbt.func_150295_c("ShopItems", 10);
            this.itemList = new ArrayList();
            for (int i = 0; i < list.func_74745_c(); ++i) {
                ShopItemWithVariation item = ShopItemWithVariation.getFromNBT(this.npcIndex, list.func_150305_b(i));
                if (item == null) continue;
                this.getItemList().add(item);
            }
        }
    }

    @Override
    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        NBTTagList list = new NBTTagList();
        if (this.getItemList() != null) {
            for (ShopItemWithVariation item : this.getItemList()) {
                item.writeToNBT(list);
            }
            nbt.func_74782_a("ShopItems", (NBTBase)list);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean interactWithNPC(EntityPlayer player, EnumHand hand) {
        ItemStack itemStack = player.func_184586_b(hand);
        if (!(player instanceof EntityPlayerMP)) {
            this.field_70714_bg.field_75782_a.clear();
            return true;
        }
        if (itemStack != null && itemStack.func_77973_b() instanceof ItemNPCEditor) {
            if (!this.checkOP(player)) {
                return false;
            }
            EntityPlayerMP playerMP = (EntityPlayerMP)player;
            String loc = playerMP.field_71148_cg;
            Pixelmon.network.sendTo((IMessage)new SetShopkeeperClient(loc), playerMP);
            Pixelmon.network.sendTo((IMessage)new SetNPCEditData(ServerNPCRegistry.shopkeepers.getJsonName(this.npcIndex), this.getShopkeeperName(loc), this.getCustomSteveTexture()), playerMP);
            player.openGui((Object)Pixelmon.instance, EnumGui.ShopkeeperEditor.getIndex().intValue(), player.field_70170_p, this.getId(), 0, 0);
            return true;
        }
        if (this.getItemList() == null || this.getItemList().isEmpty()) {
            this.loadItems();
        }
        this.sendItemsToPlayer(player);
        player.openGui((Object)Pixelmon.instance, EnumGui.Shopkeeper.getIndex().intValue(), player.field_70170_p, this.getId(), 0, 0);
        return true;
    }

    public void sendItemsToPlayer(EntityPlayer player) {
        ArrayList<ShopItemWithVariation> sellList = this.getSellList(player);
        String loc = ((EntityPlayerMP)player).field_71148_cg;
        this.playerList.add(player.func_110124_au());
        Pixelmon.network.sendTo((IMessage)new SetNPCData(this.getShopkeeperName(loc), this.getShopkeeperChat(loc), this.getItemList(), sellList), (EntityPlayerMP)player);
    }

    public ArrayList<ShopItemWithVariation> getSellList(EntityPlayer player) {
        ArrayList<ShopItemWithVariation> sellList = new ArrayList<ShopItemWithVariation>();
        for (int i = 0; i < player.field_71071_by.field_70462_a.size(); ++i) {
            BaseShopItem baseItem;
            ItemStack item = (ItemStack)player.field_71071_by.field_70462_a.get(i);
            if (item == null) continue;
            ShopItemWithVariation shopItem = null;
            shopItem = this.getExistingItem(item);
            if (shopItem == null && (baseItem = ServerNPCRegistry.shopkeepers.getItem(item)) != null) {
                shopItem = new ShopItemWithVariation(new ShopItem(baseItem, 1.0f, 1.0f, false), 1.0f);
            }
            if (shopItem == null || !shopItem.canSell() || this.alreadyListed(sellList, shopItem)) continue;
            sellList.add(shopItem);
        }
        return sellList;
    }

    private boolean alreadyListed(ArrayList<ShopItemWithVariation> sellList, ShopItemWithVariation shopItem) {
        for (ShopItemWithVariation item : sellList) {
            if (item.getItem() != shopItem.getItem()) continue;
            return true;
        }
        return false;
    }

    private ShopItemWithVariation getExistingItem(ItemStack item) {
        for (ShopItemWithVariation si : this.getItemList()) {
            if (!ItemStack.func_77989_b((ItemStack)si.getItem(), (ItemStack)item)) continue;
            return si;
        }
        return null;
    }

    private ShopkeeperChat getShopkeeperChat(String langCode) {
        int index = this.chatIndex;
        return ServerNPCRegistry.shopkeepers.getTranslatedChat(langCode, this.npcIndex, index);
    }

    public String getShopkeeperName(String langCode) {
        return ServerNPCRegistry.shopkeepers.getTranslatedName(langCode, this.npcIndex, this.nameIndex);
    }

    public void loadItems() {
        this.lastUpdatedTime = this.field_70170_p.func_82737_E();
        ShopkeeperData skd = ServerNPCRegistry.shopkeepers.getById(this.npcIndex);
        this.itemList = skd != null ? skd.getItemList() : new ArrayList();
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K && this.playerList.size() > 0) {
            for (int i = 0; i < this.playerList.size(); ++i) {
                EntityPlayer player = this.field_70170_p.func_152378_a(this.playerList.get(i));
                if (player != null && player.field_71070_bA instanceof ContainerEmpty) continue;
                this.playerList.remove(i);
                --i;
            }
        }
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.func_82737_E() > this.lastUpdatedTime + 24000L && this.playerList.size() == 0) {
            this.loadItems();
        }
    }

    public ArrayList<ShopItemWithVariation> getItemList() {
        return this.itemList;
    }

    public void cycleJson(EntityPlayerMP p, String newJSON) {
        ShopkeeperData id = ServerNPCRegistry.shopkeepers.getById(newJSON);
        if (id == null) {
            return;
        }
        this.init(id);
        String loc = p.field_71148_cg;
        Pixelmon.network.sendTo((IMessage)new SetNPCEditData(ServerNPCRegistry.shopkeepers.getJsonName(this.npcIndex), this.getShopkeeperName(loc), this.getCustomSteveTexture()), p);
    }

    public void cycleName(EntityPlayerMP p, int nameIndex) {
        this.nameIndex = nameIndex;
        String loc = p.field_71148_cg;
        Pixelmon.network.sendTo((IMessage)new SetNPCEditData(ServerNPCRegistry.shopkeepers.getJsonName(this.npcIndex), this.getShopkeeperName(loc), this.getCustomSteveTexture()), p);
    }

    @Override
    public String getDisplayText() {
        return I18n.func_74838_a((String)"gui.shopkeeper.name");
    }

    @Override
    public String getSubTitleText() {
        return null;
    }
}

