/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.pixelmon;

import com.pixelmonmod.pixelmon.api.pokemon.PokemonSpec;
import com.pixelmonmod.pixelmon.client.models.PixelmonModelRegistry;
import com.pixelmonmod.pixelmon.client.models.PixelmonModelSmd;
import com.pixelmonmod.pixelmon.client.models.smd.AnimationType;
import com.pixelmonmod.pixelmon.client.models.smd.ValveStudioModel;
import com.pixelmonmod.pixelmon.comm.EnumUpdateType;
import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import com.pixelmonmod.pixelmon.entities.pixelmon.Entity1Base;
import com.pixelmonmod.pixelmon.entities.pixelmon.Entity3HasStats;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityStatue;
import com.pixelmonmod.pixelmon.entities.pixelmon.helpers.animation.AnimationVariables;
import com.pixelmonmod.pixelmon.entities.pixelmon.helpers.animation.IncrementingVariable;
import com.pixelmonmod.pixelmon.enums.EnumPokemon;
import java.util.HashMap;
import net.minecraft.client.model.ModelBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class Entity2HasModel
extends Entity1Base {
    static int animationFlyingDelayLimit = 10;
    static int animationDelayLimit = 3;
    static int flyingDelayLimit = 10;
    public boolean animationFlyingCounting = false;
    public boolean animationFlyingSwap = false;
    public boolean animationCounting = false;
    public boolean animationSwap = false;
    public boolean transformed;
    public EnumPokemon transformedModel;
    public int transformedForm;
    int animationFlyingDelayCounter = 0;
    int animationDelayCounter = 0;
    int flyingDelayCounter = 0;
    private AnimationVariables animationVariables;
    private AnimationType animationType;

    public Entity2HasModel(World par1World) {
        super(par1World);
        this.field_70180_af.func_187214_a(EntityPixelmon.dwTransformation, (Object)0);
    }

    @Override
    protected void init(String name) {
        super.init(name);
    }

    public void evolve(PokemonSpec evolveTo) {
        if (!EnumPokemon.hasPokemon(evolveTo.name)) {
            return;
        }
        if (this.getNickname().equals(this.getLocalizedName())) {
            this.setNickname(Entity2HasModel.getLocalizedName(evolveTo.name));
        }
        this.setName(evolveTo.name);
        this.update(EnumUpdateType.Name, EnumUpdateType.Nickname);
    }

    @SideOnly(value=Side.CLIENT)
    public ModelBase getModel() {
        if (this.transformed) {
            return PixelmonModelRegistry.getModel(this.transformedModel, this.transformedModel.getFormEnum(this.transformedForm));
        }
        Entity3HasStats entityStats = (Entity3HasStats)this;
        if (PixelmonModelRegistry.hasFlyingModel(this.getSpecies(), entityStats.getFormEnum()) && this.flyingDelayCounter >= flyingDelayLimit) {
            return PixelmonModelRegistry.getFlyingModel(this.getSpecies(), entityStats.getFormEnum());
        }
        return PixelmonModelRegistry.getModel(this.getSpecies(), entityStats.getFormEnum());
    }

    @SideOnly(value=Side.CLIENT)
    public void transform(EnumPokemon transformedModel, int transformedForm) {
        this.transformed = true;
        this.transformedModel = transformedModel;
        this.transformedForm = transformedForm;
    }

    public void transformServer(EnumPokemon transformedModel, int transformedForm) {
        this.transformed = true;
        this.transformedModel = transformedModel;
        this.transformedForm = transformedForm;
    }

    public void cancelTransform() {
        this.transformed = false;
        this.transformedModel = null;
        this.transformedForm = -1;
    }

    public int getTransformed() {
        return (Integer)this.field_70180_af.func_187225_a(EntityPixelmon.dwTransformation);
    }

    public float getScaleFactor() {
        return (float)Math.pow(this.getGrowth().scaleValue, PixelmonConfig.getGrowthModifier()) * this.getBossMode().scaleFactor;
    }

    public AnimationVariables getAnimationVariables() {
        if (this.animationVariables == null) {
            this.animationVariables = new AnimationVariables();
        }
        return this.animationVariables;
    }

    public void initAnimation() {
        ModelBase base;
        if (this.field_70170_p.field_72995_K && (base = this.getModel()) instanceof PixelmonModelSmd) {
            ValveStudioModel model = ((PixelmonModelSmd)base).theModel;
            model.animate();
        }
    }

    protected void checkAnimation() {
        IncrementingVariable inc;
        if (!(this.getModel() instanceof PixelmonModelSmd)) {
            return;
        }
        PixelmonModelSmd smdModel = (PixelmonModelSmd)this.getModel();
        Entity3HasStats pixelmon = (Entity3HasStats)this;
        float f1 = pixelmon.field_184618_aE + (pixelmon.field_70721_aZ - pixelmon.field_184618_aE) * 1.0f;
        if (f1 > 1.0f) {
            f1 = 1.0f;
        }
        if ((inc = this.getAnimationVariables().getCounter(-1)) == null) {
            this.getAnimationVariables().setCounter(-1, 2.1474836E9f, smdModel.animationIncrement);
        } else {
            inc.increment = smdModel.animationIncrement;
        }
        if (!pixelmon.animationCounting) {
            this.setAnimation(AnimationType.IDLE);
            pixelmon.animationCounting = true;
        }
        if (pixelmon.func_70090_H()) {
            if (f1 > smdModel.movementThreshold) {
                if (pixelmon.animationSwap) {
                    this.setAnimation(AnimationType.SWIM);
                }
            } else if (pixelmon.animationSwap) {
                this.setAnimation(AnimationType.IDLE_SWIM);
            }
        } else if (!pixelmon.field_70122_E || pixelmon.baseStats.doesHover && f1 > smdModel.movementThreshold) {
            if (!pixelmon.animationFlyingSwap) {
                pixelmon.animationFlyingCounting = true;
            }
            if (pixelmon.animationFlyingSwap) {
                this.setAnimation(AnimationType.FLY);
            }
        } else if (f1 > smdModel.movementThreshold) {
            if (pixelmon.animationSwap) {
                this.setAnimation(AnimationType.WALK);
            }
        } else if (pixelmon.animationSwap) {
            this.setAnimation(AnimationType.IDLE);
        }
        if (smdModel.theModel.currentAnimation == null) {
            this.setAnimation(AnimationType.IDLE);
        }
    }

    public void setAnimation(AnimationType animation) {
        this.animationType = animation;
    }

    public AnimationType getCurrentAnimation() {
        if (this.animationType == null) {
            return AnimationType.IDLE;
        }
        return this.animationType;
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this instanceof EntityStatue) {
            return;
        }
        if (!this.field_70122_E && !this.field_70171_ac) {
            if (this.flyingDelayCounter < flyingDelayLimit) {
                ++this.flyingDelayCounter;
            }
        } else {
            this.flyingDelayCounter = 0;
        }
        if (this.field_70170_p.field_72995_K) {
            if (this.animationVariables != null) {
                this.animationVariables.tick();
            }
            if (this.animationFlyingCounting) {
                if (this.animationFlyingDelayCounter < animationFlyingDelayLimit) {
                    ++this.animationFlyingDelayCounter;
                    this.animationFlyingSwap = false;
                }
                if (this.animationFlyingDelayCounter >= animationFlyingDelayLimit) {
                    this.animationFlyingSwap = true;
                    this.animationFlyingDelayCounter = 0;
                }
            } else {
                this.animationFlyingDelayCounter = 0;
                this.animationFlyingSwap = false;
            }
            if (this.animationCounting) {
                if (this.animationDelayCounter < animationDelayLimit) {
                    ++this.animationDelayCounter;
                    this.animationSwap = false;
                }
                if (this.animationDelayCounter >= animationDelayLimit) {
                    this.animationSwap = true;
                    this.animationDelayCounter = 0;
                }
            } else {
                this.animationDelayCounter = 0;
                this.animationSwap = false;
            }
            if (this instanceof EntityPixelmon) {
                try {
                    this.checkAnimation();
                }
                catch (NullPointerException npe) {
                    System.out.println(this.func_70005_c_());
                }
            }
        }
    }

    @Override
    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74777_a("transform", (short)this.getTransformed());
    }

    @Override
    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.field_70180_af.func_187227_b(EntityPixelmon.dwTransformation, (Object)nbt.func_74765_d("transform"));
    }

    @Override
    public void getNBTTags(HashMap<String, Class> tags) {
        super.getNBTTags(tags);
    }
}

