/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.pixelmon.abilities;

import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import com.pixelmonmod.pixelmon.battles.status.Weather;
import com.pixelmonmod.pixelmon.entities.pixelmon.abilities.AbilityBase;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.StatsType;
import com.pixelmonmod.pixelmon.enums.EnumPokemon;
import com.pixelmonmod.pixelmon.enums.forms.EnumCherrim;

public class FlowerGift
extends AbilityBase {
    @Override
    public int[] modifyStatsTeammate(PixelmonWrapper pokemon, int[] stats) {
        if (pokemon.bc.globalStatusController.hasStatus(StatusType.Sunny)) {
            int n = StatsType.Attack.getStatIndex();
            stats[n] = (int)((double)stats[n] * 1.5);
        }
        return stats;
    }

    @Override
    public int[] modifyStatsCancellableTeammate(PixelmonWrapper pokemon, int[] stats) {
        if (pokemon.bc.globalStatusController.hasStatus(StatusType.Sunny)) {
            int n = StatsType.SpecialDefence.getStatIndex();
            stats[n] = (int)((double)stats[n] * 1.5);
        }
        return stats;
    }

    @Override
    public void onWeatherChange(PixelmonWrapper pw, Weather weather) {
        StatusType weatherType;
        if (pw.getSpecies() != EnumPokemon.Cherrim || pw.bc.simulateMode) {
            return;
        }
        StatusType statusType = weatherType = weather == null ? StatusType.None : weather.type;
        if (weatherType == StatusType.Sunny) {
            if (pw.getForm() == EnumCherrim.OVERCAST.getForm()) {
                pw.setForm(EnumCherrim.SUNSHINE.getForm());
                pw.bc.sendToAll("pixelmon.abilities.changeform", pw.getNickname());
            }
        } else if (pw.getForm() == EnumCherrim.SUNSHINE.getForm()) {
            pw.setForm(EnumCherrim.OVERCAST.getForm());
            pw.bc.sendToAll("pixelmon.abilities.changeform", pw.getNickname());
        }
    }

    @Override
    public void applySwitchInEffect(PixelmonWrapper newPokemon) {
        this.resetForm(newPokemon);
        this.onWeatherChange(newPokemon, newPokemon.bc.globalStatusController.getWeather());
    }

    @Override
    public void applySwitchOutEffect(PixelmonWrapper pw) {
        this.resetForm(pw);
    }

    @Override
    public void onAbilityLost(PixelmonWrapper pokemon) {
        this.onWeatherChange(pokemon, null);
    }

    private void resetForm(PixelmonWrapper pw) {
        if (pw.bc.simulateMode) {
            return;
        }
        if (pw.getForm() != EnumCherrim.OVERCAST.getForm()) {
            pw.setForm(EnumCherrim.OVERCAST.getForm());
        }
    }
}

