/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.pixelmon.drops;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.events.DropEvent;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import com.pixelmonmod.pixelmon.comm.packetHandlers.itemDrops.ItemDropMode;
import com.pixelmonmod.pixelmon.comm.packetHandlers.itemDrops.ItemDropPacket;
import com.pixelmonmod.pixelmon.entities.npcs.NPCTrainer;
import com.pixelmonmod.pixelmon.entities.pixelmon.Entity8HoldsItems;
import com.pixelmonmod.pixelmon.entities.pixelmon.drops.DropItemHelper;
import com.pixelmonmod.pixelmon.entities.pixelmon.drops.DropItemQuery;
import com.pixelmonmod.pixelmon.entities.pixelmon.drops.DroppedItem;
import com.pixelmonmod.pixelmon.enums.EnumBossMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class DropItemQueryList {
    public static List<DropItemQuery> queryList = Collections.synchronizedList(new ArrayList());

    public static void register(Entity8HoldsItems pixelmon, ArrayList<DroppedItem> givenDrops, EntityPlayerMP player) {
        DropEvent event = new DropEvent(player, (EntityCreature)pixelmon, pixelmon.isBossPokemon() ? ItemDropMode.Boss : ItemDropMode.NormalPokemon, givenDrops);
        if (Pixelmon.EVENT_BUS.post((Event)event)) {
            return;
        }
        givenDrops = new ArrayList<DroppedItem>((Collection<DroppedItem>)event.getDrops());
        DropItemQuery diq = new DropItemQuery(new Vec3d(pixelmon.field_70165_t, pixelmon.field_70163_u, pixelmon.field_70161_v), player.func_110124_au(), givenDrops);
        queryList.add(diq);
        if (pixelmon.isBossPokemon()) {
            Pixelmon.network.sendTo((IMessage)new ItemDropPacket(ItemDropMode.Boss, givenDrops), player);
        } else {
            Pixelmon.network.sendTo((IMessage)new ItemDropPacket(ItemDropMode.NormalPokemon, ChatHandler.getMessage("gui.guiItemDrops.beatPokemon", pixelmon.getNickname()), givenDrops), player);
        }
    }

    public static void register(NPCTrainer npc, ArrayList<DroppedItem> givenDrops, EntityPlayerMP player) {
        DropEvent event = new DropEvent(player, npc, npc.isGymLeader ? ItemDropMode.Other : ItemDropMode.NormalTrainer, givenDrops);
        if (Pixelmon.EVENT_BUS.post((Event)event)) {
            return;
        }
        givenDrops = new ArrayList<DroppedItem>((Collection<DroppedItem>)event.getDrops());
        DropItemQuery diq = new DropItemQuery(new Vec3d(npc.field_70165_t, npc.field_70163_u, npc.field_70161_v), player.func_110124_au(), givenDrops);
        queryList.add(diq);
        ItemDropPacket p = null;
        p = npc.isGymLeader ? new ItemDropPacket(ChatHandler.getMessage("pixelmon.entitytrainer.dropitemstitle", npc.getName(player.field_71148_cg)), givenDrops) : new ItemDropPacket(ItemDropMode.NormalTrainer, givenDrops);
        Pixelmon.network.sendTo((IMessage)p, player);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void takeAllItems(EntityPlayerMP player) {
        List<DropItemQuery> list = queryList;
        synchronized (list) {
            for (int i = 0; i < queryList.size(); ++i) {
                DropItemQuery query = queryList.get(i);
                if (!query.playerUUID.equals(player.func_110124_au())) continue;
                for (DroppedItem droppedItem : query.droppedItemList) {
                    DropItemQueryList.giveSingleItem(player, droppedItem);
                }
            }
        }
        DropItemQueryList.removeQuery(player);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dropAllItems(EntityPlayerMP player) {
        List<DropItemQuery> list = queryList;
        synchronized (list) {
            for (int i = 0; i < queryList.size(); ++i) {
                if (!DropItemQueryList.queryList.get((int)i).playerUUID.equals(player.func_110124_au())) continue;
                for (DroppedItem droppedItem : DropItemQueryList.queryList.get((int)i).droppedItemList) {
                    DropItemHelper.dropItemOnGround(DropItemQueryList.queryList.get((int)i).position, player, droppedItem.itemStack, droppedItem.rarity != EnumBossMode.NotBoss, false);
                }
            }
        }
        DropItemQueryList.removeQuery(player);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void takeItem(EntityPlayerMP player, int itemID) {
        List<DropItemQuery> list = queryList;
        synchronized (list) {
            for (int i = 0; i < queryList.size(); ++i) {
                DropItemQuery query = queryList.get(i);
                if (!query.playerUUID.equals(player.func_110124_au())) continue;
                for (int j = 0; j < query.droppedItemList.size(); ++j) {
                    DroppedItem droppedItem = query.droppedItemList.get(j);
                    if (droppedItem.id != itemID) continue;
                    DropItemQueryList.giveSingleItem(player, droppedItem);
                    query.droppedItemList.remove(j);
                    if (query.droppedItemList.isEmpty()) {
                        DropItemQueryList.removeQuery(player);
                    }
                    return;
                }
            }
        }
    }

    private static void giveSingleItem(EntityPlayerMP player, DroppedItem droppedItem) {
        String itemName = droppedItem.itemStack.func_77973_b().func_77653_i(droppedItem.itemStack);
        if (DropItemHelper.giveItemStackToPlayer(player, droppedItem.itemStack)) {
            ChatHandler.sendFormattedChat((ICommandSender)player, TextFormatting.GREEN, "pixelmon.drops.receivedrop", itemName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeQuery(EntityPlayerMP player) {
        List<DropItemQuery> list = queryList;
        synchronized (list) {
            for (int i = 0; i < queryList.size(); ++i) {
                if (!DropItemQueryList.queryList.get((int)i).playerUUID.equals(player.func_110124_au())) continue;
                queryList.remove(i);
                --i;
            }
        }
    }

    public static boolean hasInitialVowel(String strName) {
        return (strName = strName.toLowerCase()).toLowerCase().startsWith("a") || strName.startsWith("e") || strName.startsWith("i") || strName.startsWith("o") || strName.startsWith("u");
    }
}

