/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.pixelmon.stats;

import com.pixelmonmod.pixelmon.RandomHelper;
import com.pixelmonmod.pixelmon.database.ExperienceGroup;
import com.pixelmonmod.pixelmon.database.SpawnLocation;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.Aggression;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.EVsStore;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.FlyingParameters;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.Gender;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.Rarity;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.RidingOffsets;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.StatsType;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.SwimmingParameters;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.evolution.Evolution;
import com.pixelmonmod.pixelmon.enums.EnumEggGroup;
import com.pixelmonmod.pixelmon.enums.EnumPokemon;
import com.pixelmonmod.pixelmon.enums.EnumType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.util.SoundEvent;

public class BaseStats {
    public String pixelmonName;
    public int spDef;
    public int spAtt;
    public int speed;
    public int defence;
    public int attack;
    public int hp;
    public int catchRate;
    public int malePercent;
    public int nationalPokedexNumber;
    public int spawnLevel;
    public int spawnLevelRange;
    public int baseExp;
    public int baseFriendship;
    public Rarity rarity;
    public EnumType type1;
    public EnumType type2;
    public float height;
    public float width;
    public float length;
    public float giScale;
    public boolean canFly;
    public boolean isRideable;
    public EnumPokemon[] preEvolutions;
    public ExperienceGroup experienceGroup;
    public Aggression aggression;
    public SwimmingParameters swimmingParameters;
    public FlyingParameters flyingParameters;
    public SpawnLocation[] spawnLocations;
    public Integer[] biomeIDs;
    public EVsStore evGain;
    public boolean canSurf;
    public RidingOffsets ridingOffsets;
    public int maxGroupSize;
    public int minGroupSize;
    public float hoverHeight = 0.0f;
    public boolean doesHover = false;
    public int id;
    public int baseFormID;
    public float weight;
    public EnumPokemon pokemon;
    public Evolution[] evolutions;
    public String[] abilities;
    public EnumEggGroup[] eggGroups;
    public Integer eggCycles;
    public long lastSpawn = -1L;
    public int form = -1;
    private final HashMap<SoundType, ArrayList<SoundEvent>> sounds = new HashMap();
    private boolean[] soundRegistered = new boolean[]{false, false, false};

    public BaseStats(String name) {
        this.pixelmonName = name;
    }

    public void addSound(SoundType type, SoundEvent sound) {
        if (!this.soundRegistered[type.ordinal()]) {
            ArrayList<Object> list = this.sounds.get((Object)type);
            if (list == null) {
                list = new ArrayList();
            }
            list.add(sound);
            this.sounds.put(type, list);
            int id = this.nationalPokedexNumber * 3 + 1000;
            if (type == SoundType.Male) {
                ++id;
            } else if (type == SoundType.Female) {
                id += 2;
            }
            this.soundRegistered[type.ordinal()] = true;
        }
    }

    public SoundEvent getSound(SoundType type) {
        ArrayList<SoundEvent> list = this.sounds.get((Object)type);
        if (list == null) {
            return null;
        }
        return RandomHelper.getRandomElementFromList(list);
    }

    private boolean hasSound(SoundType type) {
        return this.sounds.containsKey((Object)type);
    }

    public boolean hasSoundForGender(Gender gender) {
        return this.sounds.containsKey((Object)(gender == Gender.Male ? SoundType.Male : SoundType.Female)) || this.sounds.containsKey((Object)SoundType.Neutral);
    }

    public SoundEvent getSoundForGender(Gender gender) {
        if (gender == Gender.Male) {
            if (this.hasSound(SoundType.Male)) {
                return this.getSound(SoundType.Male);
            }
        } else if (gender == Gender.Female && this.hasSound(SoundType.Female)) {
            return this.getSound(SoundType.Female);
        }
        if (this.hasSound(SoundType.Neutral)) {
            return this.getSound(SoundType.Neutral);
        }
        return null;
    }

    public int get(StatsType stat) {
        switch (stat) {
            case Attack: {
                return this.attack;
            }
            case Defence: {
                return this.defence;
            }
            case HP: {
                return this.hp;
            }
            case SpecialAttack: {
                return this.spAtt;
            }
            case SpecialDefence: {
                return this.spDef;
            }
            case Speed: {
                return this.speed;
            }
        }
        return -1;
    }

    public boolean hasEggGroup(EnumEggGroup eggGroupTarget) {
        for (EnumEggGroup eggGroup : this.eggGroups) {
            if (eggGroup != eggGroupTarget) continue;
            return true;
        }
        return false;
    }

    public List<EnumType> getTypeList() {
        ArrayList<EnumType> list = new ArrayList<EnumType>();
        list.add(this.type1);
        if (this.type2 != null) {
            list.add(this.type2);
        }
        return list;
    }

    public static enum SoundType {
        Neutral,
        Male,
        Female;

    }
}

