/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.pixelmon.stats.evolution;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.events.EvolveEvent;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonSpec;
import com.pixelmonmod.pixelmon.comm.EnumUpdateType;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.evolution.conditions.EvoCondition;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.evolution.conditions.HeldItemCondition;
import com.pixelmonmod.pixelmon.enums.EnumPokemon;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.eventhandler.Event;

public abstract class Evolution {
    public EnumPokemon from;
    public PokemonSpec to;
    public ArrayList<EvoCondition> conditions = new ArrayList();
    private int form = -1;

    public Evolution(EnumPokemon from, PokemonSpec to, EvoCondition ... conditions) {
        this.from = from;
        this.to = to;
        this.conditions.addAll(Arrays.asList(conditions));
    }

    public void setForm(int form) {
        this.form = form;
    }

    protected boolean canEvolve(EntityPixelmon pokemon) {
        for (EvoCondition evoCondition : this.conditions) {
            if (evoCondition.passes(pokemon)) continue;
            return false;
        }
        return true;
    }

    public boolean doEvolution(EntityPixelmon pokemon) {
        if (!Pixelmon.EVENT_BUS.post((Event)new EvolveEvent.PreEvolve((EntityPlayerMP)pokemon.func_70902_q(), pokemon, this))) {
            pokemon.startEvolution(this);
            return true;
        }
        return false;
    }

    public void finishedEvolving(EntityPixelmon pokemon) {
        if (this.consumesHeldItem()) {
            pokemon.setHeldItem(ItemStack.field_190927_a);
            pokemon.update(EnumUpdateType.HeldItem);
        }
        if (this.form != -1) {
            pokemon.setForm(this.form, true);
        }
    }

    public boolean consumesHeldItem() {
        for (EvoCondition evoCondition : this.conditions) {
            if (!(evoCondition instanceof HeldItemCondition)) continue;
            return true;
        }
        return false;
    }
}

