/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.pixelmon.stats.evolution.conditions;

import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.BaseStats;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.evolution.conditions.EvoCondition;
import com.pixelmonmod.pixelmon.enums.EnumPokemon;
import com.pixelmonmod.pixelmon.enums.EnumType;
import com.pixelmonmod.pixelmon.storage.PlayerStorage;
import java.util.ArrayList;
import net.minecraft.nbt.NBTTagCompound;

public class PartyCondition
extends EvoCondition {
    public ArrayList<EnumPokemon> withPokemon = new ArrayList();
    public ArrayList<EnumType> withTypes = new ArrayList();

    public PartyCondition() {
    }

    public PartyCondition(EnumPokemon ... with) {
        for (EnumPokemon pokemon : with) {
            if (pokemon == null) continue;
            this.withPokemon.add(pokemon);
        }
    }

    public PartyCondition(EnumType ... types) {
        for (EnumType type : types) {
            if (types == null) continue;
            this.withTypes.add(type);
        }
    }

    @Override
    public boolean passes(EntityPixelmon pokemon) {
        PlayerStorage storage = pokemon.getStorage().orElse(null);
        if (storage != null) {
            for (NBTTagCompound nbt : storage.partyPokemon) {
                if (nbt == null) continue;
                EnumPokemon partyPokemon = EnumPokemon.getFromNameAnyCase(nbt.func_74779_i("Name"));
                if (partyPokemon != null && this.withPokemon.contains((Object)partyPokemon)) {
                    return true;
                }
                BaseStats bs = EntityPixelmon.getBaseStats(partyPokemon).get();
                if (partyPokemon == null || !this.withTypes.contains((Object)bs.type1) && (bs.type2 == null || !this.withTypes.contains((Object)bs.type2))) continue;
                return true;
            }
        }
        return false;
    }
}

