/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.items;

import com.pixelmonmod.pixelmon.config.PixelmonItems;
import com.pixelmonmod.pixelmon.entities.pixelmon.Entity1Base;
import com.pixelmonmod.pixelmon.entities.pixelmon.Entity3HasStats;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.entities.pixelmon.EnumSpecialTexture;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.BaseStats;
import com.pixelmonmod.pixelmon.items.PixelmonItem;
import com.pixelmonmod.pixelmon.util.helpers.SpriteHelper;
import java.util.Optional;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.translation.I18n;

public class ItemPixelmonSprite
extends PixelmonItem {
    public ItemPixelmonSprite() {
        super("pixelmon_sprite");
        this.func_77637_a(null);
    }

    public static ItemStack getPhoto(EntityPixelmon pixelmon) {
        ItemStack itemStack = new ItemStack(PixelmonItems.itemPixelmonSprite);
        Optional<BaseStats> stats = Entity3HasStats.getBaseStats(pixelmon.baseStats.pixelmonName);
        if (stats.isPresent()) {
            NBTTagCompound tagCompound = new NBTTagCompound();
            String displayName = Entity1Base.getLocalizedName(pixelmon.baseStats.pixelmonName) + " " + I18n.func_74838_a((String)(PixelmonItems.itemPixelmonSprite.func_77658_a() + ".name"));
            String filePath = "pixelmon:sprites/";
            int specialTexture = pixelmon.getSpecialTextureIndex();
            if (pixelmon.isMega) {
                displayName = I18n.func_74838_a((String)"gui.trainereditor.mega") + " " + displayName;
                specialTexture = EnumSpecialTexture.None.id;
            }
            if (pixelmon.getIsShiny()) {
                filePath = filePath + "shiny";
                displayName = I18n.func_74838_a((String)"gui.trainereditor.shiny") + " " + displayName;
                specialTexture = EnumSpecialTexture.None.id;
            }
            if (specialTexture != EnumSpecialTexture.None.id) {
                displayName = I18n.func_74838_a((String)"gui.trainereditor.special") + " " + displayName;
            }
            filePath = filePath + "pokemon/" + String.format("%03d", stats.get().nationalPokedexNumber) + SpriteHelper.getSpriteExtra(pixelmon.baseStats.pixelmonName, pixelmon.getForm(), pixelmon.getGender(), specialTexture);
            tagCompound.func_74778_a("SpriteName", filePath);
            itemStack.func_77982_d(tagCompound);
            itemStack.func_151001_c(displayName);
        }
        return itemStack;
    }
}

