/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.pokedex;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.comm.PixelmonPokedexPacket;
import com.pixelmonmod.pixelmon.database.DatabaseHelper;
import com.pixelmonmod.pixelmon.enums.EnumPokemon;
import com.pixelmonmod.pixelmon.pokedex.EnumPokedexRegisterStatus;
import com.pixelmonmod.pixelmon.pokedex.PokedexEntry;
import java.sql.ResultSet;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class Pokedex {
    public static final HashMap<Integer, PokedexEntry> fullPokedex = new HashMap();
    public static final HashMap<String, Integer> nameToID = new HashMap();
    public static final int pokedexSize = 807;
    public Entity owner;
    private HashMap<Integer, EnumPokedexRegisterStatus> seenMap;

    public static void init() {
    }

    public static int nameToID(String name) {
        if (name.equals("Ho-oh")) {
            name = "Ho-Oh";
        }
        return nameToID.getOrDefault(name, 0);
    }

    public static boolean isEntryEmpty(int i) {
        if (!fullPokedex.containsKey(i)) {
            return true;
        }
        String checkName = Pokedex.fullPokedex.get((Object)Integer.valueOf((int)i)).name;
        return checkName.equals("???") || !EnumPokemon.getNameList().contains((Object)checkName);
    }

    public Pokedex() {
        this(null);
    }

    public Pokedex(Entity e) {
        this.owner = e;
        this.seenMap = new HashMap();
    }

    public NBTTagCompound readFromNBT(NBTTagCompound nbt) {
        this.seenMap.clear();
        NBTTagList nbtl = nbt.func_150295_c("Pokedex", 8);
        for (int i = 0; i < nbtl.func_74745_c(); ++i) {
            try {
                String[] s = nbtl.func_150307_f(i).split(":");
                this.seenMap.put(Integer.parseInt(s[0]), EnumPokedexRegisterStatus.get(Integer.parseInt(s[1])));
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return nbt;
    }

    public HashMap<Integer, EnumPokedexRegisterStatus> getSeenMap() {
        return this.seenMap;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        NBTTagList nbtl = new NBTTagList();
        for (Map.Entry<Integer, EnumPokedexRegisterStatus> e : this.seenMap.entrySet()) {
            nbtl.func_74742_a((NBTBase)new NBTTagString(e.getKey() + ":" + e.getValue().ordinal()));
        }
        nbt.func_74782_a("Pokedex", (NBTBase)nbtl);
        return nbt;
    }

    public void sendToPlayer(EntityPlayerMP e) {
        PixelmonPokedexPacket p = new PixelmonPokedexPacket(this);
        Pixelmon.network.sendTo((IMessage)p, e);
    }

    public void set(int id, EnumPokedexRegisterStatus drs) {
        if (!(this.seenMap.containsKey(id) && this.seenMap.get(id).ordinal() > drs.ordinal() || id <= 0 || id > 807)) {
            this.seenMap.put(id, drs);
        }
    }

    public EnumPokedexRegisterStatus get(int id) {
        EnumPokedexRegisterStatus d = this.seenMap.get(id);
        if (d == null) {
            d = EnumPokedexRegisterStatus.unknown;
        }
        return d;
    }

    public boolean isUnknown(int id) {
        return this.get(id) == EnumPokedexRegisterStatus.unknown;
    }

    public boolean hasSeen(int id) {
        EnumPokedexRegisterStatus d = this.get(id);
        return d == EnumPokedexRegisterStatus.seen || this.hasCaught(id);
    }

    public boolean hasCaught(int id) {
        return this.get(id) == EnumPokedexRegisterStatus.caught;
    }

    public PokedexEntry getEntry(int id) {
        PokedexEntry e = fullPokedex.get(id);
        if (e == null) {
            e = new PokedexEntry(id, "???", 0.0f, 0.0f);
        }
        return e;
    }

    public int countCaught() {
        int count = 0;
        for (int i = 1; i <= 807; ++i) {
            if (!this.hasCaught(i)) continue;
            ++count;
        }
        return count;
    }

    public void setSeenList(HashMap<Integer, EnumPokedexRegisterStatus> data) {
        this.seenMap = data;
    }

    public static void getNBTTags(HashMap<String, Class> tags) {
        tags.put("Pokedex", NBTTagList.class);
    }

    static {
        try {
            ResultSet r = DatabaseHelper.getResultSet("select * from PIXELMON");
            while (r.next()) {
                String n = r.getString("PIXELMONFULLNAME");
                int i = r.getInt("NATIONALPOKEDEXNUMBER");
                float w = r.getFloat("POKEDEXWEIGHT");
                float h = r.getFloat("POKEDEXHEIGHT");
                fullPokedex.put(i, new PokedexEntry(i, n, w, h));
                nameToID.put(n, i);
            }
        }
        catch (Exception var5) {
            var5.printStackTrace();
        }
    }
}

