/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.spawning.spawners;

import com.pixelmonmod.pixelmon.RandomHelper;
import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import com.pixelmonmod.pixelmon.database.SpawnLocation;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.FlyingParameters;
import com.pixelmonmod.pixelmon.spawning.SpawnData;
import com.pixelmonmod.pixelmon.spawning.SpawnRegistry;
import com.pixelmonmod.pixelmon.spawning.spawners.SpawnerBase;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityLiving;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;

public class SpawnerAir
extends SpawnerBase {
    static Set<Material> validFloorMaterials = new HashSet<Material>();
    static Set<Material> validAirMaterials;

    public SpawnerAir() {
        super(SpawnLocation.AirPersistent);
    }

    @Override
    public Integer getSpawnConditionY(World world, BlockPos pos) {
        if (world.func_72912_H().func_76067_t() == WorldType.field_77138_c && this.isBlockValidForPixelmonSpawning(world, new BlockPos(pos.func_177958_n(), world.func_175645_m(pos).func_177956_o(), pos.func_177952_p()))) {
            return world.func_175645_m(pos).func_177956_o();
        }
        Integer topEarth = this.getTopEarthBlock(world, pos, false);
        Integer cpY = null;
        if (topEarth != null && this.isBlockValidForPixelmonSpawning(world, new BlockPos(pos.func_177958_n(), topEarth.intValue(), pos.func_177952_p()))) {
            cpY = topEarth;
        }
        return cpY;
    }

    @Override
    public List<SpawnData> getEntityList(String biomeID) {
        return SpawnRegistry.getAirSpawnsForBiome(biomeID);
    }

    @Override
    public boolean canPokemonSpawnHereImpl(World world, BlockPos pos) {
        return true;
    }

    @Override
    public float getYOffset(float x, float y, float z, EntityLiving pokemonName) {
        FlyingParameters parameters = ((EntityPixelmon)pokemonName).getFlyingParameters();
        if (parameters == null) {
            return 0.0f;
        }
        int heightMin = parameters.flyHeightMin;
        int heightMax = parameters.flyHeightMax;
        return RandomHelper.getRandomNumberBetween(heightMin, heightMax);
    }

    @Override
    public Set<Material> getSpawnCheckMaterials() {
        return validFloorMaterials;
    }

    @Override
    public Set<Material> getValidSpawnAirMaterials() {
        return validAirMaterials;
    }

    @Override
    public int getMaxNum() {
        return PixelmonConfig.maxNumAirPokemon;
    }

    static {
        validFloorMaterials.add(Material.field_151596_z);
        validFloorMaterials.add(Material.field_151577_b);
        validFloorMaterials.add(Material.field_151578_c);
        validFloorMaterials.add(Material.field_151588_w);
        validFloorMaterials.add(Material.field_151584_j);
        validFloorMaterials.add(Material.field_151576_e);
        validFloorMaterials.add(Material.field_151595_p);
        validAirMaterials = new HashSet<Material>();
        validAirMaterials.add(Material.field_151579_a);
        validAirMaterials.add(Material.field_151585_k);
        validAirMaterials.add(Material.field_151597_y);
        validAirMaterials.add(Material.field_151582_l);
    }
}

