/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.storage;

import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.entities.pixelmon.EnumSpecialTexture;
import com.pixelmonmod.pixelmon.enums.EnumPokemon;
import com.pixelmonmod.pixelmon.storage.BackpackType;
import com.pixelmonmod.pixelmon.storage.PlayerExtras;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;

public class PlayerExtraData {
    private static final long MILLISECS_IN_DAY = 86400000L;
    public UUID id;
    public boolean sashEnabled = true;
    private PlayerExtras.HatType hatType = PlayerExtras.HatType.NONE;
    private BackpackType backpackType;
    private long lastCheckedTime = 0L;
    public boolean isAdmin = false;
    public boolean isModeller = false;
    public boolean isDeveloper = false;
    public boolean isSupport = false;
    public boolean isJAdmin = false;
    public boolean isCompWinner = false;
    public boolean hasHalloween = false;
    public boolean hasLugia = false;
    public boolean hasSash;
    public boolean hasRainbowSash = false;
    public boolean hasCap = false;
    public int[] colours = new int[]{-1, -1, -1};
    public int[] capColours = new int[]{0, 0, 0};

    public PlayerExtraData(EntityPlayer player) {
        this.id = player.func_110124_au();
    }

    public PlayerExtraData(UUID id) {
        this.id = id;
    }

    public PlayerExtraData(ByteBuf buf) {
        this.id = new UUID(buf.readLong(), buf.readLong());
        this.isAdmin = buf.readBoolean();
        this.isDeveloper = buf.readBoolean();
        this.isModeller = buf.readBoolean();
        this.isSupport = buf.readBoolean();
        this.isJAdmin = buf.readBoolean();
        this.isCompWinner = buf.readBoolean();
        this.hasHalloween = buf.readBoolean();
        this.hasLugia = buf.readBoolean();
        this.sashEnabled = buf.readBoolean();
        this.hasSash = buf.readBoolean();
        this.colours[0] = buf.readShort();
        this.colours[1] = buf.readShort();
        this.colours[2] = buf.readShort();
        this.hatType = PlayerExtras.HatType.getFromId(buf.readShort());
        this.hasRainbowSash = buf.readBoolean();
        this.hasCap = buf.readBoolean();
        this.capColours[0] = buf.readShort();
        this.capColours[1] = buf.readShort();
        this.capColours[2] = buf.readShort();
    }

    public void setDataValues(PlayerExtraData extras) {
        this.hasHalloween = extras.hasHalloween;
        this.hasLugia = extras.hasLugia;
        this.lastCheckedTime = System.currentTimeMillis();
        this.isAdmin = extras.isAdmin;
        this.isModeller = extras.isModeller;
        this.isDeveloper = extras.isDeveloper;
        this.isSupport = extras.isSupport;
        this.isJAdmin = extras.isJAdmin;
        this.isCompWinner = extras.isCompWinner;
        this.hasSash = extras.hasSash;
        this.hasRainbowSash = extras.hasRainbowSash;
        this.colours = extras.colours;
        this.hasCap = extras.hasCap;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeLong(this.id.getMostSignificantBits());
        buf.writeLong(this.id.getLeastSignificantBits());
        buf.writeBoolean(this.isAdmin);
        buf.writeBoolean(this.isDeveloper);
        buf.writeBoolean(this.isModeller);
        buf.writeBoolean(this.isSupport);
        buf.writeBoolean(this.isJAdmin);
        buf.writeBoolean(this.isCompWinner);
        buf.writeBoolean(this.hasHalloween);
        buf.writeBoolean(this.hasLugia);
        buf.writeBoolean(this.sashEnabled);
        buf.writeBoolean(this.hasSash);
        buf.writeShort(this.colours[0]);
        buf.writeShort(this.colours[1]);
        buf.writeShort(this.colours[2]);
        buf.writeShort(this.hatType.id);
        buf.writeBoolean(this.hasRainbowSash);
        buf.writeBoolean(this.hasCap);
        buf.writeShort(this.capColours[0]);
        buf.writeShort(this.capColours[1]);
        buf.writeShort(this.capColours[2]);
    }

    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74757_a("edia", this.isAdmin);
        nbt.func_74757_a("edid", this.isDeveloper);
        nbt.func_74757_a("edim", this.isModeller);
        nbt.func_74757_a("edis", this.isSupport);
        nbt.func_74757_a("edij", this.isJAdmin);
        nbt.func_74757_a("edicw", this.isCompWinner);
        nbt.func_74757_a("edh", this.hasHalloween);
        nbt.func_74757_a("edhl", this.hasLugia);
        nbt.func_74757_a("edse", this.sashEnabled);
        nbt.func_74757_a("eds", this.hasSash);
        nbt.func_74772_a("edt", this.lastCheckedTime);
        nbt.func_74777_a("edcr", (short)this.colours[0]);
        nbt.func_74777_a("edcg", (short)this.colours[1]);
        nbt.func_74777_a("edcb", (short)this.colours[2]);
        nbt.func_74777_a("edcht", (short)this.hatType.id);
        nbt.func_74757_a("edrs", this.hasRainbowSash);
        nbt.func_74757_a("edhcap", this.hasCap);
        nbt.func_74777_a("edcapr", (short)this.capColours[0]);
        nbt.func_74777_a("edcapg", (short)this.capColours[1]);
        nbt.func_74777_a("edcapb", (short)this.capColours[2]);
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this.isAdmin = nbt.func_74767_n("edia");
        this.isDeveloper = nbt.func_74767_n("edid");
        this.isModeller = nbt.func_74767_n("edim");
        this.isSupport = nbt.func_74767_n("edis");
        this.isJAdmin = nbt.func_74767_n("edij");
        this.isCompWinner = nbt.func_74767_n("edicw");
        this.hasHalloween = nbt.func_74767_n("edh");
        this.hasLugia = nbt.func_74767_n("edhl");
        this.sashEnabled = nbt.func_74767_n("edse");
        this.hasSash = nbt.func_74767_n("eds");
        this.lastCheckedTime = nbt.func_74763_f("edt");
        this.colours[0] = nbt.func_74765_d("edcr");
        this.colours[1] = nbt.func_74765_d("edcg");
        this.colours[2] = nbt.func_74765_d("edcb");
        this.hatType = PlayerExtras.HatType.getFromId(nbt.func_74765_d("edcht"));
        this.hasRainbowSash = nbt.func_74767_n("edrs");
        this.hasCap = nbt.func_74767_n("edhcap");
        this.capColours[0] = nbt.func_74765_d("edcapr");
        this.capColours[1] = nbt.func_74765_d("edcapg");
        this.capColours[2] = nbt.func_74765_d("edcapb");
    }

    public boolean canSeeTexture(EnumPokemon pokemon) {
        return pokemon == EnumPokemon.Haunter && this.hasHalloween || pokemon == EnumPokemon.Lugia && this.hasLugia;
    }

    public void checkPokemon(EntityPixelmon pixelmon) {
        if (pixelmon.getSpecialTextureIndex() == EnumSpecialTexture.Online.id && !this.canSeeTexture(pixelmon.getSpecies())) {
            pixelmon.setSpecialTexture(EnumSpecialTexture.None.id);
        }
    }

    public boolean hasData() {
        return this.hasHalloween || this.hasLugia || this.hasCap || this.hasSash;
    }

    public boolean shouldRefresh() {
        long currentTime = System.currentTimeMillis();
        return currentTime < this.lastCheckedTime ? true : currentTime - this.lastCheckedTime > 604800000L;
    }

    public void reset() {
        this.lastCheckedTime = 0L;
    }

    public void removeHat() {
        this.hatType = PlayerExtras.HatType.NONE;
    }

    public PlayerExtras.HatType getHatType() {
        if (!this.canHaveHat(this.hatType)) {
            this.hatType = PlayerExtras.HatType.NONE;
        }
        return this.hatType;
    }

    public BackpackType getBackpackType() {
        return this.backpackType;
    }

    public boolean setHatType(PlayerExtras.HatType hat) {
        if (this.canHaveHat(hat)) {
            this.hatType = hat;
            return true;
        }
        return false;
    }

    public void setCapColours(int r, int g, int b) {
        if (this.canHaveHat(PlayerExtras.HatType.TRAINER_HAT)) {
            this.capColours[0] = r;
            this.capColours[1] = g;
            this.capColours[2] = b;
        }
    }

    private boolean canHaveHat(PlayerExtras.HatType hat) {
        return hat == PlayerExtras.HatType.NONE ? true : (hat == PlayerExtras.HatType.TRAINER_HAT ? this.hasCap : this.isAdmin || this.isDeveloper || this.isModeller || this.isSupport || this.isJAdmin || this.isCompWinner);
    }

    public void setBackpackType(BackpackType backpackType) {
        this.backpackType = backpackType;
    }
}

