/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.storage.playerData;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.comm.packetHandlers.clientStorage.UpdateClientPlayerData;
import com.pixelmonmod.pixelmon.enums.EnumMegaItem;
import com.pixelmonmod.pixelmon.enums.EnumPokemon;
import com.pixelmonmod.pixelmon.listener.EntityPlayerExtension;
import com.pixelmonmod.pixelmon.storage.PlayerStorage;
import java.util.HashMap;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class MegaData {
    private EnumMegaItem megaItem = EnumMegaItem.Disabled;
    private HashMap<EnumPokemon, int[]> megasObtained = new HashMap();
    private final PlayerStorage parentStorage;

    public MegaData(PlayerStorage playerStorage) {
        this.parentStorage = playerStorage;
    }

    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74778_a("MegaItemString", this.megaItem.toString());
        NBTTagList tagList = new NBTTagList();
        for (EnumPokemon pokemon : this.megasObtained.keySet()) {
            NBTTagCompound megaObtainedNBT = new NBTTagCompound();
            megaObtainedNBT.func_74778_a("Name", pokemon.toString());
            int[] forms = this.megasObtained.get((Object)pokemon);
            megaObtainedNBT.func_74783_a("Variant", forms);
            tagList.func_74742_a((NBTBase)megaObtainedNBT);
        }
        nbt.func_74782_a("MegasObtained", (NBTBase)tagList);
    }

    public void readFromNBT(NBTTagCompound nbt) {
        if (nbt.func_74764_b("MegaItemString")) {
            this.setMegaItem(EnumMegaItem.getFromString(nbt.func_74779_i("MegaItemString")), false);
        }
        if (nbt.func_74764_b("MegasObtained")) {
            NBTTagList list = nbt.func_150295_c("MegasObtained", 10);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound megaInfo = (NBTTagCompound)list.func_179238_g(i);
                EnumPokemon pokemon = EnumPokemon.get(megaInfo.func_74779_i("Name"));
                int[] forms = megaInfo.func_74759_k("Variant");
                this.megasObtained.put(pokemon, forms);
            }
        }
    }

    public static void getNBTTags(HashMap<String, Class> tags) {
        tags.put("MegaItemString", String.class);
        tags.put("MegasObtained", NBTTagList.class);
    }

    public boolean isMegaItemObtained(EnumPokemon pokemon, int form) {
        if (this.megasObtained.containsKey((Object)pokemon)) {
            int[] forms;
            for (int f : forms = this.megasObtained.get((Object)pokemon)) {
                if (f != form) continue;
                return true;
            }
        }
        return false;
    }

    public void obtainedItem(EnumPokemon pokemon, int form, EntityPlayerMP player) {
        if (this.megasObtained.containsKey((Object)pokemon)) {
            int[] forms;
            for (int f : forms = this.megasObtained.get((Object)pokemon)) {
                if (f != form) continue;
                return;
            }
            int[] newForms = new int[forms.length + 1];
            for (int i = 0; i < forms.length; ++i) {
                newForms[i] = forms[i];
            }
            newForms[newForms.length - 1] = form;
            this.megasObtained.put(pokemon, newForms);
        } else {
            this.megasObtained.put(pokemon, new int[]{form});
        }
        if (this.megaItem == EnumMegaItem.Disabled) {
            this.setMegaItem(EnumMegaItem.None, true);
        }
    }

    public void setMegaItem(EnumMegaItem megaItem, boolean giveChoice) {
        this.megaItem = megaItem;
        if (this.parentStorage.getPlayer() != null) {
            if (giveChoice) {
                Pixelmon.network.sendTo((IMessage)new UpdateClientPlayerData(this.megaItem, true), this.parentStorage.getPlayer());
            }
            EntityPlayerExtension.updatePlayerMegaItem(this.parentStorage.getPlayer(), this.megaItem);
        }
    }

    public boolean canEquipMegaItem() {
        return !this.megasObtained.isEmpty();
    }

    public EnumMegaItem getMegaItem() {
        return this.megaItem;
    }
}

