/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.worldGeneration.structure.worldGen;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.RandomHelper;
import com.pixelmonmod.pixelmon.api.events.PixelmonStructureGenerationEvent;
import com.pixelmonmod.pixelmon.config.PixelmonItemsBadges;
import com.pixelmonmod.pixelmon.entities.npcs.NPCChatting;
import com.pixelmonmod.pixelmon.entities.npcs.NPCTrainer;
import com.pixelmonmod.pixelmon.entities.npcs.registry.GymNPCData;
import com.pixelmonmod.pixelmon.entities.npcs.registry.ServerNPCRegistry;
import com.pixelmonmod.pixelmon.enums.EnumEncounterMode;
import com.pixelmonmod.pixelmon.enums.EnumNPCType;
import com.pixelmonmod.pixelmon.enums.EnumTrainerAI;
import com.pixelmonmod.pixelmon.enums.EnumType;
import com.pixelmonmod.pixelmon.items.ItemBadge;
import com.pixelmonmod.pixelmon.worldGeneration.structure.StructureInfo;
import com.pixelmonmod.pixelmon.worldGeneration.structure.StructureRegistry;
import com.pixelmonmod.pixelmon.worldGeneration.structure.gyms.GymInfo;
import com.pixelmonmod.pixelmon.worldGeneration.structure.gyms.WorldGymData;
import com.pixelmonmod.pixelmon.worldGeneration.structure.gyms.WorldGymInfo;
import com.pixelmonmod.pixelmon.worldGeneration.structure.towns.ComponentTownPart;
import com.pixelmonmod.pixelmon.worldGeneration.structure.towns.NPCPlacementInfo;
import com.pixelmonmod.pixelmon.worldGeneration.structure.util.StructureScattered;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.structure.MapGenScatteredFeature;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;

public class WorldGenGym
extends MapGenScatteredFeature
implements IWorldGenerator {
    public static StructureBoundingBox lastTownBB;
    static final int distance = 30;
    private static List<GymPlacementInfo> gymPositionList;
    public static List<StructureBoundingBox> usedTownsList;
    private int ticks = 100;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        if (lastTownBB == null) {
            return;
        }
        int minX = chunkX * 16;
        int maxX = minX + 16;
        int minZ = chunkZ * 16;
        int maxZ = minZ + 16;
        if (this.isClose(minX, maxX, WorldGenGym.lastTownBB.field_78897_a, WorldGenGym.lastTownBB.field_78893_d) && this.isClose(minZ, maxZ, WorldGenGym.lastTownBB.field_78896_c, WorldGenGym.lastTownBB.field_78892_f)) {
            GymInfo gyminfo;
            WorldGymData data = (WorldGymData)world.getPerWorldStorage().func_75742_a(WorldGymData.class, "gyminfo");
            if (data == null) {
                data = new WorldGymData();
                world.getPerWorldStorage().func_75745_a("gyminfo", (WorldSavedData)data);
            }
            if ((gyminfo = StructureRegistry.getNextGym(data, random)) == null || gyminfo.type == null || this.getBadge(data, gyminfo.type) == null) {
                if (gyminfo != null && gyminfo.type == null) {
                    Pixelmon.LOGGER.info("Gym type info not found. External JSON files are probably not updated correctly.");
                }
                return;
            }
            for (int i = 0; i < 10; ++i) {
                int zPos;
                int yPos;
                int xPos = random.nextInt(16) + chunkX * 16;
                BlockPos pos = new BlockPos(xPos, yPos = 64, zPos = random.nextInt(16) + chunkZ * 16);
                StructureScattered s = gyminfo.createStructure(random, pos, true, false, null);
                if (!this.canSpawnStructureAtCoords(world, s, gyminfo, pos) || !(ComponentTownPart.getCenter(s.func_74874_b()).func_177951_i((Vec3i)ComponentTownPart.getCenter(lastTownBB)) > 100.0)) continue;
                List<GymPlacementInfo> list = gymPositionList;
                synchronized (list) {
                    gymPositionList.add(new GymPlacementInfo(s, gyminfo, pos, lastTownBB));
                    continue;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public void onTick(TickEvent.WorldTickEvent event) {
        if (event.side == Side.CLIENT) {
            return;
        }
        --this.ticks;
        if (this.ticks != 0) {
            return;
        }
        this.ticks = 100;
        List<GymPlacementInfo> list = gymPositionList;
        synchronized (list) {
            List<StructureBoundingBox> list2 = usedTownsList;
            synchronized (list2) {
                while (gymPositionList.size() > 0) {
                    if (!usedTownsList.contains(WorldGenGym.gymPositionList.get((int)0).lastTownBB)) {
                        GymPlacementInfo info = gymPositionList.get(0);
                        WorldGymData data = (WorldGymData)event.world.getPerWorldStorage().func_75742_a(WorldGymData.class, "gyminfo");
                        if (data != null && info.gyminfo.type != null) {
                            ItemStack badge;
                            info.struc.signItem = badge = this.getBadge(data, info.gyminfo.type);
                            boolean generated = info.struc.generate(event.world, event.world.field_73012_v);
                            PixelmonStructureGenerationEvent.Post generationEvent = new PixelmonStructureGenerationEvent.Post(event.world, info.struc, (StructureInfo)info.gyminfo, info.gymPos, generated);
                            Pixelmon.EVENT_BUS.post((Event)generationEvent);
                            if (generated) {
                                info.gyminfo.level = data.getGymLevel();
                                WorldGenGym.spawnNPCs(event.world, info.struc, info.gyminfo, badge);
                                data.addGym(info.gyminfo.name, badge, info.gyminfo.level);
                                usedTownsList.add(info.lastTownBB);
                                for (int j = 1; j < gymPositionList.size(); ++j) {
                                    if (WorldGenGym.gymPositionList.get((int)0).lastTownBB != WorldGenGym.gymPositionList.get((int)j).lastTownBB && !(WorldGenGym.gymPositionList.get((int)0).gymPos.func_177951_i((Vec3i)WorldGenGym.gymPositionList.get((int)j).gymPos) < 6400.0)) continue;
                                    gymPositionList.remove(j);
                                    --j;
                                }
                            }
                        }
                    }
                    gymPositionList.remove(0);
                }
            }
        }
    }

    private ItemStack getBadge(WorldGymData data, EnumType[] types) {
        ArrayList<ItemBadge> clearedList = PixelmonItemsBadges.getBadgeList(types);
        for (WorldGymInfo info : data.getGymList()) {
            if (!clearedList.contains(info.badge.func_77973_b())) continue;
            clearedList.remove(info.badge.func_77973_b());
        }
        if (clearedList.size() == 0) {
            clearedList = PixelmonItemsBadges.getBadgeList(types);
        }
        return new ItemStack((Item)RandomHelper.getRandomElementFromList(clearedList));
    }

    public static void spawnNPCs(World world, StructureScattered s, GymInfo gymInfo) {
        WorldGenGym.spawnNPCs(world, s, gymInfo, new ItemStack((Item)PixelmonItemsBadges.getRandomBadge(gymInfo.type)));
    }

    public static void spawnNPCs(World world, StructureScattered s, GymInfo gymInfo, ItemStack badge) {
        for (NPCPlacementInfo npcInfo : gymInfo.getNPCS()) {
            GymNPCData data;
            if (npcInfo.npcType == EnumNPCType.ChattingNPC) {
                NPCChatting npc = new NPCChatting(world);
                data = ServerNPCRegistry.getGymMember(npcInfo.npcName);
                if (data == null) {
                    Pixelmon.LOGGER.warn("Can't find Gym NPC " + npcInfo.npcName);
                    continue;
                }
                npc.init(data);
                npc.setCustomSteveTexture(data.textures.get(data.getRandomTextureIndex()));
                npc.initDefaultAI();
                npc.ignoreDespawnCounter = true;
                WorldGenGym.spawnVillager(world, s, npcInfo.x, npcInfo.y, npcInfo.z, (EntityLiving)npc);
                continue;
            }
            if (npcInfo.npcType != EnumNPCType.Trainer) continue;
            NPCTrainer trainer = new NPCTrainer(world);
            data = ServerNPCRegistry.getGymMember(npcInfo.npcName);
            if (data == null) {
                Pixelmon.LOGGER.warn("Can't find Gym NPC " + npcInfo.npcName);
                continue;
            }
            trainer.init(data, gymInfo, npcInfo.tier);
            trainer.setAIMode(EnumTrainerAI.StillAndEngage);
            trainer.initAI();
            trainer.setEncounterMode(EnumEncounterMode.OncePerPlayer);
            trainer.setStartRotationYaw(WorldGenGym.getRotation(npcInfo.rotation, s.getFacing()));
            if (npcInfo.drops != null) {
                ArrayList<ItemStack> dropsList = new ArrayList<ItemStack>();
                dropsList.add(RandomHelper.getRandomElementFromList(npcInfo.drops));
                if (npcInfo.tier == 0 && badge != null) {
                    dropsList.add(badge);
                }
                trainer.updateDrops(dropsList.toArray(new ItemStack[dropsList.size()]));
            }
            trainer.ignoreDespawnCounter = true;
            WorldGenGym.spawnVillager(world, s, npcInfo.x, npcInfo.y, npcInfo.z, (EntityLiving)trainer);
        }
    }

    private static float getRotation(int rotation, EnumFacing facing) {
        switch (facing) {
            case EAST: {
                return rotation;
            }
            case WEST: {
                return rotation + 180;
            }
            case NORTH: {
                return rotation - 90;
            }
            case SOUTH: {
                return rotation + 90;
            }
        }
        return 0.0f;
    }

    protected static void spawnVillager(World worldIn, StructureScattered s, int x, int y, int z, EntityLiving entity) {
        int xoff = s.getX(x, z);
        int yoff = s.getY(y);
        int zoff = s.getZ(x, z);
        if (!s.func_74874_b().func_175898_b((Vec3i)new BlockPos(xoff, yoff, zoff))) {
            return;
        }
        entity.func_70012_b((double)xoff + 0.5, (double)yoff, (double)zoff + 0.5, 0.0f, 0.0f);
        worldIn.func_72838_d((Entity)entity);
    }

    private boolean isClose(int min1, int max1, int min2, int max2) {
        return Math.abs(min1 - min2) < 30 || Math.abs(min1 - max2) < 30 || Math.abs(max1 - min2) < 30 || Math.abs(max1 - max2) < 30;
    }

    protected boolean canSpawnStructureAtCoords(World world, StructureScattered s, GymInfo gyminfo, BlockPos pos) {
        PixelmonStructureGenerationEvent.Pre generationEvent = new PixelmonStructureGenerationEvent.Pre(world, s, gyminfo, pos);
        Pixelmon.EVENT_BUS.post((Event)generationEvent);
        return !generationEvent.isCanceled();
    }

    static {
        gymPositionList = Collections.synchronizedList(new ArrayList());
        usedTownsList = Collections.synchronizedList(new ArrayList());
    }

    private class GymPlacementInfo {
        public StructureScattered struc;
        public GymInfo gyminfo;
        public BlockPos gymPos;
        public StructureBoundingBox lastTownBB;

        public GymPlacementInfo(StructureScattered s, GymInfo gyminfo, BlockPos pos, StructureBoundingBox lastTownBB) {
            this.struc = s;
            this.gyminfo = gyminfo;
            this.gymPos = pos;
            this.lastTownBB = lastTownBB;
        }
    }
}

