/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.vanillafix.crashes;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import net.minecraft.client.Minecraft;
import net.minecraft.crash.CrashReport;
import net.minecraft.util.ReportedException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dimdev.vanillafix.crashes.IPatchedMinecraft;

public final class CrashUtils {
    private static final Logger log = LogManager.getLogger((String)"VF");

    public static void crash(CrashReport report) {
        throw new ReportedException(report);
    }

    public static void warn(CrashReport report) {
        if (CrashUtils.isClient()) {
            CrashUtils.outputReport(report);
            ((IPatchedMinecraft)Minecraft.func_71410_x()).showWarningScreen(report);
        } else {
            log.fatal(report.func_71501_a(), report.func_71505_b());
        }
    }

    public static void notify(CrashReport report) {
        if (CrashUtils.isClient()) {
            CrashUtils.outputReport(report);
            ((IPatchedMinecraft)Minecraft.func_71410_x()).makeErrorNotification(report);
        } else {
            log.fatal(report.func_71501_a(), report.func_71505_b());
        }
    }

    public static void outputReport(CrashReport report) {
        try {
            if (report.func_71497_f() == null) {
                String reportName = "crash-";
                reportName = reportName + new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss").format(new Date());
                reportName = reportName + (Minecraft.func_71410_x().func_152345_ab() ? "-client" : "-server");
                reportName = reportName + ".txt";
                File reportsDir = CrashUtils.isClient() ? new File(Minecraft.func_71410_x().field_71412_D, "crash-reports") : new File("crash-reports");
                File reportFile = new File(reportsDir, reportName);
                report.func_147149_a(reportFile);
            }
        }
        catch (Throwable e) {
            log.fatal("Failed saving report", e);
        }
        log.fatal("Minecraft ran into a problem! " + (report.func_71497_f() != null ? "Report saved to: " + report.func_71497_f() : "Crash report could not be saved.") + "\n" + report.func_71502_e());
    }

    private static boolean isClient() {
        try {
            return Minecraft.func_71410_x() != null;
        }
        catch (NoClassDefFoundError e) {
            return false;
        }
    }
}

