/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.pokemon;

import com.pixelmonmod.pixelmon.api.comm.IReflectingMessage;
import com.pixelmonmod.pixelmon.client.models.PixelmonModelRegistry;
import com.pixelmonmod.pixelmon.comm.EnumUpdateType;
import com.pixelmonmod.pixelmon.config.PixelmonServerConfig;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.entities.pixelmon.EnumSpecialTexture;
import com.pixelmonmod.pixelmon.entities.pixelmon.abilities.AbilityBase;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.Gender;
import com.pixelmonmod.pixelmon.enums.EnumBossMode;
import com.pixelmonmod.pixelmon.enums.EnumGrowth;
import com.pixelmonmod.pixelmon.enums.EnumNature;
import com.pixelmonmod.pixelmon.enums.EnumPokemon;
import com.pixelmonmod.pixelmon.enums.forms.EnumForms;
import com.pixelmonmod.pixelmon.enums.forms.IEnumForm;
import com.pixelmonmod.pixelmon.enums.items.EnumPokeballs;
import java.lang.reflect.Field;
import java.util.Optional;
import net.minecraft.client.model.ModelBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class PokemonSpec
implements IReflectingMessage {
    private int specialTexture = -1;
    public String name = null;
    public Integer level = null;
    public Integer gender = null;
    public Integer growth = null;
    public Integer nature = null;
    public String ability = null;
    public Integer boss = null;
    public Boolean shiny = null;
    public Integer form = null;
    public Integer ball = null;

    public PokemonSpec(String ... args) {
        if (args != null && args.length > 0) {
            String[] var2 = args;
            int var3 = args.length;
            for (int var4 = 0; var4 < var3; ++var4) {
                String arg = var2[var4];
                if (EnumPokemon.hasPokemonAnyCase(arg)) {
                    this.name = EnumPokemon.getFromNameAnyCase((String)arg).name;
                    continue;
                }
                if (arg.toLowerCase().equals("random")) {
                    this.name = EnumPokemon.randomPoke().name;
                    continue;
                }
                String[] splits = arg.split(":");
                try {
                    String key = splits[0].toLowerCase();
                    if (!key.equals("s") && !key.equals("shiny")) {
                        if (!key.equals("!s") && !key.equals("!shiny")) {
                            String value = splits[1];
                            switch (key.toLowerCase()) {
                                case "level": 
                                case "lvl": {
                                    this.level = Integer.parseInt(value);
                                    if (this.level >= 1 && this.level <= PixelmonServerConfig.maxLevel) break;
                                    this.level = null;
                                    break;
                                }
                                case "g": 
                                case "gender": {
                                    if (Gender.getGender(value) != null) {
                                        this.gender = Gender.getGender(value).ordinal();
                                        break;
                                    }
                                    this.gender = Gender.getGender(Short.parseShort(value)).ordinal();
                                    break;
                                }
                                case "n": 
                                case "nature": {
                                    if (EnumNature.hasNature(value)) {
                                        this.nature = EnumNature.natureFromString((String)value).index;
                                        break;
                                    }
                                    this.nature = EnumNature.getNatureFromIndex((int)Integer.parseInt((String)value)).index;
                                    break;
                                }
                                case "gr": 
                                case "growth": {
                                    if (EnumGrowth.hasGrowth(value)) {
                                        this.growth = EnumGrowth.growthFromString((String)value).index;
                                        break;
                                    }
                                    this.growth = EnumGrowth.getGrowthFromIndex((int)Integer.parseInt((String)value)).index;
                                    break;
                                }
                                case "ability": 
                                case "ab": {
                                    Optional<AbilityBase> optAbility = AbilityBase.getAbility(value);
                                    this.ability = optAbility.map(AbilityBase::getName).orElse(null);
                                    break;
                                }
                                case "boss": 
                                case "b": {
                                    this.boss = EnumBossMode.hasBossMode(value) ? Integer.valueOf(EnumBossMode.getBossMode((String)value).index) : Integer.valueOf(EnumBossMode.getMode((int)Integer.parseInt((String)value)).index);
                                    if (this.boss != EnumBossMode.Equal.index) break;
                                    this.boss = null;
                                    break;
                                }
                                case "form": 
                                case "f": {
                                    int tempForm = -1;
                                    try {
                                        tempForm = Integer.parseInt(value);
                                    }
                                    catch (Exception exc) {
                                        tempForm = EnumPokemon.getFormFromName(EnumPokemon.getFromNameAnyCase(this.name), value);
                                    }
                                    this.form = tempForm;
                                    break;
                                }
                                case "ball": 
                                case "ba": 
                                case "pokeball": {
                                    for (EnumPokeballs pokeball : EnumPokeballs.values()) {
                                        if (!pokeball.name().toLowerCase().contains(value.toLowerCase())) continue;
                                        this.ball = pokeball.getIndex();
                                    }
                                    this.ball = EnumPokeballs.getFromIndex(Integer.parseInt(value)).getIndex();
                                    break;
                                }
                                case "special": 
                                case "sp": {
                                    int tempSpecial = -1;
                                    try {
                                        tempSpecial = Integer.parseInt(value);
                                    }
                                    catch (Exception exc) {
                                        tempSpecial = EnumSpecialTexture.fromName((String)value).id;
                                    }
                                    this.specialTexture = tempSpecial;
                                }
                            }
                            continue;
                        }
                        this.shiny = false;
                        continue;
                    }
                    this.shiny = true;
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException | NullPointerException | NumberFormatException runtimeException) {
                    // empty catch block
                }
            }
        }
    }

    public static PokemonSpec from(String ... args) {
        return new PokemonSpec(args);
    }

    public PokemonSpec copy() {
        PokemonSpec copy = new PokemonSpec(new String[0]);
        try {
            for (Field field : this.getClass().getFields()) {
                field.set(copy, field.get(this));
            }
        }
        catch (Exception var6) {
            var6.printStackTrace();
        }
        return copy;
    }

    public boolean matches(NBTTagCompound nbt) {
        return !(this.name != null && !nbt.func_74779_i("Name").equals(this.name) || this.level != null && nbt.func_74762_e("Level") != this.level.intValue() || this.gender != null && nbt.func_74765_d("Gender") != this.gender.intValue() || this.growth != null && nbt.func_74765_d("Growth") != this.growth.intValue() || this.nature != null && nbt.func_74765_d("Nature") != this.nature.intValue() || this.ability != null && !nbt.func_74779_i("Ability").equals(this.ability) || this.boss != null && nbt.func_74765_d("BossMode") != this.boss.intValue() || this.shiny != null && nbt.func_74767_n("IsShiny") != this.shiny.booleanValue() || this.form != null && nbt.func_74765_d("Variant") != this.form.intValue() || this.ball != null && nbt.func_74762_e("CaughtBall") != this.ball.intValue());
    }

    public boolean matches(EntityPixelmon pokemon) {
        return !(this.name != null && !pokemon.getPokemonName().equals(this.name) || this.level != null && pokemon.getLvl().getLevel() != this.level.intValue() || this.gender != null && pokemon.getGender().ordinal() != this.gender.intValue() || this.growth != null && pokemon.getGrowth().index != this.growth || this.nature != null && pokemon.getNature().index != this.nature || this.ability != null && !pokemon.getAbility().getName().equals(this.ability) || this.boss != null && pokemon.getBossMode().index != this.boss || this.shiny != null && pokemon.getIsShiny() != this.shiny.booleanValue() || this.form != null && pokemon.getForm() != this.form.intValue() || this.ball != null && pokemon.caughtBall.getIndex() != this.ball.intValue());
    }

    public EntityPixelmon create(World world) {
        if (this.name == null) {
            return null;
        }
        EnumPokemon species = EnumPokemon.getFromNameAnyCase(this.name);
        if (species == null) {
            System.out.println("ERROR CREATING POKEMON : " + this.name);
            return null;
        }
        EntityPixelmon pokemon = new EntityPixelmon(world);
        if (this.form != null) {
            pokemon.setForm(this.form, false);
        } else if (species.getNumForms(false) > 1) {
            ModelBase noFormModel;
            boolean setForm = false;
            for (IEnumForm form : EnumPokemon.formList.get((Object)species)) {
                if (!form.isDefaultForm()) continue;
                pokemon.setForm(form.getForm(), false);
                setForm = true;
            }
            if (!setForm && (noFormModel = PixelmonModelRegistry.getModel(pokemon.getSpecies(), EnumForms.NoForm)) != null) {
                pokemon.setForm(EnumForms.NoForm.getForm(), false);
                setForm = true;
            }
            if (!setForm && pokemon.getForm() == -1) {
                pokemon.setForm(EntityPixelmon.getRandomForm(species), false);
            }
        }
        if (this.gender != null) {
            pokemon.setGender(Gender.getGender(this.gender.shortValue()));
        }
        pokemon.init(this.name);
        this.apply(pokemon);
        return pokemon;
    }

    public void apply(NBTTagCompound nbt) {
        if (this.level != null) {
            nbt.func_74768_a("Level", this.level.intValue());
        }
        if (this.gender != null) {
            nbt.func_74777_a("Gender", this.gender.shortValue());
        }
        if (this.growth != null) {
            nbt.func_74777_a("Growth", this.growth.shortValue());
        }
        if (this.nature != null) {
            nbt.func_74777_a("Nature", this.nature.shortValue());
        }
        if (this.ability != null) {
            nbt.func_74778_a("Ability", this.ability);
        }
        if (this.boss != null) {
            nbt.func_74777_a("BossMode", this.boss.shortValue());
        }
        if (this.shiny != null) {
            nbt.func_74757_a("IsShiny", this.shiny.booleanValue());
        }
        if (this.form != null) {
            nbt.func_74777_a("Variant", this.form.shortValue());
        }
        if (this.ball != null) {
            nbt.func_74768_a("CaughtBall", this.ball.intValue());
        }
        if (this.specialTexture != -1) {
            nbt.func_74777_a("specialTexture", (short)this.specialTexture);
        }
    }

    public void apply(EntityPixelmon pokemon) {
        if (this.level != null) {
            pokemon.getLvl().setLevel(this.level);
        }
        if (this.gender != null) {
            pokemon.setGender(Gender.getGender(this.gender.shortValue()));
            if (pokemon.baseStats.malePercent < 0) {
                pokemon.setGender(Gender.None);
            } else if (pokemon.baseStats.malePercent == 0) {
                pokemon.setGender(Gender.Female);
            } else if (pokemon.baseStats.malePercent == 100) {
                pokemon.setGender(Gender.Male);
            } else if (pokemon.baseStats.malePercent > 0 && pokemon.getGender() == Gender.None) {
                pokemon.chooseRandomGender();
            }
        }
        if (this.growth != null) {
            pokemon.setGrowth(EnumGrowth.getGrowthFromIndex(this.growth));
        }
        if (this.nature != null) {
            pokemon.setNature(EnumNature.getNatureFromIndex(this.nature));
        }
        if (this.form != null) {
            pokemon.setForm(this.form);
        }
        if (this.ability != null) {
            pokemon.setAbility(this.ability);
            pokemon.giveAbilitySlot();
        }
        if (this.boss != null) {
            pokemon.setBoss(EnumBossMode.getMode(this.boss));
        }
        if (this.shiny != null) {
            pokemon.setIsShiny(this.shiny);
        }
        if (this.ball != null) {
            pokemon.caughtBall = EnumPokeballs.getFromIndex(this.ball);
        }
        if (this.specialTexture != -1) {
            pokemon.setSpecialTexture(this.specialTexture);
        }
        pokemon.update(EnumUpdateType.Stats, EnumUpdateType.Texture);
    }
}

