/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.controller;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.PixelmonMethods;
import com.pixelmonmod.pixelmon.RandomHelper;
import com.pixelmonmod.pixelmon.api.events.BattleStartedEvent;
import com.pixelmonmod.pixelmon.api.events.BeatWildPixelmonEvent;
import com.pixelmonmod.pixelmon.api.events.PlayerBattleEndedAbnormalEvent;
import com.pixelmonmod.pixelmon.api.events.PlayerBattleEndedEvent;
import com.pixelmonmod.pixelmon.api.events.SpectateEvent;
import com.pixelmonmod.pixelmon.api.events.battles.BattleEndEvent;
import com.pixelmonmod.pixelmon.battles.BattleRegistry;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.controller.BattleStage;
import com.pixelmonmod.pixelmon.battles.controller.CalcPriority;
import com.pixelmonmod.pixelmon.battles.controller.Experience;
import com.pixelmonmod.pixelmon.battles.controller.GlobalStatusController;
import com.pixelmonmod.pixelmon.battles.controller.log.BattleLog;
import com.pixelmonmod.pixelmon.battles.controller.log.FleeAction;
import com.pixelmonmod.pixelmon.battles.controller.participants.BattleParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.ParticipantType;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.controller.participants.PlayerParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.Spectator;
import com.pixelmonmod.pixelmon.battles.controller.participants.WildPixelmonParticipant;
import com.pixelmonmod.pixelmon.battles.rules.BattleRules;
import com.pixelmonmod.pixelmon.battles.status.GlobalStatusBase;
import com.pixelmonmod.pixelmon.battles.status.StatusBase;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import com.pixelmonmod.pixelmon.comm.EnumUpdateType;
import com.pixelmonmod.pixelmon.comm.packetHandlers.SwitchCamera;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.EndSpectate;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.FailFleeSwitch;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.FormBattleUpdate;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.gui.SwitchOutPacket;
import com.pixelmonmod.pixelmon.config.EnumForceBattleResult;
import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import com.pixelmonmod.pixelmon.entities.pixelmon.Entity1Base;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.entities.pixelmon.abilities.AbilityBase;
import com.pixelmonmod.pixelmon.entities.pixelmon.abilities.Pickup;
import com.pixelmonmod.pixelmon.entities.pixelmon.abilities.RunAway;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.links.PokemonLink;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.links.WrapperLink;
import com.pixelmonmod.pixelmon.enums.EnumPokemon;
import com.pixelmonmod.pixelmon.enums.battle.BattleResults;
import com.pixelmonmod.pixelmon.enums.battle.EnumBattleEndCause;
import com.pixelmonmod.pixelmon.enums.battle.EnumBattleType;
import com.pixelmonmod.pixelmon.enums.heldItems.EnumHeldItems;
import com.pixelmonmod.pixelmon.items.ItemPokeball;
import com.pixelmonmod.pixelmon.storage.PlayerStorage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class BattleControllerBase {
    public ArrayList<BattleParticipant> participants = new ArrayList();
    public GlobalStatusController globalStatusController = new GlobalStatusController(this);
    public ArrayList<Spectator> spectators = new ArrayList();
    protected int battleTicks = 0;
    public int battleTurn = -1;
    public int playerNumber = 0;
    public boolean battleEnded = false;
    public int battleIndex;
    public BattleLog battleLog;
    public Attack lastAttack;
    public int numFainted;
    public BattleRules rules;
    @Deprecated
    public EnumBattleType battleType;
    public boolean simulateMode = false;
    public boolean sendMessages = true;
    public boolean wasFishing = false;
    private boolean calculatedTurnOrder = false;
    private List<PixelmonWrapper> switchingOut = new ArrayList<PixelmonWrapper>();
    private static final int TICK_TOP = 20;
    private Set<PixelmonWrapper> checkEvolve = new HashSet<PixelmonWrapper>();
    private boolean init = false;
    private BattleStage stage = BattleStage.PICKACTION;
    public int turn = 0;
    public ArrayList<PixelmonWrapper> turnList = new ArrayList();
    boolean paused = false;

    public BattleControllerBase(BattleParticipant participant1, BattleParticipant participant2) {
        this(participant1, participant2, EnumBattleType.Single);
    }

    public BattleControllerBase(BattleParticipant participant1, BattleParticipant participant2, EnumBattleType battleType) {
        this(participant1, participant2, new BattleRules(battleType));
    }

    public BattleControllerBase(BattleParticipant participant1, BattleParticipant participant2, BattleRules rules) {
        this(participant1.getParticipantList(), participant2.getParticipantList(), rules);
    }

    public BattleControllerBase(BattleParticipant[] team1, BattleParticipant[] team2) {
        this(team1, team2, EnumBattleType.Single);
    }

    public BattleControllerBase(BattleParticipant[] team1, BattleParticipant[] team2, EnumBattleType battleType) {
        this(team1, team2, new BattleRules(battleType));
    }

    public BattleControllerBase(BattleParticipant[] team1, BattleParticipant[] team2, BattleRules rules) {
        for (BattleParticipant p : team1) {
            p.team = 0;
            this.participants.add(p);
        }
        for (BattleParticipant p : team2) {
            p.team = 1;
            this.participants.add(p);
        }
        for (BattleParticipant p : this.participants) {
            PlayerStorage storage = p.getStorage();
            if (storage == null || !storage.isEvolving(p.getWorld())) continue;
            return;
        }
        BattleStartedEvent battleStartedEvent = new BattleStartedEvent(this, team1, team2);
        Pixelmon.EVENT_BUS.post((Event)battleStartedEvent);
        if (battleStartedEvent.isCanceled()) {
            return;
        }
        BattleRegistry.registerBattle(this);
        rules.validateRules();
        this.rules = rules;
        this.battleType = this.rules.battleType;
        this.battleLog = new BattleLog(this);
    }

    protected void initBattle() throws Exception {
        for (BattleParticipant p : this.participants) {
            if (p.checkPokemon()) continue;
            throw new Exception("Battle could not start!");
        }
        for (BattleParticipant p : this.participants) {
            p.startBattle(this);
        }
        this.modifyStats();
        List<PixelmonWrapper> turnOrder = this.getDefaultTurnOrder();
        for (PixelmonWrapper pw : turnOrder) {
            pw.getBattleAbility().beforeSwitch(pw);
        }
        for (BattleParticipant p : this.participants) {
            p.updateOtherPokemon();
            for (PixelmonWrapper pw : p.controlledPokemon) {
                pw.addAttackers();
            }
        }
        for (BattleParticipant p : this.participants) {
            if (!(p instanceof PlayerParticipant)) continue;
            ((PlayerParticipant)p).openGui();
            ++this.playerNumber;
        }
        this.battleTurn = 0;
        for (PixelmonWrapper pw : turnOrder) {
            pw.afterSwitch();
        }
        this.init = true;
    }

    public void update() {
        block33: {
            if (this.battleEnded) {
                return;
            }
            try {
                if (!this.init) {
                    try {
                        this.initBattle();
                    }
                    catch (Exception e) {
                        BattleRegistry.deRegisterBattle(this);
                        e.printStackTrace();
                        this.init = false;
                        this.endBattleWithoutXP();
                        return;
                    }
                }
                this.onUpdate();
                if (this.isEvolving() || this.isWaiting() || this.paused || this.simulateMode || this.participants.size() < 2) {
                    return;
                }
                if (this.battleTicks++ <= 20) break block33;
                if (this.stage == BattleStage.PICKACTION) {
                    for (BattleParticipant p : this.participants) {
                        p.clearTurnVariables();
                        p.selectAction();
                    }
                    this.stage = BattleStage.DOACTION;
                    this.turn = 0;
                } else if (this.stage == BattleStage.DOACTION) {
                    this.modifyStats();
                    if (this.turn == 0 && !this.calculatedTurnOrder) {
                        try {
                            CalcPriority.checkMoveSpeed(this);
                            this.calculatedTurnOrder = true;
                        }
                        catch (Exception exc) {
                            this.battleLog.onCrash(exc, "Problem checking move speed.");
                        }
                    }
                    if (this.turn < this.turnList.size()) {
                        this.modifyStatsCancellable(this.turnList.get(this.turn));
                    }
                    for (BattleParticipant p : this.participants) {
                        for (PixelmonWrapper poke : p.controlledPokemon) {
                            if (poke.pokemon.isLoaded(true)) continue;
                            poke.pokemon.catchInPokeball();
                            if (this.getPlayers().isEmpty()) {
                                this.endBattleWithoutXP();
                                return;
                            }
                            poke.pokemon.field_70170_p.func_175681_c(new ArrayList<EntityPixelmon>(Arrays.asList(poke.pokemon)));
                            poke.pokemon.releaseFromPokeball();
                            poke.pokemon.field_70172_ad = 0;
                        }
                    }
                    boolean endTurn = false;
                    int numTurns = this.turnList.size();
                    if (this.turn < numTurns) {
                        this.participants.stream().filter(bp -> bp.getType() == ParticipantType.Player).forEach(bp -> {
                            bp.wait = true;
                        });
                        PixelmonWrapper currentPokemon = this.turnList.get(this.turn);
                        if (!this.simulateMode) {
                            boolean hasEvolved = false;
                            if (currentPokemon.priority < 6.0f) {
                                for (PixelmonWrapper pw : this.getDefaultTurnOrder()) {
                                    if (!pw.willEvolve) continue;
                                    hasEvolved = pw.megaEvolve() || hasEvolved;
                                }
                            } else if (currentPokemon.attack != null && currentPokemon.willEvolve) {
                                hasEvolved = currentPokemon.megaEvolve();
                            }
                            if (hasEvolved) {
                                return;
                            }
                        }
                        this.takeTurn(currentPokemon);
                        numTurns = this.turnList.size();
                        ++this.turn;
                        if (this.turn >= numTurns) {
                            endTurn = true;
                            for (BattleParticipant p : this.participants) {
                                for (PixelmonWrapper pw : p.controlledPokemon) {
                                    if (pw.newPokemonID != null && pw.isFainted()) {
                                        this.takeTurn(pw);
                                        continue;
                                    }
                                    if (!pw.nextSwitchIsMove) continue;
                                    endTurn = false;
                                }
                            }
                        }
                    } else {
                        endTurn = true;
                    }
                    this.calculatedTurnOrder = false;
                    if (endTurn) {
                        this.applyRepeatedEffects();
                        this.endTurn();
                    }
                    this.checkPokemon();
                    if (endTurn) {
                        this.checkFaint();
                    }
                }
                this.battleTicks = 0;
            }
            catch (Exception e) {
                if (this.battleLog != null) {
                    this.battleLog.onCrash(e, "Caught error in battle. Continuing...");
                }
                if (!PixelmonConfig.printErrors) break block33;
                Pixelmon.LOGGER.info("Caught error in battle. Continuing...");
                e.printStackTrace();
            }
        }
    }

    private boolean isEvolving() {
        for (BattleParticipant p : this.participants) {
            for (PixelmonWrapper pw : p.controlledPokemon) {
                if (pw.evolution == null) continue;
                if (pw.evolution.isEnded()) {
                    pw.evolution = null;
                    p.wait = false;
                    pw.wait = false;
                    String path = "pixelmon.battletext.";
                    path = pw.pokemon.getSpecies().equals((Object)EnumPokemon.Greninja) ? path + "ashgreninja.evolve" : path + "megaevolve";
                    this.sendToAll(path, pw.getNickname(), Entity1Base.getLocalizedName(pw.getPokemonName()));
                    pw.getBattleAbility().applySwitchInEffect(pw);
                    continue;
                }
                return true;
            }
        }
        return false;
    }

    public void modifyStats() {
        for (BattleParticipant p : this.participants) {
            for (PixelmonWrapper pw : p.controlledPokemon) {
                int[] stats = pw.getBattleStats().getBaseBattleStats();
                for (int i = 0; i < pw.getStatusSize(); ++i) {
                    stats = pw.getStatus(i).modifyStats(pw, stats);
                }
                stats = pw.getBattleAbility().modifyStats(pw, stats);
                for (PixelmonWrapper teammate : this.getTeamPokemon(pw)) {
                    stats = teammate.getBattleAbility().modifyStatsTeammate(pw, stats);
                }
                stats = pw.getUsableHeldItem().modifyStats(pw, stats);
                for (GlobalStatusBase gsb : this.globalStatusController.getGlobalStatuses()) {
                    stats = gsb.modifyStats(pw, stats);
                }
                pw.getBattleStats().setStatsForTurn(stats);
            }
        }
    }

    public void modifyStatsCancellable(PixelmonWrapper attacker) {
        for (BattleParticipant p : this.participants) {
            for (PixelmonWrapper pw : p.controlledPokemon) {
                int[] stats = pw.getBattleStats().getBattleStats();
                if (!AbilityBase.ignoreAbility(attacker, pw) || !attacker.targets.contains(pw)) {
                    stats = pw.getBattleAbility().modifyStatsCancellable(pw, stats);
                    for (PixelmonWrapper teammate : this.getTeamPokemon(pw)) {
                        stats = teammate.getBattleAbility().modifyStatsCancellableTeammate(pw, stats);
                    }
                }
                for (int i = 0; i < pw.getStatusSize(); ++i) {
                    StatusBase status = pw.getStatus(i);
                    if (status.ignoreStatus(attacker, pw)) continue;
                    stats = status.modifyStatsCancellable(pw, stats);
                }
                pw.getBattleStats().setStatsForTurn(stats);
            }
        }
    }

    public void participantReady(PlayerParticipant p) {
        p.wait = false;
    }

    public void setAllReady() {
        for (PlayerParticipant player : this.getPlayers()) {
            this.participantReady(player);
        }
    }

    private void applyRepeatedEffects() {
        boolean teamAble = false;
        boolean opponentAble = false;
        BattleParticipant participant = this.participants.get(0);
        for (PixelmonWrapper pw : this.getTeamPokemon(participant)) {
            if (!pw.isAlive()) continue;
            teamAble = true;
            break;
        }
        if (!teamAble) {
            for (BattleParticipant p : this.getTeam(this.participants.get(0))) {
                if (p.countAblePokemon() <= 0) continue;
                teamAble = true;
                break;
            }
        }
        for (PixelmonWrapper pw : this.getOpponentPokemon(participant)) {
            if (!pw.isAlive()) continue;
            opponentAble = true;
            break;
        }
        if (!opponentAble) {
            for (BattleParticipant p : this.getOpponents(this.participants.get(0))) {
                if (p.countAblePokemon() <= 0) continue;
                opponentAble = true;
                break;
            }
        }
        if (teamAble && opponentAble) {
            for (GlobalStatusBase gsb : this.globalStatusController.getGlobalStatuses()) {
                gsb.applyRepeatedEffect(this.globalStatusController);
            }
            for (PixelmonWrapper pw : this.getDefaultTurnOrder()) {
                pw.turnTick();
            }
        }
    }

    private void endTurn() {
        this.stage = BattleStage.PICKACTION;
        for (BattleParticipant p : this.participants) {
            p.faintedLastTurn = false;
        }
        this.battleLog.turnTick();
        ++this.battleTurn;
    }

    public void checkReviveSendOut(BattleParticipant p) {
        if (this.rules.battleType.numPokemon > 1 && p != null && p.getType() == ParticipantType.Player && this.getTeam(p).size() == 1 && p.controlledPokemon.size() < this.rules.battleType.numPokemon && p.countAblePokemon() > p.controlledPokemon.size()) {
            PlayerParticipant player = (PlayerParticipant)p;
            ArrayList<StatusBase> wholeTeamStatuses = new ArrayList<StatusBase>();
            Iterator<PixelmonWrapper> iterator = p.controlledPokemon.iterator();
            if (iterator.hasNext()) {
                PixelmonWrapper pw = iterator.next();
                wholeTeamStatuses = new ArrayList();
                for (StatusBase statusBase : pw.getStatuses()) {
                    if (!statusBase.isWholeTeamStatus()) continue;
                    wholeTeamStatuses.add(statusBase.copy());
                }
            }
            int oldPosition = 0;
            int newPosition = 0;
            do {
                oldPosition = newPosition;
                for (PixelmonWrapper pixelmonWrapper : p.controlledPokemon) {
                    if (newPosition != pixelmonWrapper.battlePosition) continue;
                    ++newPosition;
                }
            } while (oldPosition != newPosition);
            PixelmonWrapper revived = null;
            for (PixelmonWrapper pw : player.allPokemon) {
                if (!pw.isAlive() || pw.pokemon != null) continue;
                EntityPixelmon revivedPokemon = player.storage.sendOut(pw.getPokemonID(), player.getWorld());
                revivedPokemon.func_70606_j(pw.getHealth());
                pw.update(EnumUpdateType.HP);
                revivedPokemon.battleController = this;
                revived = pw;
                revived.pokemon = revivedPokemon;
                break;
            }
            if (revived == null) {
                return;
            }
            revived.battlePosition = newPosition;
            for (StatusBase status : wholeTeamStatuses) {
                revived.addStatus(status, revived);
            }
            player.controlledPokemon.add(newPosition, revived);
            revived.bc = player.bc;
            PlayerStorage playerStorage = player.getStorage();
            if (playerStorage == null) {
                this.endBattleWithoutXP();
                return;
            }
            if (!playerStorage.isInWorld(revived.getPokemonID())) {
                revived.pokemon.func_70012_b(player.player.field_70165_t, player.player.field_70163_u, player.player.field_70161_v, player.player.field_70177_z, 0.0f);
                revived.pokemon.releaseFromPokeball();
            }
            if (!AbilityBase.ignoreAbility(revived)) {
                revived.getBattleAbility().beforeSwitch(revived);
            }
            ChatHandler.sendBattleMessage((Entity)player.player, "playerparticipant.go", revived.getNickname());
            this.sendToOthers("battlecontroller.sendout", player, player.player.func_145748_c_().func_150260_c(), revived.getNickname());
            for (BattleParticipant p2 : this.participants) {
                p2.updateOtherPokemon();
            }
            revived.afterSwitch();
            revived.addAttackers();
            this.sendSwitchPacket(new int[]{-1, -1}, revived);
        }
    }

    void checkFaint() {
        ArrayList<PixelmonWrapper> fainted = new ArrayList<PixelmonWrapper>();
        for (BattleParticipant p : this.participants) {
            ArrayList<PixelmonWrapper> toRemove = new ArrayList<PixelmonWrapper>();
            for (PixelmonWrapper pw : p.controlledPokemon) {
                if (!pw.isFainted() || pw.isSwitching) continue;
                if (pw.removePrimaryStatus() != null) {
                    pw.pokemon.sendStatusPacket(-1);
                }
                pw.update(EnumUpdateType.Status);
                p.updatePokemon(pw);
                if (p.addSwitchingOut(pw)) {
                    fainted.add(pw);
                    continue;
                }
                toRemove.add(pw);
            }
            for (PixelmonWrapper pw : toRemove) {
                pw.isSwitching = false;
                pw.wait = false;
                p.controlledPokemon.remove(pw);
                this.updateRemovedPokemon(pw);
            }
        }
        this.switchingOut.addAll(fainted);
        for (PixelmonWrapper pw : fainted) {
            BattleParticipant p = pw.getParticipant();
            p.faintedLastTurn = true;
            pw.willTryFlee = false;
            p.wait = true;
            p.getNextPokemon(pw.battlePosition);
        }
    }

    private void onUpdate() {
        this.participants.forEach(BattleParticipant::tick);
        if (this.isPvP()) {
            this.participants.stream().filter(p -> ((PlayerParticipant)p).player == null || !((PlayerParticipant)p).player.func_70089_S()).forEach(p -> this.endBattle(EnumBattleEndCause.FORCE));
        } else {
            this.participants.stream().filter(p -> p.getType() == ParticipantType.Player).filter(p -> ((PlayerParticipant)p).player == null || ((PlayerParticipant)p).player.field_70128_L).forEach(p -> this.endBattle(EnumBattleEndCause.FORCE));
        }
    }

    public HashMap<BattleParticipant, BattleResults> endBattle(EnumBattleEndCause cause) {
        return this.endBattle(cause, new HashMap<BattleParticipant, BattleResults>());
    }

    public HashMap<BattleParticipant, BattleResults> endBattle(EnumBattleEndCause cause, HashMap<BattleParticipant, BattleResults> results) {
        if (results == null) {
            results = new HashMap();
        }
        boolean abnormal = false;
        this.battleEnded = true;
        this.globalStatusController.endBattle();
        for (BattleParticipant p : this.participants) {
            for (PixelmonWrapper pw : p.controlledPokemon) {
                pw.getBattleAbility().applyEndOfBattleEffect(pw);
                pw.resetOnSwitch();
                for (StatusBase statusBase : pw.getStatuses()) {
                    statusBase.applyEndOfBattleEffect(pw);
                }
            }
            p.endBattle();
            if (cause == EnumBattleEndCause.FLEE) {
                results.put(p, BattleResults.FLEE);
                if (p instanceof PlayerParticipant) {
                    Pixelmon.EVENT_BUS.post((Event)new PlayerBattleEndedEvent(((PlayerParticipant)p).player, this, BattleResults.FLEE));
                }
            } else if ((cause != EnumBattleEndCause.FORCE || PixelmonConfig.forceEndBattleResult == EnumForceBattleResult.WINNER) && this.init && cause != EnumBattleEndCause.FORFEIT) {
                BattleResults result = BattleResults.DRAW;
                int allyCount = 0;
                int opponentCount = 0;
                for (BattleParticipant teamp : this.getTeam(p)) {
                    allyCount += teamp.countAblePokemon();
                }
                for (BattleParticipant enemyp : this.getOpponents(p)) {
                    opponentCount += enemyp.countAblePokemon();
                }
                if (allyCount > opponentCount) {
                    result = BattleResults.VICTORY;
                } else if (opponentCount > allyCount) {
                    result = BattleResults.DEFEAT;
                } else {
                    float f = 0.0f;
                    float opponentPercent = 0.0f;
                    int allyParticipants = 0;
                    int opponentParticipants = 0;
                    for (BattleParticipant teamp : this.getTeam(p)) {
                        f += teamp.countHealthPercent();
                        ++allyParticipants;
                    }
                    for (BattleParticipant enemyp : this.getOpponents(p)) {
                        opponentPercent += enemyp.countHealthPercent();
                        ++opponentParticipants;
                    }
                    if (allyParticipants == 0) {
                        allyParticipants = 1;
                    }
                    if (opponentParticipants == 0) {
                        opponentParticipants = 1;
                    }
                    result = (f /= (float)allyParticipants) > (opponentPercent /= (float)opponentParticipants) ? BattleResults.VICTORY : (opponentPercent > f ? BattleResults.DEFEAT : BattleResults.DRAW);
                }
                results.put(p, result);
            } else if (cause == EnumBattleEndCause.FORCE) {
                if (PixelmonConfig.forceEndBattleResult == EnumForceBattleResult.DRAW) {
                    results.put(p, BattleResults.DRAW);
                } else {
                    if (PixelmonConfig.forceEndBattleResult == EnumForceBattleResult.ABNORMAL) {
                        if (p instanceof PlayerParticipant) {
                            Pixelmon.EVENT_BUS.post((Event)new PlayerBattleEndedAbnormalEvent(((PlayerParticipant)p).player, this));
                        }
                        abnormal = true;
                    }
                    results.put(p, BattleResults.DRAW);
                }
            }
            if (p instanceof PlayerParticipant) {
                Pixelmon.EVENT_BUS.post((Event)new PlayerBattleEndedEvent(((PlayerParticipant)p).player, this, results.get(p)));
                if (results.get(p) != BattleResults.VICTORY || cause != EnumBattleEndCause.NORMAL) continue;
                Pickup.pickupItem((PlayerParticipant)p);
                continue;
            }
            if (!(p instanceof WildPixelmonParticipant)) continue;
            this.resetAggression(p);
        }
        this.spectators.forEach(spectator -> spectator.sendMessage(new EndSpectate()));
        if (this.playerNumber == 0) {
            BattleRegistry.deRegisterBattle(this);
        }
        this.checkEvolution();
        BattleEndEvent event = new BattleEndEvent(this, cause, abnormal, results);
        Pixelmon.EVENT_BUS.post((Event)event);
        return results;
    }

    @Deprecated
    public void endBattleWithoutXP(HashMap<BattleParticipant, BattleResults> results) {
        this.endBattle(EnumBattleEndCause.FORCE, results);
    }

    @Deprecated
    public void endBattle() {
        this.endBattle(EnumBattleEndCause.NORMAL);
    }

    @Deprecated
    public void endBattleWithoutXP() {
        this.endBattle(EnumBattleEndCause.FORCE);
    }

    private void checkEvolution() {
        for (PixelmonWrapper pw : this.checkEvolve) {
            pw.getLevel().tryEvolution();
        }
    }

    private void resetAggression(BattleParticipant p) {
        EntityLivingBase entity;
        if (p.getType() == ParticipantType.WildPokemon && (entity = p.getEntity()) != null && !entity.field_70128_L) {
            ((EntityPixelmon)entity).aggressionTimer = RandomHelper.getRandomNumberBetween(400, 1000);
        }
    }

    public boolean isPvP() {
        for (BattleParticipant p : this.participants) {
            if (p instanceof PlayerParticipant) continue;
            return false;
        }
        return true;
    }

    public void pauseBattle() {
        this.paused = true;
    }

    public boolean isWaiting() {
        for (BattleParticipant p : this.participants) {
            if (!p.getWait()) continue;
            return true;
        }
        return false;
    }

    public void endPause() {
        this.paused = false;
    }

    private void takeTurn(PixelmonWrapper p) {
        if (this.tryFlee(p)) {
            return;
        }
        for (BattleParticipant part : this.participants) {
            if (part.bc != null) continue;
            this.endBattle();
            return;
        }
        p.takeTurn();
    }

    public boolean tryFlee(PixelmonWrapper p) {
        for (int i = 0; i < this.turn; ++i) {
            PixelmonWrapper current = this.turnList.get(i);
            if (!current.willTryFlee || current.getParticipant() != p.getParticipant()) continue;
            return false;
        }
        if (p.willTryFlee) {
            this.forfeitOrFlee(p);
            p.priority = 6.0f;
            return true;
        }
        return false;
    }

    private void forfeitOrFlee(PixelmonWrapper p) {
        boolean isForfeit = false;
        for (BattleParticipant participant : this.getOpponents(p.getParticipant())) {
            if (participant.getType() == ParticipantType.WildPokemon) continue;
            isForfeit = true;
            break;
        }
        if (isForfeit) {
            this.forfeitBattle(p);
        } else {
            this.calculateEscape(p);
        }
    }

    private void calculateEscape(PixelmonWrapper pixelmonWrapper) {
        PixelmonWrapper opponentPixelmon = pixelmonWrapper.bc.getOpponentPokemon(pixelmonWrapper.getParticipant()).get(0);
        double fleeingSpeed = pixelmonWrapper.getStats().Speed;
        double opponentSpeed = opponentPixelmon.getStats().Speed;
        double escapeAttempts = ++pixelmonWrapper.escapeAttempts;
        double calculatedFleeValue = fleeingSpeed * 128.0 / opponentSpeed + 30.0 * escapeAttempts;
        int random = RandomHelper.getRandomNumberBetween(1, 255);
        if (pixelmonWrapper.getBattleAbility() instanceof RunAway) {
            this.sendToAll("pixelmon.abilities.runaway", pixelmonWrapper.getNickname());
            this.endBattle(EnumBattleEndCause.FLEE);
        } else if (pixelmonWrapper.getHeldItem().getHeldItemType() == EnumHeldItems.smokeBall) {
            this.sendToAll("battlecontroller.escaped", pixelmonWrapper.getNickname());
            this.endBattle(EnumBattleEndCause.FLEE);
        } else if (calculatedFleeValue > 255.0 || (double)random < calculatedFleeValue) {
            this.sendToAll("battlecontroller.escaped", pixelmonWrapper.getNickname());
            BattleParticipant fleeingParticipant = pixelmonWrapper.getParticipant();
            if (fleeingParticipant != null) {
                for (PixelmonWrapper pw : fleeingParticipant.controlledPokemon) {
                    pixelmonWrapper.bc.battleLog.addEvent(new FleeAction(pixelmonWrapper.bc.battleTurn, pixelmonWrapper.bc.getPositionOfPokemon(pw), pixelmonWrapper));
                }
            }
            this.endBattle(EnumBattleEndCause.FLEE);
        } else {
            this.sendToAll("battlecontroller.!escaped", pixelmonWrapper.getNickname());
            BattleParticipant fleeingParticipant = pixelmonWrapper.getParticipant();
            for (PixelmonWrapper pw : fleeingParticipant.controlledPokemon) {
                pixelmonWrapper.bc.battleLog.addEvent(new FleeAction(pixelmonWrapper.bc.battleTurn, pixelmonWrapper.bc.getPositionOfPokemon(pw), pixelmonWrapper));
            }
        }
    }

    private void forfeitBattle(PixelmonWrapper pw) {
        if (this.rules.hasClause("forfeit")) {
            return;
        }
        BattleParticipant forfeitParticipant = pw.getParticipant();
        boolean tie = false;
        ArrayList<BattleParticipant> opponents = this.getOpponents(forfeitParticipant);
        block0: for (BattleParticipant opponent : opponents) {
            for (PixelmonWrapper opponentPokemon : opponent.controlledPokemon) {
                if (!opponentPokemon.willTryFlee) continue;
                tie = true;
                continue block0;
            }
        }
        if (tie) {
            this.sendToAll("battlecontroller.draw", new Object[0]);
        } else if (forfeitParticipant.getType() == ParticipantType.Player) {
            PlayerParticipant forfeitPlayer = (PlayerParticipant)forfeitParticipant;
            ChatHandler.sendBattleMessage((Entity)forfeitPlayer.player, "battlecontroller.forfeitself", new Object[0]);
            this.sendToOthers("battlecontroller.forfeit", forfeitPlayer, forfeitPlayer.getDisplayName());
        }
        HashMap<BattleParticipant, BattleResults> results = new HashMap<BattleParticipant, BattleResults>();
        for (BattleParticipant participant : this.participants) {
            BattleResults result = tie ? BattleResults.DRAW : (opponents.contains(participant) ? BattleResults.VICTORY : BattleResults.DEFEAT);
            results.put(participant, result);
        }
        this.endBattle(EnumBattleEndCause.FORFEIT, results);
    }

    private void checkPokemon() {
        boolean cameraSwitched = false;
        for (BattleParticipant p : this.participants) {
            p.resetMoveTimer();
            if (this.battleEnded || p.isDefeated) continue;
            this.checkReviveSendOut(p);
            ArrayList<PixelmonWrapper> faintedPokemon = new ArrayList<PixelmonWrapper>();
            for (PixelmonWrapper poke : p.controlledPokemon) {
                if (!poke.isFainted()) continue;
                if (p.getType() == ParticipantType.Player) {
                    Pixelmon.network.sendTo((IMessage)new SwitchCamera(), (EntityPlayerMP)p.getEntity());
                    cameraSwitched = true;
                }
                if (poke.newPokemonID == null && this.turnList.contains(poke) && this.turn <= this.turnList.indexOf(poke)) {
                    this.turnList.remove(poke);
                }
                if (!poke.hasAwardedExp) {
                    Experience.awardExp(this.participants, p, poke);
                    poke.hasAwardedExp = true;
                    if (p instanceof WildPixelmonParticipant && this.participants.size() == 2) {
                        this.participants.stream().filter(part -> part != p && part instanceof PlayerParticipant).forEach(part -> {
                            Pixelmon.EVENT_BUS.post((Event)new BeatWildPixelmonEvent(((PlayerParticipant)part).player, (WildPixelmonParticipant)p));
                            ((PlayerParticipant)part).checkPlayerItems();
                        });
                    }
                }
                poke.pokemon.func_70606_j(0.0f);
                poke.pokemon.func_70106_y();
                poke.pokemon.isFainted = true;
                poke.pokemon.catchInPokeball();
                p.updatePokemon(poke);
                if (p.hasMorePokemonReserve()) continue;
                faintedPokemon.add(poke);
                this.updateRemovedPokemon(poke);
            }
            for (PixelmonWrapper pw : faintedPokemon) {
                if (!this.battleEnded) {
                    this.checkDefeated(p, pw);
                }
                if (this.battleEnded) continue;
                p.controlledPokemon.remove(pw);
                pw.pokemon = null;
            }
        }
        if (cameraSwitched) {
            this.spectators.forEach(spectator -> spectator.sendMessage(new SwitchCamera()));
        }
    }

    public void updateRemovedPokemon(PixelmonWrapper poke) {
        int[] id = poke.getPokemonID();
        this.participants.stream().filter(p2 -> p2 instanceof PlayerParticipant).forEach(p2 -> Pixelmon.network.sendTo((IMessage)new SwitchOutPacket(id), ((PlayerParticipant)p2).player));
        this.spectators.forEach(spectator -> spectator.sendMessage(new SwitchOutPacket(id)));
    }

    public boolean isOneAlive(List<PixelmonWrapper> teamPokemon) {
        for (PixelmonWrapper pw : teamPokemon) {
            if (!pw.isAlive()) continue;
            return true;
        }
        return false;
    }

    public void checkDefeated(BattleParticipant p, PixelmonWrapper poke) {
        if (this.isOneAlive(p.controlledPokemon)) {
            p.isDefeated = false;
        } else if (p.countAblePokemon() == 0 && !p.isDefeated) {
            p.isDefeated = true;
            ChatHandler.sendBattleMessage((Entity)p.getEntity(), "battlecontroller.outofpokemon", new Object[0]);
            if (!this.isTeamDefeated(p)) {
                return;
            }
            this.participants.stream().filter(p2 -> this.getOpponents(p).contains(p2)).forEach(p2 -> ChatHandler.sendBattleMessage((Entity)p2.getEntity(), "battlecontroller.win", new Object[0]));
            this.endBattle();
        }
    }

    public void sendToAll(String string, Object ... data) {
        if (this.canSendMessages()) {
            ChatHandler.sendBattleMessage(this.participants, string, data);
        }
    }

    public void sendToAll(TextComponentTranslation message) {
        if (this.canSendMessages()) {
            ChatHandler.sendBattleMessage(this.participants, message);
        }
    }

    public void sendToOthers(String string, BattleParticipant battleParticipant, Object ... data) {
        if (this.canSendMessages()) {
            this.participants.stream().filter(p -> p != battleParticipant).forEach(p -> ChatHandler.sendBattleMessage((Entity)p.getEntity(), string, data));
            this.spectators.forEach(spectator -> ChatHandler.sendBattleMessage((Entity)spectator.getEntity(), string, data));
        }
    }

    public void sendToPlayer(EntityPlayer player, String string, Object ... data) {
        if (this.canSendMessages()) {
            ChatHandler.sendBattleMessage((Entity)player, string, data);
        }
    }

    public void sendToPlayer(EntityPlayer player, TextComponentTranslation message) {
        if (this.canSendMessages()) {
            ChatHandler.sendBattleMessage((Entity)player, message);
        }
    }

    private boolean canSendMessages() {
        return !this.simulateMode && this.sendMessages;
    }

    public void clearHurtTimer() {
        for (BattleParticipant part : this.participants) {
            for (PixelmonWrapper pokemon : part.controlledPokemon) {
                pokemon.pokemon.field_70737_aN = 0;
            }
        }
    }

    public void setUseItem(int[] pokemonID, EntityPlayer user, ItemStack usedStack, int additionalInfo) {
        this.participants.stream().filter(p -> p.getType() == ParticipantType.Player && p.getEntity() == user).forEach(p -> {
            for (PixelmonWrapper pw : p.controlledPokemon) {
                if (PixelmonMethods.isIDSame(pw, pokemonID)) {
                    pw.willUseItemInStack = usedStack;
                    pw.willUseItemInStackInfo = additionalInfo;
                    pw.wait = false;
                    continue;
                }
                if (!(usedStack.func_77973_b() instanceof ItemPokeball)) continue;
                pw.wait = false;
                pw.attack = null;
            }
        });
    }

    public void setUseItem(int[] pokemonID, EntityPlayer player, ItemStack usedStack, int[] targetPokemonID) {
        for (BattleParticipant p : this.participants) {
            PixelmonWrapper pw;
            if (p.getType() != ParticipantType.Player || p.getEntity() != player || (pw = p.getPokemonFromID(pokemonID)) == null) continue;
            pw.willUseItemInStack = usedStack;
            pw.willUseItemPokemon = targetPokemonID;
            pw.willUseItemInStackInfo = -1;
            pw.wait = false;
        }
    }

    public void switchPokemon(int[] switchingPokemonID, int[] newPokemonID, boolean switchInstantly) {
        PixelmonWrapper pw = this.getPokemonFromID(switchingPokemonID);
        if (pw == null) {
            return;
        }
        BattleParticipant p = pw.getParticipant();
        pw.isSwitching = true;
        pw.newPokemonID = newPokemonID;
        boolean stopWait = true;
        boolean checkFaint = false;
        if (pw.isFainted()) {
            p.switchingIn.add(newPokemonID);
            if (!this.switchingOut.isEmpty()) {
                this.switchingOut.remove(pw);
                if (this.switchingOut.isEmpty()) {
                    for (BattleParticipant participant : this.participants) {
                        participant.switchAllFainted();
                        participant.wait = false;
                    }
                    checkFaint = true;
                } else {
                    stopWait = false;
                }
            }
        } else if (switchInstantly) {
            pw.doSwitch();
        }
        if (checkFaint) {
            this.checkPokemon();
            this.checkFaint();
        }
        if (stopWait) {
            pw.wait = false;
            p.wait = false;
        }
    }

    public void setFlee(int[] fleeingID) {
        for (BattleParticipant p : this.participants) {
            PixelmonWrapper pw = p.getPokemonFromID(fleeingID);
            if (pw == null) continue;
            if (pw.isFainted() && p.getType() == ParticipantType.Player) {
                this.forfeitOrFlee(pw);
                if (this.battleEnded) continue;
                Pixelmon.network.sendTo((IMessage)new FailFleeSwitch(), ((PlayerParticipant)p).player);
                continue;
            }
            p.wait = false;
            for (PixelmonWrapper pw2 : p.controlledPokemon) {
                pw2.willTryFlee = true;
                pw2.wait = false;
            }
        }
    }

    public ParticipantType[][] getBattleType(BattleParticipant teammate) {
        int i;
        ParticipantType[][] type = new ParticipantType[2][];
        ArrayList<ParticipantType> team1 = new ArrayList<ParticipantType>();
        ArrayList<ParticipantType> team2 = new ArrayList<ParticipantType>();
        for (BattleParticipant p : this.participants) {
            if (p.team == teammate.team) {
                team1.add(p.getType());
                continue;
            }
            team2.add(p.getType());
        }
        type[0] = new ParticipantType[team1.size()];
        for (i = 0; i < team1.size(); ++i) {
            type[0][i] = (ParticipantType)((Object)team1.get(i));
        }
        type[1] = new ParticipantType[team2.size()];
        for (i = 0; i < team2.size(); ++i) {
            type[1][i] = (ParticipantType)((Object)team2.get(i));
        }
        return type;
    }

    public void updatePokemonHealth(EntityPixelmon entityPixelmon) {
        if (this.init) {
            this.participants.stream().filter(p -> p instanceof PlayerParticipant).forEach(p -> ((PlayerParticipant)p).updatePokemonHealth(entityPixelmon));
        }
    }

    public ArrayList<BattleParticipant> getOpponents(BattleParticipant participant) {
        return (ArrayList)this.participants.stream().filter(p -> p.team != participant.team).collect(Collectors.toList());
    }

    public ArrayList<BattleParticipant> getTeam(BattleParticipant participant) {
        if (participant == null) {
            return new ArrayList<BattleParticipant>();
        }
        return (ArrayList)this.participants.stream().filter(p -> p.team == participant.team).collect(Collectors.toList());
    }

    public ArrayList<PixelmonWrapper> getActivePokemon() {
        ArrayList<PixelmonWrapper> activePokemon = new ArrayList<PixelmonWrapper>();
        for (BattleParticipant p : this.participants) {
            activePokemon.addAll(p.controlledPokemon);
        }
        return activePokemon;
    }

    public ArrayList<PixelmonWrapper> getActiveUnfaintedPokemon() {
        return (ArrayList)this.getActivePokemon().stream().filter(pw -> !pw.isFainted()).collect(Collectors.toList());
    }

    public ArrayList<PixelmonWrapper> getActiveFaintedPokemon() {
        return (ArrayList)this.getActivePokemon().stream().filter(pw -> pw.isFainted()).collect(Collectors.toList());
    }

    public ArrayList<PixelmonWrapper> getAdjacentPokemon(PixelmonWrapper pokemon) {
        return (ArrayList)this.getActiveUnfaintedPokemon().stream().filter(pw -> Math.abs(pw.battlePosition - pokemon.battlePosition) <= 1 && pw != pokemon).collect(Collectors.toList());
    }

    public ArrayList<PixelmonWrapper> getTeamPokemon(BattleParticipant participant) {
        ArrayList<BattleParticipant> team = this.getTeam(participant);
        ArrayList<PixelmonWrapper> teamPokemon = new ArrayList<PixelmonWrapper>();
        for (BattleParticipant p : team) {
            for (PixelmonWrapper pw : p.controlledPokemon) {
                if (pw == null) continue;
                teamPokemon.add(pw);
            }
        }
        return teamPokemon;
    }

    public ArrayList<PixelmonWrapper> getTeamPokemon(PixelmonWrapper pokemon) {
        return this.getTeamPokemon(pokemon.getParticipant());
    }

    public ArrayList<PixelmonWrapper> getTeamPokemon(EntityPixelmon pokemon) {
        return this.getTeamPokemon(pokemon.getParticipant());
    }

    public ArrayList<PixelmonWrapper> getTeamPokemonExcludeSelf(PixelmonWrapper pokemon) {
        ArrayList<PixelmonWrapper> teamPokemon = this.getTeamPokemon(pokemon);
        teamPokemon.remove(pokemon);
        return teamPokemon;
    }

    public ArrayList<PixelmonWrapper> getOpponentPokemon(BattleParticipant participant) {
        ArrayList<BattleParticipant> opponents = this.getOpponents(participant);
        ArrayList<PixelmonWrapper> opponentPokemon = new ArrayList<PixelmonWrapper>();
        for (BattleParticipant p : opponents) {
            for (PixelmonWrapper pw : p.controlledPokemon) {
                opponentPokemon.add(pw);
            }
        }
        return opponentPokemon;
    }

    public ArrayList<PixelmonWrapper> getOpponentPokemon(PixelmonWrapper pw) {
        return this.getOpponentPokemon(pw.getParticipant());
    }

    public boolean isInBattle(PixelmonWrapper pokemon) {
        for (PixelmonWrapper pw : this.getActivePokemon()) {
            if (pw != pokemon) continue;
            return true;
        }
        return false;
    }

    public BattleParticipant getParticipantForEntity(EntityLivingBase entity) {
        for (BattleParticipant p : this.participants) {
            if (p.getEntity() != entity) continue;
            return p;
        }
        return null;
    }

    public void sendDamagePacket(EntityPixelmon target, int damage) {
        for (BattleParticipant p : this.participants) {
            p.sendDamagePacket(target, damage);
        }
        this.spectators.forEach(spectator -> spectator.sendDamagePacket(target, damage));
    }

    public void sendHealPacket(EntityPixelmon target, int amount) {
        for (BattleParticipant p : this.participants) {
            p.sendHealPacket(target, amount);
        }
        this.spectators.forEach(spectator -> spectator.sendHealPacket(target, amount));
    }

    public PixelmonWrapper getOppositePokemon(PixelmonWrapper pw) {
        int index;
        ArrayList<PixelmonWrapper> oppPokemon = pw.bc.getOpponentPokemon(pw.getParticipant());
        ArrayList<PixelmonWrapper> teamPokemon = pw.bc.getTeamPokemon(pw.getParticipant());
        for (index = teamPokemon.indexOf(pw); index >= oppPokemon.size(); --index) {
        }
        return oppPokemon.get(index);
    }

    public PixelmonWrapper getPokemonAtPosition(int position) {
        ArrayList<PixelmonWrapper> arr = new ArrayList<PixelmonWrapper>();
        for (BattleParticipant bp : this.participants) {
            arr.addAll(bp.controlledPokemon);
        }
        if (position >= arr.size()) {
            return null;
        }
        return (PixelmonWrapper)arr.get(position);
    }

    public int getPositionOfPokemon(PixelmonWrapper poke) {
        ArrayList<PixelmonWrapper> arr = new ArrayList<PixelmonWrapper>();
        for (BattleParticipant bp : this.participants) {
            arr.addAll(bp.controlledPokemon);
        }
        return arr.indexOf(poke);
    }

    public int getPositionOfPokemon(PixelmonWrapper poke, BattleParticipant bp) {
        return bp.controlledPokemon.indexOf(poke);
    }

    public BattleStage getStage() {
        return this.stage;
    }

    public void enableReturnHeldItems(PixelmonWrapper attacker, PixelmonWrapper target) {
        BattleParticipant targetParticipant = target.getParticipant();
        if (!this.simulateMode && !(targetParticipant instanceof WildPixelmonParticipant)) {
            target.enableReturnHeldItem();
            attacker.enableReturnHeldItem();
        }
    }

    public boolean checkValid() {
        if (this.battleEnded) {
            return false;
        }
        ArrayList<PixelmonWrapper> pokemon = new ArrayList<PixelmonWrapper>();
        ArrayList<PixelmonWrapper> activePokemon = this.getActivePokemon();
        if (activePokemon.size() <= 1) {
            return false;
        }
        for (PixelmonWrapper pw : activePokemon) {
            if (pokemon.contains(pw)) {
                this.endBattleWithoutXP();
                return false;
            }
            pokemon.add(pw);
        }
        return true;
    }

    public PlayerParticipant getPlayer(String name) {
        for (BattleParticipant p : this.participants) {
            if (p.getType() != ParticipantType.Player) continue;
            PlayerParticipant player = (PlayerParticipant)p;
            if (!player.player.getDisplayNameString().equals(name)) continue;
            return player;
        }
        return null;
    }

    public PlayerParticipant getPlayer(EntityPlayer player) {
        for (BattleParticipant p : this.participants) {
            if (p.getType() != ParticipantType.Player) continue;
            PlayerParticipant currentPlayer = (PlayerParticipant)p;
            if (player != currentPlayer.player) continue;
            return currentPlayer;
        }
        return null;
    }

    public List<PlayerParticipant> getPlayers() {
        ArrayList<PlayerParticipant> players = new ArrayList<PlayerParticipant>(this.participants.size());
        for (BattleParticipant p : this.participants) {
            if (p.getType() != ParticipantType.Player) continue;
            players.add((PlayerParticipant)p);
        }
        return players;
    }

    public boolean isTeamDefeated(BattleParticipant participant) {
        for (BattleParticipant p2 : this.getTeam(participant)) {
            if (p2.isDefeated) continue;
            return false;
        }
        return true;
    }

    public int getTurnForPokemon(PixelmonWrapper pokemon) {
        for (int i = 0; i < this.turnList.size(); ++i) {
            if (this.turnList.get(i) != pokemon) continue;
            return i;
        }
        return -1;
    }

    public BattleParticipant otherParticipant(BattleParticipant participant) {
        for (BattleParticipant p : this.participants) {
            if (p == participant) continue;
            return p;
        }
        return null;
    }

    public PixelmonWrapper getFirstMover(PixelmonWrapper ... pokemonList) {
        for (PixelmonWrapper turnPokemon : this.turnList) {
            for (PixelmonWrapper pokemon : pokemonList) {
                if (turnPokemon != pokemon) continue;
                return pokemon;
            }
        }
        return null;
    }

    public PixelmonWrapper getFirstMover(ArrayList<PixelmonWrapper> pokemonList) {
        for (PixelmonWrapper turnPokemon : this.turnList) {
            for (PixelmonWrapper pokemon : pokemonList) {
                if (turnPokemon != pokemon) continue;
                return pokemon;
            }
        }
        return null;
    }

    public PixelmonWrapper getLastMover(PixelmonWrapper ... pokemonList) {
        for (int i = this.turnList.size() - 1; i >= 0; --i) {
            PixelmonWrapper turnPokemon = this.turnList.get(i);
            for (PixelmonWrapper pokemon : pokemonList) {
                if (turnPokemon != pokemon) continue;
                return pokemon;
            }
        }
        return null;
    }

    public PixelmonWrapper getLastMover(ArrayList<PixelmonWrapper> pokemonList) {
        for (int i = this.turnList.size() - 1; i >= 0; --i) {
            PixelmonWrapper turnPokemon = this.turnList.get(i);
            for (PixelmonWrapper pokemon : pokemonList) {
                if (turnPokemon != pokemon) continue;
                return pokemon;
            }
        }
        return null;
    }

    public void sendSwitchPacket(int[] oldID, PixelmonWrapper newPokemon) {
        for (BattleParticipant participant : this.participants) {
            if (!(participant instanceof PlayerParticipant)) continue;
            Pixelmon.network.sendTo((IMessage)new SwitchOutPacket(oldID, newPokemon), ((PlayerParticipant)participant).player);
        }
        this.spectators.forEach(spectator -> spectator.sendMessage(new SwitchOutPacket(oldID, newPokemon)));
    }

    public void addSpectator(Spectator spectator) {
        this.spectators.add(spectator);
        BattleRegistry.registerSpectator(spectator, this);
    }

    public void removeSpectator(Spectator spectator) {
        this.spectators.remove(spectator);
        BattleRegistry.unregisterSpectator(spectator);
        Pixelmon.EVENT_BUS.post((Event)new SpectateEvent.StopSpectate(spectator.getEntity(), this));
    }

    public boolean hasSpectator(EntityPlayer player) {
        for (Spectator spectator : this.spectators) {
            if (spectator.getEntity() != player) continue;
            return true;
        }
        return false;
    }

    public boolean removeSpectator(EntityPlayerMP player) {
        for (int i = 0; i < this.spectators.size(); ++i) {
            Spectator spectator = this.spectators.get(i);
            if (spectator.getEntity() != player) continue;
            this.spectators.remove(i);
            BattleRegistry.unregisterSpectator(spectator);
            Pixelmon.EVENT_BUS.post((Event)new SpectateEvent.StopSpectate(player, this));
            return true;
        }
        return false;
    }

    public ArrayList<Spectator> getPlayerSpectators(PlayerParticipant player) {
        ArrayList<Spectator> playerSpectators = new ArrayList<Spectator>(this.spectators.size());
        String playerName = player.player.getDisplayNameString();
        playerSpectators.addAll(this.spectators.stream().filter(spectator -> spectator.watchedName.equals(playerName)).collect(Collectors.toList()));
        return playerSpectators;
    }

    public PixelmonWrapper getPokemonFromID(int[] id) {
        BattleParticipant p;
        PixelmonWrapper pw = null;
        Iterator<BattleParticipant> iterator = this.participants.iterator();
        while (iterator.hasNext() && (pw = (p = iterator.next()).getPokemonFromID(id)) == null) {
        }
        return pw;
    }

    public List<PixelmonWrapper> getDefaultTurnOrder() {
        return CalcPriority.getDefaultTurnOrder(this);
    }

    public void removeFromTurnList(PixelmonWrapper pw) {
        for (int i = this.turn + 1; i < this.turnList.size(); ++i) {
            if (!pw.equals(this.turnList.get(i))) continue;
            this.turnList.remove(i);
            return;
        }
    }

    public boolean isLastMover() {
        return this.turn >= this.turnList.size() - 1;
    }

    public boolean containsParticipantType(Class<? extends BattleParticipant> participantType) {
        for (BattleParticipant bp : this.participants) {
            if (bp.getClass() != participantType) continue;
            return true;
        }
        return false;
    }

    public void updateFormChange(EntityPixelmon pokemon) {
        this.participants.stream().filter(participant -> participant.getType() == ParticipantType.Player).forEach(participant -> Pixelmon.network.sendTo((IMessage)new FormBattleUpdate(pokemon.getPokemonId(), pokemon.getFormIncludeTransformed()), ((PlayerParticipant)participant).player));
        this.spectators.forEach(spectator -> spectator.sendMessage(new FormBattleUpdate(pokemon.getPokemonId(), pokemon.getFormIncludeTransformed())));
    }

    public boolean isLevelingDisabled() {
        if (!PixelmonConfig.allowPVPExperience) {
            boolean allPlayers = true;
            for (BattleParticipant p : this.participants) {
                if (p.getType() == ParticipantType.Player) continue;
                allPlayers = false;
            }
            if (allPlayers) {
                return true;
            }
        }
        if (!PixelmonConfig.allowTrainerExperience) {
            for (BattleParticipant p : this.participants) {
                if (p.getType() != ParticipantType.Trainer) continue;
                return true;
            }
        }
        return this.rules.raiseToCap;
    }

    public void addCheckEvolve(PokemonLink pokemon) {
        if (pokemon instanceof WrapperLink) {
            WrapperLink link = (WrapperLink)pokemon;
            this.checkEvolve.add(link.getPokemon());
        }
    }
}

