/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.rules.teamselection;

import com.pixelmonmod.pixelmon.comm.PixelmonData;
import com.pixelmonmod.pixelmon.entities.npcs.registry.PokemonForm;
import com.pixelmonmod.pixelmon.util.IEncodeable;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;

public class TeamSelectPokemon
implements IEncodeable {
    public PokemonForm pokemon;
    public int specialTexture;
    public int pokeBall;
    public boolean isShiny;
    public boolean isEgg;
    public int eggCycles;

    public TeamSelectPokemon(NBTTagCompound nbt, EntityPlayer player) {
        this.pokemon = new PokemonForm(nbt);
        this.specialTexture = nbt.func_74765_d("specialTexture");
        this.pokeBall = nbt.func_74762_e("CaughtBall");
        this.isShiny = nbt.func_74767_n("IsShiny");
        this.isEgg = nbt.func_74767_n("isEgg");
        this.eggCycles = nbt.func_74762_e("eggCycles");
    }

    public TeamSelectPokemon(PixelmonData data) {
        this.pokemon = new PokemonForm(data.getSpecies(), data.form, data.gender);
        this.specialTexture = data.specialTexture;
        this.pokeBall = data.pokeball.getIndex();
        this.isShiny = data.isShiny;
        this.isEgg = data.isEgg;
        this.eggCycles = data.eggCycles;
    }

    public TeamSelectPokemon(ByteBuf buffer) {
        this.decodeInto(buffer);
    }

    @Override
    public void encodeInto(ByteBuf buffer) {
        this.pokemon.encodeInto(buffer);
        buffer.writeInt(this.specialTexture);
        buffer.writeInt(this.pokeBall);
        buffer.writeBoolean(this.isShiny);
        buffer.writeBoolean(this.isEgg);
        buffer.writeInt(this.eggCycles);
    }

    @Override
    public void decodeInto(ByteBuf buffer) {
        this.pokemon = new PokemonForm(buffer);
        this.specialTexture = buffer.readInt();
        this.pokeBall = buffer.readInt();
        this.isShiny = buffer.readBoolean();
        this.isEgg = buffer.readBoolean();
        this.eggCycles = buffer.readInt();
    }
}

