/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.status;

import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.controller.log.AttackResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.Hail;
import com.pixelmonmod.pixelmon.battles.status.StatusBase;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import com.pixelmonmod.pixelmon.entities.pixelmon.abilities.Infiltrator;

public class AuroraVeil
extends StatusBase {
    int effectTurns = 5;

    public AuroraVeil() {
        super(StatusType.AuroraVeil);
    }

    @Override
    protected void applyEffect(PixelmonWrapper user, PixelmonWrapper target) {
        if (user.targetIndex == 0 || user.bc.simulateMode) {
            if (user.hasStatus(this.type)) {
                if (user == target) {
                    user.bc.sendToAll("pixelmon.effect.alreadyauroraveil", user.getNickname());
                }
                user.attack.moveResult.result = AttackResult.failed;
                return;
            }
            if (user.bc.globalStatusController.getWeatherIgnoreAbility() instanceof Hail) {
                user.attack.moveResult.result = AttackResult.failed;
                return;
            }
            if (user.addTeamStatus(new AuroraVeil(), user)) {
                user.bc.sendToAll("pixelmon.effect.guarded", user.getNickname());
            }
        }
    }

    @Override
    public int modifyDamageIncludeFixed(int damage, PixelmonWrapper user, PixelmonWrapper target, Attack a) {
        if (a.baseAttack.attackCategory != 3 && !a.baseAttack.getMakesContact() && !(target.getBattleAbility() instanceof Infiltrator)) {
            damage = (int)((double)damage * (user.bc.getTeam(user.getParticipant()).size() == 1 ? 0.5 : 0.66666667));
        }
        return super.modifyDamageIncludeFixed(damage, user, target, a);
    }

    @Override
    public void applyRepeatedEffect(PixelmonWrapper pw) {
        int effectTurns;
        this.effectTurns = effectTurns = this.effectTurns - 1;
        if (effectTurns <= 0) {
            pw.bc.sendToAll("pixelmon.status.auroraveiloff", pw.getNickname());
            pw.removeTeamStatus(this);
        }
    }

    @Override
    public boolean isTeamStatus() {
        return true;
    }

    @Override
    public StatusBase copy() {
        AuroraVeil copy = new AuroraVeil();
        copy.effectTurns = this.effectTurns;
        return copy;
    }
}

