/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.status;

import com.pixelmonmod.pixelmon.RandomHelper;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.attacks.DamageTypeEnum;
import com.pixelmonmod.pixelmon.battles.attacks.EffectBase;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic.Thaw;
import com.pixelmonmod.pixelmon.battles.controller.ai.MoveChoice;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.StatusPersist;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import com.pixelmonmod.pixelmon.entities.pixelmon.abilities.Comatose;
import com.pixelmonmod.pixelmon.enums.EnumType;
import java.util.ArrayList;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextComponentTranslation;

public class Freeze
extends StatusPersist {
    public Freeze() {
        super(StatusType.Freeze);
    }

    @Override
    protected void applyEffect(PixelmonWrapper user, PixelmonWrapper target) {
        if (this.checkChance()) {
            Freeze.freeze(user, target);
        }
    }

    public static boolean freeze(PixelmonWrapper user, PixelmonWrapper target) {
        if (target.hasType(EnumType.Ice) || target.getBattleAbility() instanceof Comatose) {
            return false;
        }
        TextComponentTranslation message = ChatHandler.getMessage("pixelmon.effect.frozesolid", target.getNickname());
        return target.addStatus(new Freeze(), user, message);
    }

    @Override
    public boolean canAttackThisTurn(PixelmonWrapper user, Attack a) {
        for (int i = 0; i < a.baseAttack.effects.size(); ++i) {
            EffectBase e = a.baseAttack.effects.get(i);
            if (!(e instanceof Thaw)) continue;
            user.removeStatus(this);
            return true;
        }
        if (RandomHelper.getRandomChance(20)) {
            user.removeStatus(this);
            return true;
        }
        user.bc.sendToAll("pixelmon.status.frozensolid", user.getNickname());
        return false;
    }

    @Override
    public void onDamageReceived(PixelmonWrapper userWrapper, PixelmonWrapper pokemon, Attack a, int damage, DamageTypeEnum damageType) {
        if (damageType == DamageTypeEnum.ATTACK && a != null && (a.baseAttack.attackType == EnumType.Fire || a.isAttack("Scald", "Steam Eruption"))) {
            pokemon.removeStatus(this);
        }
    }

    @Override
    public StatusPersist restoreFromNBT(NBTTagCompound nbt) {
        return new Freeze();
    }

    @Override
    public boolean isImmune(PixelmonWrapper pokemon) {
        return pokemon.hasType(EnumType.Ice);
    }

    @Override
    public String getCureMessage() {
        return "pixelmon.status.breakice";
    }

    @Override
    public String getCureMessageItem() {
        return "pixelmon.status.frozencureitem";
    }

    @Override
    public void weightEffect(PixelmonWrapper pw, MoveChoice userChoice, ArrayList<MoveChoice> userChoices, ArrayList<MoveChoice> bestUserChoices, ArrayList<MoveChoice> opponentChoices, ArrayList<MoveChoice> bestOpponentChoices) {
        float weight = this.getWeightWithChance(100.0f);
        if (userChoice.isMiddleTier() && !userChoice.hitsAlly()) {
            for (PixelmonWrapper target : userChoice.targets) {
                if (!Freeze.freeze(pw, target)) continue;
                userChoice.raiseWeight(weight);
            }
        }
    }
}

