/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.status;

import com.pixelmonmod.pixelmon.battles.controller.ai.MoveChoice;
import com.pixelmonmod.pixelmon.battles.controller.log.AttackResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.StatusBase;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import com.pixelmonmod.pixelmon.entities.pixelmon.abilities.Infiltrator;
import java.util.ArrayList;

public class SafeGuard
extends StatusBase {
    int effectTurns = 5;

    public SafeGuard() {
        super(StatusType.SafeGuard);
    }

    @Override
    protected void applyEffect(PixelmonWrapper user, PixelmonWrapper target) {
        if (user.targetIndex == 0 || user.bc.simulateMode) {
            if (user.hasStatus(this.type)) {
                if (user == target) {
                    user.bc.sendToAll("pixelmon.effect.alreadysafeguard", user.getNickname());
                }
                user.attack.moveResult.result = AttackResult.failed;
                return;
            }
            if (user.addTeamStatus(new SafeGuard(), user)) {
                user.bc.sendToAll("pixelmon.effect.guarded", user.getNickname());
            }
        }
    }

    @Override
    public boolean stopsStatusChange(StatusType t, PixelmonWrapper target, PixelmonWrapper user) {
        if ((t.isPrimaryStatus() || t.isStatus(StatusType.Confusion, StatusType.Yawn)) && !(user.getBattleAbility() instanceof Infiltrator)) {
            if (user != target && user.attack != null && user.attack.baseAttack.attackCategory == 2) {
                target.bc.sendToAll("pixelmon.status.safeguard", target.getNickname());
            }
            return true;
        }
        return false;
    }

    @Override
    public void applyRepeatedEffect(PixelmonWrapper pw) {
        if (--this.effectTurns <= 0) {
            pw.bc.sendToAll("pixelmon.status.safeguardoff", pw.getNickname());
            pw.removeTeamStatus(this);
        }
    }

    @Override
    public boolean isTeamStatus() {
        return true;
    }

    @Override
    public StatusBase copy() {
        SafeGuard copy = new SafeGuard();
        copy.effectTurns = this.effectTurns;
        return copy;
    }

    @Override
    public void weightEffect(PixelmonWrapper pw, MoveChoice userChoice, ArrayList<MoveChoice> userChoices, ArrayList<MoveChoice> bestUserChoices, ArrayList<MoveChoice> opponentChoices, ArrayList<MoveChoice> bestOpponentChoices) {
        for (PixelmonWrapper opponent : pw.getOpponentPokemon()) {
            if (!(opponent.getBattleAbility() instanceof Infiltrator)) continue;
            return;
        }
        userChoice.raiseWeight(15.0f);
    }
}

