/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.blocks.spawning;

import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.events.PixelmonBlockStartingBattleEvent;
import com.pixelmonmod.pixelmon.api.events.PixelmonBlockTriggeredBattleEvent;
import com.pixelmonmod.pixelmon.api.spawning.AbstractSpawner;
import com.pixelmonmod.pixelmon.api.spawning.SpawnAction;
import com.pixelmonmod.pixelmon.api.spawning.SpawnLocation;
import com.pixelmonmod.pixelmon.api.spawning.conditions.LocationType;
import com.pixelmonmod.pixelmon.api.spawning.util.SpatialData;
import com.pixelmonmod.pixelmon.api.world.MutableLocation;
import com.pixelmonmod.pixelmon.battles.BattleRegistry;
import com.pixelmonmod.pixelmon.battles.controller.BattleControllerBase;
import com.pixelmonmod.pixelmon.battles.controller.participants.PlayerParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.WildPixelmonParticipant;
import com.pixelmonmod.pixelmon.blocks.spawning.BlockSpawnArea;
import com.pixelmonmod.pixelmon.blocks.spawning.BlockSpawnData;
import com.pixelmonmod.pixelmon.blocks.spawning.BlockSpawnRegistry;
import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import com.pixelmonmod.pixelmon.config.PixelmonEntityList;
import com.pixelmonmod.pixelmon.config.PixelmonServerConfig;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.entities.pixelmon.externalMoves.Headbutt;
import com.pixelmonmod.pixelmon.entities.pixelmon.externalMoves.RockSmash;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.Level;
import com.pixelmonmod.pixelmon.enums.EnumPokemon;
import com.pixelmonmod.pixelmon.enums.battle.EnumBattleStartTypes;
import com.pixelmonmod.pixelmon.spawning.PixelmonSpawning;
import com.pixelmonmod.pixelmon.spawning.PlayerTrackingSpawner;
import com.pixelmonmod.pixelmon.spawning.spawners.SpawnerLand;
import com.pixelmonmod.pixelmon.storage.PixelmonStorage;
import com.pixelmonmod.pixelmon.storage.PlayerStorage;
import java.util.ArrayList;
import java.util.Optional;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.eventhandler.Event;

public class BlockSpawningHandler {
    private static final BlockSpawningHandler instance = new BlockSpawningHandler();
    private static final Random RNG = new Random();

    public static BlockSpawningHandler getInstance() {
        return instance;
    }

    public void performBattleStartCheck(World world, BlockPos pos, Entity entity, EntityPixelmon entityPixelmon, String areaname, EnumBattleStartTypes startType) {
        EntityPlayerMP playerMP = (EntityPlayerMP)entity;
        if (BattleRegistry.getBattle((EntityPlayer)playerMP) != null) {
            return;
        }
        if (Pixelmon.EVENT_BUS.post((Event)new PixelmonBlockTriggeredBattleEvent(this, world, pos, playerMP, entityPixelmon, startType))) {
            return;
        }
        if (startType == EnumBattleStartTypes.PUGRASSSINGLE || startType == EnumBattleStartTypes.PUGRASSDOUBLE || startType == EnumBattleStartTypes.SEAWEED) {
            if (startType == EnumBattleStartTypes.PUGRASSSINGLE) {
                this.createBattle(world, pos, playerMP, areaname, EnumBattleStartTypes.PUGRASSSINGLE, null);
            } else if (startType == EnumBattleStartTypes.PUGRASSDOUBLE) {
                this.createDoubleBattle(world, pos, playerMP, areaname);
            } else if (startType == EnumBattleStartTypes.SEAWEED) {
                this.createUnderwaterBattle(world, pos, playerMP, areaname);
            }
        } else if (startType == EnumBattleStartTypes.HEADBUTT) {
            if (RNG.nextInt(100) <= 40) {
                return;
            }
            this.createBattle(world, pos, playerMP, areaname, EnumBattleStartTypes.HEADBUTT, entityPixelmon);
        } else if (startType == EnumBattleStartTypes.ROCKSMASH) {
            if (RNG.nextInt(100) <= 20) {
                return;
            }
            this.createBattle(world, pos, playerMP, areaname, EnumBattleStartTypes.ROCKSMASH, entityPixelmon);
        } else if (startType == EnumBattleStartTypes.SWEETSCENT) {
            this.createBattle(world, pos, playerMP, areaname, EnumBattleStartTypes.SWEETSCENT, entityPixelmon);
        }
    }

    private void createBattle(World worldIn, BlockPos pos, EntityPlayerMP player, String areaname, EnumBattleStartTypes startType, EntityPixelmon fightingPokemon) {
        EntityPixelmon pixelmon = null;
        Object spawnData = null;
        Optional<PlayerStorage> optstorage = PixelmonStorage.pokeBallManager.getPlayerStorage(player);
        if (optstorage.isPresent()) {
            PlayerStorage storage = optstorage.get();
            if (storage.getFirstAblePokemon(worldIn) == null) {
                return;
            }
            if (startType == EnumBattleStartTypes.PUGRASSSINGLE) {
                EntityPixelmon startingPixelmon = storage.getFirstAblePokemon(worldIn);
                if (areaname.isEmpty()) {
                    SpawnerLand spawner = new SpawnerLand();
                    String pokemonName = this.getPixelmonNameFromSpawner(worldIn, pos, spawner);
                    if (pokemonName.isEmpty()) {
                        return;
                    }
                    pixelmon = (EntityPixelmon)PixelmonEntityList.createEntityByName(pokemonName, worldIn);
                    pixelmon.func_70012_b(pos.func_177958_n(), (float)pos.func_177956_o() + spawner.getYOffset(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), (EntityLiving)pixelmon), pos.func_177952_p(), worldIn.field_73012_v.nextFloat() * 360.0f, 0.0f);
                } else if (PixelmonSpawning.coordinator != null) {
                    SpawnLocation spawnLocation = new SpawnLocation(new MutableLocation(worldIn, pos), LocationType.getPotentialTypes(worldIn.func_180495_p(player.func_180425_c().func_177982_a(0, -1, 0))), worldIn.func_180495_p(pos).func_177230_c(), null, worldIn.func_180494_b(pos), worldIn.func_175678_i(pos), 6);
                    ArrayList<SpawnLocation> spawnLocations = new ArrayList<SpawnLocation>();
                    spawnLocations.add(spawnLocation);
                    PlayerTrackingSpawner playerTrackingSpawner = new PlayerTrackingSpawner(player.func_110124_au());
                    for (AbstractSpawner spawner : PixelmonSpawning.coordinator.spawners) {
                        if (!(spawner instanceof PlayerTrackingSpawner) || ((PlayerTrackingSpawner)spawner).playerUUID.compareTo(player.func_110124_au()) != 0) continue;
                        playerTrackingSpawner = (PlayerTrackingSpawner)spawner;
                    }
                    ArrayList<SpawnAction<? extends Entity>> possibleSpawns = playerTrackingSpawner.calculateSpawnActions(spawnLocations);
                    if (possibleSpawns.isEmpty()) {
                        return;
                    }
                    SpawnAction<? extends Entity> spawnAction = possibleSpawns.get(0);
                    Entity entity = spawnAction.getOrCreateEntity();
                    if (entity instanceof EntityPixelmon) {
                        pixelmon = (EntityPixelmon)entity;
                    }
                }
                if (!worldIn.field_72995_K) {
                    worldIn.func_72838_d(pixelmon);
                }
                if (PixelmonConfig.scaleGrassBattles && spawnData == null) {
                    int minLvl;
                    int maxLvl = Math.min(storage.getHighestLevel(), PixelmonServerConfig.maxLevel);
                    if (maxLvl - (minLvl = this.getLowestLevel(storage.getList())) > 5) {
                        minLvl = maxLvl - minLvl;
                    }
                    Level level = pixelmon.getLvl();
                    if (minLvl < maxLvl) {
                        int lvl = RNG.nextInt(maxLvl - minLvl) + minLvl;
                        level.setLevel(lvl);
                    } else {
                        level.setLevel(maxLvl);
                    }
                    pixelmon.loadMoveset();
                } else if (spawnData != null) {
                    int minLvl = spawnData.minLvl;
                    int maxLvl = spawnData.maxLvl;
                    if (minLvl < maxLvl) {
                        int lvl = RNG.nextInt(maxLvl - minLvl) + minLvl;
                        pixelmon.getLvl().setLevel(lvl);
                    } else {
                        pixelmon.getLvl().setLevel(maxLvl);
                    }
                    pixelmon.loadMoveset();
                }
                PlayerParticipant playerParticipant = new PlayerParticipant(player, startingPixelmon);
                WildPixelmonParticipant wildPixelmonParticipant2 = new WildPixelmonParticipant(true, pixelmon);
                if (Pixelmon.EVENT_BUS.post((Event)new PixelmonBlockStartingBattleEvent(worldIn, pos, player, startType, fightingPokemon, pixelmon, null))) {
                    return;
                }
                wildPixelmonParticipant2.startedBattle = true;
                BattleControllerBase lvl = new BattleControllerBase(playerParticipant, wildPixelmonParticipant2);
            } else if (startType == EnumBattleStartTypes.HEADBUTT) {
                if (Headbutt.HEADBUTT_SPAWNER != null && PixelmonSpawning.coordinator != null) {
                    SpawnLocation spawnLocation = new SpawnLocation(new MutableLocation(worldIn, pos), LocationType.getPotentialTypes(worldIn.func_180495_p(player.func_180425_c().func_177982_a(0, -1, 0))), worldIn.func_180495_p(pos).func_177230_c(), null, worldIn.func_180494_b(pos), worldIn.func_175678_i(pos), 6);
                    Entity entity = Headbutt.HEADBUTT_SPAWNER.trigger(spawnLocation);
                    if (entity instanceof EntityPixelmon) {
                        pixelmon = (EntityPixelmon)entity;
                    }
                } else {
                    int heatbuttSelector = RNG.nextInt(EnumPokemon.headbuttEncounters.size());
                    String pokemonName = EnumPokemon.getFromName((String)EnumPokemon.headbuttEncounters.get((int)heatbuttSelector)).orElse((EnumPokemon)EnumPokemon.Magikarp).name;
                    while (pokemonName.equals(EnumPokemon.Magikarp.name)) {
                        heatbuttSelector = RNG.nextInt(EnumPokemon.headbuttEncounters.size());
                        pokemonName = EnumPokemon.getFromName((String)EnumPokemon.headbuttEncounters.get((int)heatbuttSelector)).orElse((EnumPokemon)EnumPokemon.Magikarp).name;
                    }
                    pixelmon = (EntityPixelmon)PixelmonEntityList.createEntityByName(pokemonName, worldIn);
                    pixelmon.func_70012_b(pos.func_177958_n(), pos.func_177984_a().func_177956_o(), pos.func_177952_p(), worldIn.field_73012_v.nextFloat() * 360.0f, 0.0f);
                    if (!worldIn.field_72995_K) {
                        worldIn.func_72838_d((Entity)pixelmon);
                    }
                }
                PlayerParticipant playerParticipant = new PlayerParticipant(player, fightingPokemon);
                WildPixelmonParticipant wildPixelmonParticipant = new WildPixelmonParticipant(true, pixelmon);
                if (pixelmon == null || Pixelmon.EVENT_BUS.post((Event)new PixelmonBlockStartingBattleEvent(worldIn, pos, player, startType, fightingPokemon, pixelmon, null))) {
                    return;
                }
                wildPixelmonParticipant.startedBattle = true;
                BattleControllerBase wildPixelmonParticipant2 = new BattleControllerBase(playerParticipant, wildPixelmonParticipant);
            } else if (startType == EnumBattleStartTypes.ROCKSMASH) {
                Object entity;
                if (RockSmash.ROCK_SMASH_SPAWNER != null && PixelmonSpawning.coordinator != null) {
                    SpatialData data = RockSmash.ROCK_SMASH_SPAWNER.calculateSpatialData(worldIn, pos.func_177984_a(), 10, true, block -> true);
                    SpawnLocation spawnLocation = new SpawnLocation(new MutableLocation(worldIn, pos), Lists.newArrayList((Object[])new LocationType[]{LocationType.ROCK_SMASH}), data.baseBlock, data.uniqueSurroundingBlocks, worldIn.func_180494_b(pos), worldIn.func_175678_i(pos), 10);
                    entity = RockSmash.ROCK_SMASH_SPAWNER.trigger(spawnLocation);
                    if (entity instanceof EntityPixelmon) {
                        pixelmon = (EntityPixelmon)((Object)entity);
                    }
                } else {
                    int rocksmashSelector = RNG.nextInt(EnumPokemon.rockSmashEncounters.size());
                    String pokemonName = EnumPokemon.getFromName((String)EnumPokemon.rockSmashEncounters.get((int)rocksmashSelector)).orElse((EnumPokemon)EnumPokemon.Magikarp).name;
                    while (pokemonName.equals(EnumPokemon.Magikarp.name)) {
                        rocksmashSelector = RNG.nextInt(EnumPokemon.rockSmashEncounters.size());
                        pokemonName = EnumPokemon.getFromName((String)EnumPokemon.rockSmashEncounters.get((int)rocksmashSelector)).orElse((EnumPokemon)EnumPokemon.Magikarp).name;
                    }
                    pixelmon = (EntityPixelmon)PixelmonEntityList.createEntityByName(pokemonName, worldIn);
                    pixelmon.func_70012_b(pos.func_177958_n(), pos.func_177984_a().func_177956_o(), pos.func_177952_p(), worldIn.field_73012_v.nextFloat() * 360.0f, 0.0f);
                    if (!worldIn.field_72995_K) {
                        worldIn.func_72838_d((Entity)pixelmon);
                    }
                }
                PlayerParticipant playerParticipant = new PlayerParticipant(player, fightingPokemon);
                WildPixelmonParticipant wildPixelmonParticipant = new WildPixelmonParticipant(true, pixelmon);
                if (pixelmon == null || Pixelmon.EVENT_BUS.post((Event)new PixelmonBlockStartingBattleEvent(worldIn, pos, player, startType, fightingPokemon, pixelmon, null))) {
                    return;
                }
                wildPixelmonParticipant.startedBattle = true;
                entity = new BattleControllerBase(playerParticipant, wildPixelmonParticipant);
            } else if (startType == EnumBattleStartTypes.SWEETSCENT && PixelmonSpawning.coordinator != null) {
                SpawnLocation spawnLocation = new SpawnLocation(new MutableLocation(worldIn, pos), LocationType.getPotentialTypes(worldIn.func_180495_p(player.func_180425_c().func_177982_a(0, -1, 0))), worldIn.func_180495_p(pos).func_177230_c(), null, worldIn.func_180494_b(pos), worldIn.func_175678_i(pos), 6);
                ArrayList<SpawnLocation> spawnLocations = new ArrayList<SpawnLocation>();
                spawnLocations.add(spawnLocation);
                PlayerTrackingSpawner playerTrackingSpawner = new PlayerTrackingSpawner(player.func_110124_au());
                for (AbstractSpawner spawner : PixelmonSpawning.coordinator.spawners) {
                    if (!(spawner instanceof PlayerTrackingSpawner) || ((PlayerTrackingSpawner)spawner).playerUUID.compareTo(player.func_110124_au()) != 0) continue;
                    playerTrackingSpawner = (PlayerTrackingSpawner)spawner;
                }
                ArrayList<SpawnAction<? extends Entity>> possibleSpawns = playerTrackingSpawner.calculateSpawnActions(spawnLocations);
                if (possibleSpawns.isEmpty()) {
                    return;
                }
                SpawnAction<? extends Entity> spawnAction = possibleSpawns.get(0);
                Entity entity = spawnAction.getOrCreateEntity();
                if (entity instanceof EntityPixelmon) {
                    pixelmon = (EntityPixelmon)entity;
                }
                PlayerParticipant playerParticipant = new PlayerParticipant(player, fightingPokemon);
                WildPixelmonParticipant wildPixelmonParticipant = new WildPixelmonParticipant(true, pixelmon);
                if (pixelmon == null || Pixelmon.EVENT_BUS.post((Event)new PixelmonBlockStartingBattleEvent(worldIn, pos, player, startType, fightingPokemon, pixelmon, null))) {
                    return;
                }
                wildPixelmonParticipant.startedBattle = true;
                BattleControllerBase battleControllerBase = new BattleControllerBase(playerParticipant, wildPixelmonParticipant);
            }
        }
    }

    private void createDoubleBattle(World worldIn, BlockPos pos, EntityPlayerMP player, String areaname) {
        Optional<PlayerStorage> optstorage = PixelmonStorage.pokeBallManager.getPlayerStorage(player);
        if (optstorage.isPresent()) {
            EntityPixelmon pixelmon2;
            EntityPixelmon pixelmon1;
            String pokemonName;
            PlayerStorage storage = optstorage.get();
            if (storage.getFirstAblePokemon(worldIn) == null) {
                return;
            }
            BlockSpawnData spawnData1 = null;
            BlockSpawnData spawnData2 = null;
            if (areaname.isEmpty()) {
                SpawnerLand spawner = new SpawnerLand();
                pokemonName = this.getPixelmonNameFromSpawner(worldIn, pos, spawner);
                if (pokemonName.isEmpty()) {
                    return;
                }
                pixelmon1 = (EntityPixelmon)PixelmonEntityList.createEntityByName(pokemonName, worldIn);
                pixelmon1.func_70012_b(pos.func_177958_n(), (float)pos.func_177956_o() + spawner.getYOffset(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), (EntityLiving)pixelmon1), pos.func_177952_p(), worldIn.field_73012_v.nextFloat() * 360.0f, 0.0f);
                pokemonName = this.getPixelmonNameFromSpawner(worldIn, pos, spawner);
                pixelmon2 = (EntityPixelmon)PixelmonEntityList.createEntityByName(pokemonName, worldIn);
                pixelmon2.func_70012_b(pos.func_177958_n(), (float)pos.func_177956_o() + spawner.getYOffset(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), (EntityLiving)pixelmon2), pos.func_177952_p(), worldIn.field_73012_v.nextFloat() * 360.0f, 0.0f);
            } else {
                BlockSpawnArea spawnArea = BlockSpawnRegistry.areaSpawns.get(areaname);
                pokemonName = this.getPixelmonNameFromArea(worldIn, spawnArea);
                if (pokemonName == null) {
                    return;
                }
                spawnData1 = spawnArea.blockSpawns.get(pokemonName);
                pixelmon1 = (EntityPixelmon)PixelmonEntityList.createEntityByName(pokemonName, worldIn);
                pixelmon1.func_70012_b(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), worldIn.field_73012_v.nextFloat() * 360.0f, 0.0f);
                pokemonName = this.getPixelmonNameFromArea(worldIn, spawnArea);
                spawnData2 = spawnArea.blockSpawns.get(pokemonName);
                pixelmon2 = (EntityPixelmon)PixelmonEntityList.createEntityByName(pokemonName, worldIn);
                pixelmon2.func_70012_b(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), worldIn.field_73012_v.nextFloat() * 360.0f, 0.0f);
            }
            if (!worldIn.field_72995_K) {
                worldIn.func_72838_d((Entity)pixelmon1);
                worldIn.func_72838_d((Entity)pixelmon2);
            }
            if (PixelmonConfig.scaleGrassBattles && spawnData1 == null && spawnData2 == null) {
                int maxLvl = storage.getHighestLevel();
                int minLvl = this.getLowestLevel(storage.getList());
                if (minLvl < maxLvl) {
                    int lvl = RNG.nextInt(maxLvl - minLvl) + minLvl;
                    pixelmon1.getLvl().setLevel(lvl);
                    lvl = RNG.nextInt(maxLvl - minLvl) + minLvl;
                    pixelmon2.getLvl().setLevel(lvl);
                } else {
                    pixelmon1.getLvl().setLevel(maxLvl);
                    pixelmon2.getLvl().setLevel(maxLvl);
                }
                pixelmon1.loadMoveset();
                pixelmon2.loadMoveset();
            } else if (spawnData1 != null && spawnData2 != null) {
                int lvl;
                int minLvl = spawnData1.minLvl;
                int maxLvl = spawnData1.maxLvl;
                if (minLvl < maxLvl) {
                    lvl = RNG.nextInt(maxLvl - minLvl) + minLvl;
                    pixelmon1.getLvl().setLevel(lvl);
                } else {
                    pixelmon1.getLvl().setLevel(maxLvl);
                }
                pixelmon1.loadMoveset();
                minLvl = spawnData2.minLvl;
                maxLvl = spawnData2.maxLvl;
                if (minLvl < maxLvl) {
                    lvl = RNG.nextInt(maxLvl - minLvl) + minLvl;
                    pixelmon2.getLvl().setLevel(lvl);
                } else {
                    pixelmon2.getLvl().setLevel(maxLvl);
                }
                pixelmon2.loadMoveset();
            }
            EntityPixelmon primaryPixelmon = storage.getFirstAblePokemon(worldIn);
            EntityPixelmon secondaryPixelmon = storage.getSecondAblePokemon(worldIn);
            if (Pixelmon.EVENT_BUS.post((Event)new PixelmonBlockStartingBattleEvent(worldIn, pos, player, EnumBattleStartTypes.PUGRASSDOUBLE, null, pixelmon1, pixelmon2))) {
                return;
            }
            BattleControllerBase battleControllerBase = new BattleControllerBase(new PlayerParticipant(player, primaryPixelmon, secondaryPixelmon), new WildPixelmonParticipant(true, pixelmon1, pixelmon2));
        }
    }

    private void createUnderwaterBattle(World worldIn, BlockPos pos, EntityPlayerMP player, String areaname) {
        EntityPixelmon pixelmon = null;
        BlockSpawnData spawnData = null;
        Optional<PlayerStorage> optstorage = PixelmonStorage.pokeBallManager.getPlayerStorage(player);
        if (optstorage.isPresent()) {
            String pokemonName;
            PlayerStorage storage = optstorage.get();
            if (storage.getFirstAblePokemon(worldIn) == null) {
                return;
            }
            EntityPixelmon startingPixelmon = storage.getFirstAblePokemon(worldIn);
            if (areaname.isEmpty()) {
                SpawnerLand spawner = new SpawnerLand();
                pokemonName = this.getPixelmonNameFromSpawner(worldIn, pos, spawner);
                if (pokemonName.isEmpty()) {
                    return;
                }
                pixelmon = (EntityPixelmon)PixelmonEntityList.createEntityByName(pokemonName, worldIn);
                pixelmon.func_70012_b(pos.func_177958_n(), (float)pos.func_177956_o() + spawner.getYOffset(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), (EntityLiving)pixelmon), pos.func_177952_p(), worldIn.field_73012_v.nextFloat() * 360.0f, 0.0f);
            } else {
                BlockSpawnArea spawnArea = BlockSpawnRegistry.areaSpawns.get(areaname);
                pokemonName = this.getPixelmonNameFromArea(worldIn, spawnArea);
                if (pokemonName == null) {
                    return;
                }
                spawnData = spawnArea.blockSpawns.get(pokemonName);
                pixelmon = (EntityPixelmon)PixelmonEntityList.createEntityByName(pokemonName, worldIn);
                pixelmon.func_70012_b(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), worldIn.field_73012_v.nextFloat() * 360.0f, 0.0f);
            }
            if (!worldIn.field_72995_K) {
                worldIn.func_72838_d((Entity)pixelmon);
            }
            if (PixelmonConfig.scaleGrassBattles && spawnData == null) {
                int minLvl;
                int maxLvl = storage.getHighestLevel();
                if (maxLvl - (minLvl = this.getLowestLevel(storage.getList())) > 5) {
                    minLvl = maxLvl - minLvl;
                }
                if (minLvl < maxLvl) {
                    int lvl = RNG.nextInt(maxLvl - minLvl) + minLvl;
                    pixelmon.getLvl().setLevel(lvl);
                } else {
                    pixelmon.getLvl().setLevel(maxLvl);
                }
                pixelmon.loadMoveset();
            } else if (spawnData != null) {
                int minLvl = spawnData.minLvl;
                int maxLvl = spawnData.maxLvl;
                if (minLvl < maxLvl) {
                    int lvl = RNG.nextInt(maxLvl - minLvl) + minLvl;
                    pixelmon.getLvl().setLevel(lvl);
                } else {
                    pixelmon.getLvl().setLevel(maxLvl);
                }
                pixelmon.loadMoveset();
            }
            PlayerParticipant playerParticipant = new PlayerParticipant(player, startingPixelmon);
            WildPixelmonParticipant wildPixelmonParticipant = new WildPixelmonParticipant(true, pixelmon);
            if (Pixelmon.EVENT_BUS.post((Event)new PixelmonBlockStartingBattleEvent(worldIn, pos, player, EnumBattleStartTypes.SEAWEED, null, pixelmon, null))) {
                return;
            }
            wildPixelmonParticipant.startedBattle = true;
            BattleControllerBase battleControllerBase = new BattleControllerBase(playerParticipant, wildPixelmonParticipant);
        }
    }

    public int getLowestLevel(NBTTagCompound[] partyPokemon) {
        int lvl = 100;
        for (NBTTagCompound nbt : partyPokemon) {
            if (nbt == null || nbt.func_74762_e("Level") >= lvl) continue;
            lvl = nbt.func_74762_e("Level");
        }
        return lvl;
    }

    private String getPixelmonNameFromSpawner(World worldIn, BlockPos pos, SpawnerLand spawner) {
        String biomeName = worldIn.func_180494_b(pos).getRegistryName().func_110623_a();
        String pokemonName = spawner.getRandomEntity(worldIn, RNG, biomeName, pos);
        if (!PixelmonConfig.blocksHaveLegendaries) {
            while (EnumPokemon.legendaries.contains(pokemonName)) {
                pokemonName = spawner.getRandomEntity(worldIn, RNG, biomeName, pos);
                while (!EnumPokemon.hasPokemonAnyCase(pokemonName)) {
                    pokemonName = spawner.getRandomEntity(worldIn, RNG, biomeName, pos);
                }
            }
        }
        return pokemonName;
    }

    private String getPixelmonNameFromArea(World world, BlockSpawnArea spawnArea) {
        String pokemonName = spawnArea.getRandomPokemon(world);
        if (!PixelmonConfig.blocksHaveLegendaries) {
            while (EnumPokemon.legendaries.contains(pokemonName)) {
                pokemonName = spawnArea.getRandomPokemon(world);
                while (!EnumPokemon.hasPokemonAnyCase(pokemonName)) {
                    pokemonName = spawnArea.getRandomPokemon(world);
                }
            }
        }
        return pokemonName;
    }
}

