/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.blocks.tileEntities;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.PixelmonMethods;
import com.pixelmonmod.pixelmon.api.enums.ReceiveType;
import com.pixelmonmod.pixelmon.api.events.PixelmonReceivedEvent;
import com.pixelmonmod.pixelmon.api.events.PixelmonTradeEvent;
import com.pixelmonmod.pixelmon.blocks.tileEntities.ISpecialTexture;
import com.pixelmonmod.pixelmon.comm.EnumUpdateType;
import com.pixelmonmod.pixelmon.comm.PixelmonData;
import com.pixelmonmod.pixelmon.comm.PixelmonStatsData;
import com.pixelmonmod.pixelmon.comm.packetHandlers.trading.RegisterTrader;
import com.pixelmonmod.pixelmon.comm.packetHandlers.trading.SetSelectedStats;
import com.pixelmonmod.pixelmon.comm.packetHandlers.trading.SetTradeTarget;
import com.pixelmonmod.pixelmon.comm.packetHandlers.trading.TradeReady;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.enums.EnumGui;
import com.pixelmonmod.pixelmon.enums.EnumPokemon;
import com.pixelmonmod.pixelmon.pokedex.EnumPokedexRegisterStatus;
import com.pixelmonmod.pixelmon.pokedex.Pokedex;
import com.pixelmonmod.pixelmon.storage.PixelmonStorage;
import com.pixelmonmod.pixelmon.storage.PlayerStorage;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class TileEntityTradeMachine
extends TileEntity
implements ITickable,
ISpecialTexture {
    private ResourceLocation texture = new ResourceLocation("pixelmon:textures/blocks/trademachine/Texture_red.png");
    private String colour = "red";
    private UUID owner = null;
    public int playerCount = 0;
    public EntityPlayerMP player1;
    public EntityPlayerMP player2;
    public boolean ready1;
    public boolean ready2;
    public int pos1 = -1;
    public int pos2 = -1;
    public String user1 = "";
    public String user2 = "";
    public NBTTagCompound poke1;
    public NBTTagCompound poke2;
    private boolean tradePushed = false;

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74778_a("colour", this.colour);
        if (this.owner != null) {
            compound.func_74778_a("owner", this.owner.toString());
        }
        return compound;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        if (compound.func_74764_b("colour")) {
            this.colour = compound.func_74779_i("colour");
            this.refreshTexture();
        }
        if (compound.func_74764_b("owner")) {
            this.owner = UUID.fromString(compound.func_74779_i("owner"));
        }
    }

    private void refreshTexture() {
        this.texture = new ResourceLocation("pixelmon:textures/blocks/trademachine/Texture_" + this.colour + ".png");
    }

    public String getColour() {
        return this.colour;
    }

    public void setColour(String colour) {
        this.colour = colour;
        this.sendChanges();
        this.func_70296_d();
    }

    @Override
    public ResourceLocation getTexture() {
        return this.texture;
    }

    public UUID getOwnerUUID() {
        return this.owner;
    }

    public void setOwner(UUID owner) {
        this.owner = owner;
        this.func_70296_d();
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.func_189515_b(nbt);
        nbt.func_74778_a("user1", this.player1 == null ? "" : this.player1.func_70005_c_());
        nbt.func_74778_a("user2", this.player2 == null ? "" : this.player2.func_70005_c_());
        nbt.func_74757_a("ready1", this.ready1);
        nbt.func_74757_a("ready2", this.ready2);
        if (this.poke1 != null) {
            nbt.func_74782_a("poke1", (NBTBase)this.poke1);
        }
        if (this.poke2 != null) {
            nbt.func_74782_a("poke2", (NBTBase)this.poke2);
        }
        return nbt;
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager networkManager, SPacketUpdateTileEntity packet) {
        NBTTagCompound data = packet.func_148857_g();
        this.colour = data.func_74779_i("colour");
        this.user1 = data.func_74779_i("user1");
        this.user2 = data.func_74779_i("user2");
        this.ready1 = data.func_74767_n("ready1");
        this.ready2 = data.func_74767_n("ready2");
        this.poke1 = data.func_74764_b("poke1") ? (data.func_74775_l("poke1").func_82582_d() ? null : data.func_74775_l("poke1")) : null;
        this.poke2 = data.func_74764_b("poke2") ? (data.func_74775_l("poke2").func_82582_d() ? null : data.func_74775_l("poke2")) : null;
        this.refreshTexture();
    }

    public void registerPlayer(EntityPlayerMP player) {
        if (this.playerCount == 1 && this.player1 == player) {
            return;
        }
        ++this.playerCount;
        if (this.playerCount == 1) {
            this.player1 = player;
        } else if (this.playerCount == 2) {
            this.player2 = player;
        } else {
            return;
        }
        player.openGui((Object)Pixelmon.instance, EnumGui.Trading.getIndex().intValue(), player.field_70170_p, this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p());
        if (player == this.player2) {
            Optional<PlayerStorage> optstorage;
            Pixelmon.network.sendTo((IMessage)new RegisterTrader(this.player1.func_110124_au()), this.player2);
            Pixelmon.network.sendTo((IMessage)new RegisterTrader(this.player2.func_110124_au()), this.player1);
            if (this.pos1 != -1 && (optstorage = PixelmonStorage.pokeBallManager.getPlayerStorage(this.player1)).isPresent()) {
                PlayerStorage s = optstorage.get();
                NBTTagCompound n = s.getNBT(s.getIDFromPosition(this.pos1));
                Pixelmon.network.sendTo((IMessage)new SetTradeTarget(new PixelmonData(n), new PixelmonStatsData(n)), this.player2);
                Pixelmon.network.sendTo((IMessage)new SetSelectedStats(new PixelmonStatsData(n)), this.player1);
            }
        }
        this.sendChanges();
    }

    public boolean ready(EntityPlayer player, boolean ready) {
        if (this.player1 != null && this.player2 != null) {
            if (player.func_110124_au().equals(this.player1.func_110124_au())) {
                this.ready1 = ready;
                Pixelmon.network.sendTo((IMessage)new TradeReady(ready), this.player2);
            }
            if (player.func_110124_au().equals(this.player2.func_110124_au())) {
                this.ready2 = ready;
                Pixelmon.network.sendTo((IMessage)new TradeReady(ready), this.player1);
            }
        }
        this.tradePushed = false;
        this.sendChanges();
        return false;
    }

    public void setPos1(int pos) {
        this.ready1 = false;
        this.ready2 = false;
        Optional<PlayerStorage> optstorage = PixelmonStorage.pokeBallManager.getPlayerStorage(this.player1);
        if (optstorage.isPresent()) {
            Optional<EntityPixelmon> pixelmonOptional;
            PlayerStorage s = optstorage.get();
            this.pos1 = pos;
            NBTTagCompound n = s.getNBT(s.getIDFromPosition(pos));
            if (n == null) {
                return;
            }
            if (s.isInWorld(PixelmonMethods.getID(n)) && (pixelmonOptional = s.getAlreadyExists(PixelmonMethods.getID(n), this.player1.field_70170_p)).isPresent()) {
                pixelmonOptional.get().catchInPokeball();
            }
            this.poke1 = new NBTTagCompound();
            this.poke1.func_74778_a("Name", n.func_74779_i("Name"));
            this.poke1.func_74768_a("Level", n.func_74762_e("Level"));
            this.poke1.func_74757_a("isEgg", n.func_74767_n("isEgg"));
            this.poke1.func_74768_a("eggCycles", n.func_74762_e("eggCycles"));
            this.poke1.func_74768_a("Variant", n.func_74762_e("Variant"));
            this.poke1.func_74757_a("IsShiny", n.func_74767_n("IsShiny"));
            this.poke1.func_74768_a("CaughtBall", n.func_74762_e("CaughtBall"));
            if (n.func_74764_b("HeldItemStack")) {
                this.poke1.func_74782_a("HeldItemStack", n.func_74781_a("HeldItemStack"));
            }
            this.sendChanges();
            Pixelmon.network.sendTo((IMessage)new SetSelectedStats(new PixelmonStatsData(n)), this.player1);
            if (this.player2 == null) {
                return;
            }
            Pixelmon.network.sendTo((IMessage)new SetTradeTarget(new PixelmonData(n), new PixelmonStatsData(n)), this.player2);
        }
    }

    public void setPos2(int pos) {
        this.ready1 = false;
        this.ready2 = false;
        Optional<PlayerStorage> optstorage = PixelmonStorage.pokeBallManager.getPlayerStorage(this.player2);
        if (optstorage.isPresent()) {
            Optional<EntityPixelmon> pixelmonOptional;
            PlayerStorage s = optstorage.get();
            this.pos2 = pos;
            NBTTagCompound n = s.getNBT(s.getIDFromPosition(pos));
            if (n == null) {
                return;
            }
            if (s.isInWorld(PixelmonMethods.getID(n)) && (pixelmonOptional = s.getAlreadyExists(PixelmonMethods.getID(n), this.player2.field_70170_p)).isPresent()) {
                pixelmonOptional.get().catchInPokeball();
            }
            this.poke2 = new NBTTagCompound();
            this.poke2.func_74778_a("Name", n.func_74779_i("Name"));
            this.poke2.func_74768_a("Level", n.func_74762_e("Level"));
            this.poke2.func_74757_a("isEgg", n.func_74767_n("isEgg"));
            this.poke2.func_74768_a("eggCycles", n.func_74762_e("eggCycles"));
            this.poke2.func_74768_a("Variant", n.func_74762_e("Variant"));
            this.poke2.func_74757_a("IsShiny", n.func_74767_n("IsShiny"));
            this.poke2.func_74768_a("CaughtBall", n.func_74762_e("CaughtBall"));
            if (n.func_74764_b("HeldItemStack")) {
                this.poke2.func_74782_a("HeldItemStack", n.func_74781_a("HeldItemStack"));
            }
            this.sendChanges();
            Pixelmon.network.sendTo((IMessage)new SetSelectedStats(new PixelmonStatsData(n)), this.player2);
            if (this.player1 == null) {
                return;
            }
            Pixelmon.network.sendTo((IMessage)new SetTradeTarget(new PixelmonData(n), new PixelmonStatsData(n)), this.player1);
        }
    }

    public void removePlayer(EntityPlayer player) {
        this.ready1 = false;
        this.ready2 = false;
        if (this.player1 == player) {
            this.player1 = this.player2;
            this.player2 = null;
            this.pos1 = this.pos2;
            this.pos2 = -1;
            this.poke1 = this.poke2;
            this.poke2 = null;
            --this.playerCount;
        } else if (this.player2 == player) {
            this.player2 = null;
            this.pos2 = -1;
            this.poke2 = null;
            --this.playerCount;
        }
        if (this.playerCount < 0) {
            this.playerCount = 0;
        }
        if (this.playerCount == 1) {
            Pixelmon.network.sendTo((IMessage)new RegisterTrader(null), this.player1);
            Pixelmon.network.sendTo((IMessage)new SetTradeTarget(true), this.player1);
        }
        this.sendChanges();
    }

    public void trade() {
        if (this.tradePushed || this.playerCount < 2 || !this.ready1 || !this.ready2) {
            return;
        }
        Optional<PlayerStorage> optstorage1 = PixelmonStorage.pokeBallManager.getPlayerStorage(this.player1);
        Optional<PlayerStorage> optstorage2 = PixelmonStorage.pokeBallManager.getPlayerStorage(this.player2);
        if (optstorage1.isPresent() && optstorage2.isPresent()) {
            NBTTagCompound pokemon2;
            PlayerStorage storage1 = optstorage1.get();
            PlayerStorage storage2 = optstorage2.get();
            this.tradePushed = true;
            NBTTagCompound pokemon1 = storage1.getNBT(storage1.getIDFromPosition(this.pos1));
            if (Pixelmon.EVENT_BUS.post((Event)new PixelmonTradeEvent((EntityPlayer)this.player1, (EntityPlayer)this.player2, pokemon1, pokemon2 = storage2.getNBT(storage2.getIDFromPosition(this.pos2))))) {
                this.player1.func_71053_j();
                this.player2.func_71053_j();
                this.playerCount = 0;
                this.sendChanges();
                return;
            }
            storage1.changePokemonAndAssignID(this.pos1, pokemon2);
            storage1.pokedex.set(Pokedex.nameToID(pokemon2.func_74779_i("Name")), EnumPokedexRegisterStatus.caught);
            storage1.pokedex.sendToPlayer(this.player1);
            storage2.changePokemonAndAssignID(this.pos2, pokemon1);
            storage2.pokedex.set(Pokedex.nameToID(pokemon1.func_74779_i("Name")), EnumPokedexRegisterStatus.caught);
            storage2.pokedex.sendToPlayer(this.player2);
            this.player1.func_71053_j();
            this.player2.func_71053_j();
            this.playerCount = 0;
            EntityPixelmon pixelmon1 = storage1.sendOut(PixelmonMethods.getID(pokemon2), this.field_145850_b);
            EntityPixelmon pixelmon2 = storage2.sendOut(PixelmonMethods.getID(pokemon1), this.field_145850_b);
            EnumPokemon species1 = pixelmon1.getSpecies();
            EnumPokemon species2 = pixelmon2.getSpecies();
            pixelmon1.friendship.setFriendship(pixelmon1.baseStats.baseFriendship);
            pixelmon1.update(EnumUpdateType.Friendship);
            pixelmon1.testTradeEvolution(species2);
            Pixelmon.EVENT_BUS.post((Event)new PixelmonReceivedEvent(this.player1, ReceiveType.Trade, pixelmon1));
            pixelmon2.friendship.setFriendship(pixelmon2.baseStats.baseFriendship);
            pixelmon2.update(EnumUpdateType.Friendship);
            pixelmon2.testTradeEvolution(species1);
            Pixelmon.EVENT_BUS.post((Event)new PixelmonReceivedEvent(this.player2, ReceiveType.Trade, pixelmon2));
        }
        this.sendChanges();
    }

    public void func_73660_a() {
        if (this.player1 == null && this.playerCount > 0) {
            this.player1 = this.player2;
            this.player2 = null;
            --this.playerCount;
            this.pos2 = -1;
            this.poke2 = null;
        } else if (this.player2 == null && this.playerCount > 1) {
            --this.playerCount;
            this.pos2 = -1;
            this.poke2 = null;
        }
        if (this.playerCount == 1) {
            Pixelmon.network.sendTo((IMessage)new RegisterTrader(null), this.player1);
        }
    }

    public void sendChanges() {
        if (this.func_145830_o()) {
            ((WorldServer)this.field_145850_b).func_184164_w().func_180244_a(this.field_174879_c);
        }
    }
}

