/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.battles.battleScreens.yesNo;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.client.ServerStorageDisplay;
import com.pixelmonmod.pixelmon.client.gui.battles.GuiBattle;
import com.pixelmonmod.pixelmon.client.gui.battles.battleScreens.yesNo.YesNoDialogue;
import com.pixelmonmod.pixelmon.comm.PixelmonData;
import com.pixelmonmod.pixelmon.enums.battle.BattleMode;
import com.pixelmonmod.pixelmon.util.RegexPatterns;
import net.minecraft.util.text.translation.I18n;

public class YesNoReplaceMove
extends YesNoDialogue {
    public YesNoReplaceMove(GuiBattle parent) {
        super(parent, BattleMode.YesNoReplaceMove);
    }

    @Override
    protected void drawConfirmText(int width, int height) {
        Attack newAttack;
        if (this.bm.newAttackList.isEmpty()) {
            this.parent.restoreSettingsAndClose();
            this.bm.mode = this.bm.oldMode;
            return;
        }
        PixelmonData pokemonToLearnAttack = ServerStorageDisplay.get(this.bm.newAttackList.get((int)0).pokemonID);
        try {
            newAttack = this.bm.newAttackList.get((int)0).attack;
        }
        catch (Exception e) {
            Pixelmon.LOGGER.warn("User is clicking too fast.");
            Pixelmon.LOGGER.warn("New attack list is " + e.getMessage());
            this.bm.mode = this.bm.oldMode;
            return;
        }
        float textAreaWidth = 170.0f;
        if (this.bm.selectedAttack == -1) {
            String attackName = newAttack.baseAttack.getLocalizedName();
            float textWidth = this.field_146297_k.field_71466_p.func_78256_a(RegexPatterns.$_M_VAR.matcher(I18n.func_74838_a((String)"gui.yesno.yousure")).replaceAll(attackName));
            int numLines = (int)(textWidth / textAreaWidth) + 1;
            this.field_146297_k.field_71466_p.func_78279_b(RegexPatterns.$_M_VAR.matcher(I18n.func_74838_a((String)"gui.yesno.yousure")).replaceAll(attackName), width / 2 - 109, height / 2 + 1 - numLines * 10 / 2, (int)textAreaWidth, 0);
            this.field_146297_k.field_71466_p.func_78279_b(RegexPatterns.$_M_VAR.matcher(I18n.func_74838_a((String)"gui.yesno.yousure")).replaceAll(attackName), width / 2 - 110, height / 2 - numLines * 10 / 2, (int)textAreaWidth, 0xFFFFFF);
        } else {
            if (pokemonToLearnAttack == null) {
                return;
            }
            String text = RegexPatterns.$_M_VAR.matcher(I18n.func_74838_a((String)"gui.yesno.replace")).replaceAll(pokemonToLearnAttack.moveset[this.bm.selectedAttack].getAttack().baseAttack.getLocalizedName());
            text = RegexPatterns.$_NM_VAR.matcher(text).replaceAll(newAttack.baseAttack.getLocalizedName());
            float textWidth = this.field_146297_k.field_71466_p.func_78256_a(text);
            int numLines = (int)(textWidth / textAreaWidth) + 1;
            this.field_146297_k.field_71466_p.func_78279_b(text, width / 2 - 109, height / 2 + 1 - numLines * 10 / 2, (int)textAreaWidth, 0);
            this.field_146297_k.field_71466_p.func_78279_b(text, width / 2 - 110, height / 2 - numLines * 10 / 2, (int)textAreaWidth, 0xFFFFFF);
        }
    }

    @Override
    protected void confirm() {
        if (this.bm.newAttackList.isEmpty()) {
            this.closeBattleScreen();
            return;
        }
        this.bm.newAttackList.remove(0);
        if (this.bm.sendPacket != null) {
            Pixelmon.network.sendToServer(this.bm.sendPacket);
        }
        if (this.bm.battleControllerIndex != -1) {
            if (this.bm.hasNewAttacks() || this.bm.hasLevelUps()) {
                this.bm.mode = this.bm.yesNoOrigin;
            } else {
                if (this.bm.battleEnded) {
                    this.closeBattleScreen();
                    return;
                }
                this.bm.mode = BattleMode.MainMenu;
                this.bm.checkClearedMessages();
            }
        } else {
            this.closeBattleScreen();
            return;
        }
    }

    private void closeBattleScreen() {
        this.parent.restoreSettingsAndClose();
        this.bm.mode = this.bm.oldMode;
    }
}

