/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm;

import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.NoStatus;
import com.pixelmonmod.pixelmon.battles.status.StatusPersist;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import com.pixelmonmod.pixelmon.comm.EnumUpdateType;
import com.pixelmonmod.pixelmon.comm.PixelmonMovesetData;
import com.pixelmonmod.pixelmon.comm.PixelmonUpdateData;
import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import com.pixelmonmod.pixelmon.database.DatabaseMoves;
import com.pixelmonmod.pixelmon.database.DatabaseStats;
import com.pixelmonmod.pixelmon.entities.pixelmon.Entity10CanBreed;
import com.pixelmonmod.pixelmon.entities.pixelmon.Entity1Base;
import com.pixelmonmod.pixelmon.entities.pixelmon.Entity3HasStats;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.entities.pixelmon.abilities.Illusion;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.BaseStats;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.Gender;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.Level;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.Moveset;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.Stats;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.StatsType;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.links.EntityLink;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.links.NBTLink;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.links.PokemonLink;
import com.pixelmonmod.pixelmon.enums.EnumBossMode;
import com.pixelmonmod.pixelmon.enums.EnumGrowth;
import com.pixelmonmod.pixelmon.enums.EnumNature;
import com.pixelmonmod.pixelmon.enums.EnumPokemon;
import com.pixelmonmod.pixelmon.enums.EnumType;
import com.pixelmonmod.pixelmon.enums.items.EnumPokeballs;
import com.pixelmonmod.pixelmon.storage.playerData.ExternalMoveData;
import com.pixelmonmod.pixelmon.storage.playerData.ExternalMoves;
import com.pixelmonmod.pixelmon.util.RegexPatterns;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.ByteBufUtils;

public class PixelmonData {
    public int[] pokemonID;
    public String name;
    public String nickname;
    public String OT = "";
    public int lvl;
    public int hp;
    public int health;
    public int friendship;
    public Gender gender;
    public boolean isFainted;
    public boolean isEgg;
    public int eggCycles;
    public int steps;
    public String eggDescription = "";
    public int nationalPokedexNumber = -1;
    public boolean selected = false;
    private EnumPokemon species;
    public int[] eggMoves = new int[0];
    public boolean inBattle;
    public EnumType type1 = null;
    public EnumType type2 = null;
    public int order;
    public int numMoves;
    public int HP;
    public int Speed;
    public int Attack;
    public int Defence;
    public int SpecialAttack;
    public int SpecialDefence;
    public int nextLvlXP;
    public int boxNumber = 0;
    public boolean isShiny;
    public boolean hasOwner;
    public boolean doesLevel;
    public boolean canHoldAnItem;
    public ItemStack heldItem = ItemStack.field_190927_a;
    public int xp;
    protected int effectCount = 0;
    public EnumBossMode bossMode;
    public EnumNature nature;
    public EnumGrowth growth;
    public EnumPokeballs pokeball;
    public StatusType status;
    public PixelmonMovesetData[] moveset = new PixelmonMovesetData[4];
    public String ability;
    public short specialTexture;
    public boolean isInRanch = false;
    public short selectedMoveIndex;
    public int[] evs = new int[6];
    public int[] ivs = new int[6];
    public int targetId = -1;
    public short form = (short)-1;
    public int numClones;
    public int numEnchanted;
    private String description;
    public boolean outside;
    public boolean resetMoves = true;
    private ExternalMoveData[] externalMoves;
    public EntityPixelmon outsideEntity;

    public int getNationalPokedexNumber() {
        if (this.nationalPokedexNumber == -1) {
            this.nationalPokedexNumber = this.getSpecies().getNationalPokedexInteger();
        }
        return this.nationalPokedexNumber;
    }

    public boolean isGen6Sprite() {
        return this.getNationalPokedexNumber() > 649 && !this.isEgg;
    }

    public EnumPokemon getSpecies() {
        if (this.species == null) {
            this.species = EnumPokemon.getFromNameAnyCase(this.name);
            if (this.species == null) {
                this.species = EnumPokemon.Bulbasaur;
            }
        }
        return this.species;
    }

    public EnumType getType1() {
        if (this.type1 == null) {
            this.type1 = Entity3HasStats.getBaseStats((String)this.name, (int)this.form).get().type1;
        }
        return this.type1;
    }

    public EnumType getType2() {
        if (this.type2 == null) {
            this.type2 = Entity3HasStats.getBaseStats((String)this.name, (int)this.form).get().type2;
        }
        return this.type2;
    }

    public boolean hasType(EnumType type) {
        return this.getType1() == type || this.getType2() == type;
    }

    public PixelmonData() {
    }

    public PixelmonData(NBTTagCompound p) {
        this(new NBTLink(p));
        int i;
        boolean movesetInvalid = false;
        try {
            for (i = 0; i < this.numMoves; ++i) {
                this.moveset[i] = PixelmonMovesetData.create(p, i);
                if (this.moveset[i] != null) continue;
                movesetInvalid = true;
            }
        }
        catch (NullPointerException e) {
            movesetInvalid = true;
        }
        if (movesetInvalid) {
            this.fixMoveset(p);
            for (i = 0; i < this.numMoves; ++i) {
                this.moveset[i] = PixelmonMovesetData.create(p, i);
            }
        }
        if (p.func_74764_b("BoxNumber")) {
            this.boxNumber = p.func_74762_e("BoxNumber");
        }
        if (p.func_74764_b("NumCloned")) {
            this.numClones = p.func_74762_e("NumCloned");
        }
        if (p.func_74764_b("NumEnchanted")) {
            this.numEnchanted = p.func_74762_e("NumEnchanted");
        }
    }

    private void fixMoveset(NBTTagCompound p) {
        for (int i = 0; i < this.numMoves; ++i) {
            Attack a;
            if (p.func_74764_b("PixelmonMoveID" + i) || (a = DatabaseMoves.getAttack(p.func_74779_i("PixelmonMoveName" + i))) != null) continue;
            p.func_82580_o("PixelmonMoveName" + i);
            p.func_82580_o("PixelmonMoveType" + i);
            p.func_82580_o("PixelmonMovePP" + i);
            p.func_82580_o("PixelmonMovePPBase" + i);
            for (int j = i + 1; j < this.numMoves; ++j) {
                int newIndex = j - 1;
                p.func_74768_a("PixelmonMoveID" + newIndex, p.func_74762_e("PixelmonMoveID" + j));
                p.func_74778_a("PixelmonMoveName" + newIndex, p.func_74779_i("PixelmonMoveName" + j));
                p.func_74768_a("PixelmonMovePP" + newIndex, p.func_74762_e("PixelmonMovePP" + j));
                p.func_74768_a("PixelmonMovePPBase" + newIndex, p.func_74762_e("PixelmonMovePPBase" + j));
            }
            --this.numMoves;
        }
        p.func_74768_a("PixelmonNumberMoves", this.numMoves);
    }

    public PixelmonData(EntityPixelmon p) {
        this(new EntityLink(p));
        this.targetId = p.func_70638_az() != null ? p.func_70638_az().func_145782_y() : -1;
    }

    public PixelmonData(EntityPixelmon p, boolean realNickname) {
        this(p);
        if (!realNickname) {
            this.nickname = p.getNickname();
            if (p.getAbility() instanceof Illusion && ((Illusion)p.getAbility()).disguisedGender != null) {
                this.gender = ((Illusion)p.getAbility()).disguisedGender;
            }
        }
    }

    public PixelmonData(PokemonLink p) {
        this.pokemonID = p.getPokemonID();
        BaseStats baseStats = p.getBaseStats();
        this.name = baseStats.pokemon.name;
        this.nickname = p.getNickname();
        this.lvl = p.getLevel();
        this.nextLvlXP = p.getExpToNextLevel();
        this.xp = p.getExp();
        Stats stats = p.getStats();
        this.hp = stats.HP;
        this.friendship = p.getFriendship().getFriendship();
        this.health = p.getHealth();
        this.gender = p.getGender();
        this.isFainted = p.isFainted();
        this.isShiny = p.isShiny();
        this.isEgg = p.isEgg();
        this.eggCycles = p.getEggCycles();
        this.eggDescription = Entity10CanBreed.getEggDescription(this.eggCycles);
        this.canHoldAnItem = !this.isEgg;
        this.nature = p.getNature();
        this.growth = p.getGrowth();
        this.pokeball = p.getCaughtBall();
        this.order = Math.max(0, p.getPartyPosition());
        Moveset moveset = p.getMoveset();
        this.numMoves = moveset.size();
        for (int i = 0; i < this.numMoves; ++i) {
            this.moveset[i] = PixelmonMovesetData.create(moveset, i);
        }
        this.HP = stats.HP;
        this.Speed = stats.Speed;
        this.Attack = stats.Attack;
        this.Defence = stats.Defence;
        this.SpecialAttack = stats.SpecialAttack;
        this.SpecialDefence = stats.SpecialDefence;
        this.heldItem = p.getHeldItemStack() == null ? ItemStack.field_190927_a : p.getHeldItemStack();
        this.hasOwner = p.hasOwner();
        this.doesLevel = p.doesLevel();
        StatusPersist status = p.getPrimaryStatus();
        if (status != NoStatus.noStatus) {
            this.status = status.type;
        }
        this.bossMode = p.getBossMode();
        this.OT = p.getOriginalTrainer();
        this.ability = RegexPatterns.SPACE_SYMBOL.matcher(p.getAbility().getName()).replaceAll("");
        this.specialTexture = (short)p.getSpecialTexture();
        this.isInRanch = p.isInRanch();
        this.form = (short)p.getForm();
        this.evs[0] = stats.EVs.get(StatsType.HP);
        this.evs[1] = stats.EVs.get(StatsType.Attack);
        this.evs[2] = stats.EVs.get(StatsType.Defence);
        this.evs[3] = stats.EVs.get(StatsType.SpecialAttack);
        this.evs[4] = stats.EVs.get(StatsType.SpecialDefence);
        this.evs[5] = stats.EVs.get(StatsType.Speed);
        this.ivs[0] = stats.IVs.get(StatsType.HP);
        this.ivs[1] = stats.IVs.get(StatsType.Attack);
        this.ivs[2] = stats.IVs.get(StatsType.Defence);
        this.ivs[3] = stats.IVs.get(StatsType.SpecialAttack);
        this.ivs[4] = stats.IVs.get(StatsType.SpecialDefence);
        this.ivs[5] = stats.IVs.get(StatsType.Speed);
        List<EnumType> types = p.getType();
        this.type1 = types.get(0);
        if (types.size() > 1) {
            this.type2 = types.get(1);
        }
        this.eggMoves = p.getEggMoves();
    }

    public PixelmonData(ByteBuf data) {
        this.decodeInto(data);
    }

    public String getDescription() {
        if (this.description == null) {
            this.description = DatabaseStats.getDescription(this.name);
        }
        if (this.description == null) {
            this.description = "";
        }
        return this.description;
    }

    public void update(PixelmonUpdateData p) {
        block17: for (EnumUpdateType type : p.updateTypes) {
            switch (type) {
                case HP: {
                    this.hp = p.hp;
                    this.health = p.health;
                    this.isFainted = p.isFainted;
                    continue block17;
                }
                case Stats: {
                    this.lvl = p.lvl;
                    this.nextLvlXP = p.nextLvlXP;
                    this.ability = p.ability;
                    this.xp = p.xp;
                    this.HP = p.HP;
                    this.Speed = p.Speed;
                    this.Attack = p.Attack;
                    this.Defence = p.Defence;
                    this.SpecialAttack = p.SpecialAttack;
                    this.SpecialDefence = p.SpecialDefence;
                    this.form = p.form;
                    this.isShiny = p.isShiny;
                    this.pokeball = p.pokeball;
                    this.gender = p.gender;
                    this.type1 = p.type1;
                    if (p.type2 != null) {
                        this.type2 = p.type2;
                    }
                    this.ivs = p.ivs;
                    this.evs = p.evs;
                    continue block17;
                }
                case Nickname: {
                    this.nickname = p.nickname;
                    continue block17;
                }
                case Name: {
                    this.name = p.name;
                    this.nationalPokedexNumber = p.getNationalPokedexNumber();
                    continue block17;
                }
                case Friendship: {
                    this.friendship = p.friendship;
                    continue block17;
                }
                case Moveset: {
                    this.numMoves = p.numMoves;
                    this.moveset = p.moveset;
                    this.resetMoves = true;
                    continue block17;
                }
                case HeldItem: {
                    this.heldItem = p.heldItem == null ? ItemStack.field_190927_a : p.heldItem;
                    this.resetMoves = true;
                    continue block17;
                }
                case Status: {
                    this.effectCount = p.effectCount;
                    this.status = p.status;
                    continue block17;
                }
                case CanLevel: {
                    this.doesLevel = p.doesLevel;
                    continue block17;
                }
                case Egg: {
                    this.isEgg = p.isEgg;
                    this.eggCycles = p.eggCycles;
                    this.steps = p.steps;
                    this.eggDescription = Entity10CanBreed.getEggDescription(this.eggCycles);
                    continue block17;
                }
                case Texture: {
                    this.specialTexture = p.specialTexture;
                    continue block17;
                }
                case Target: {
                    this.targetId = p.targetId;
                    continue block17;
                }
                case Ability: {
                    this.ability = p.ability;
                    continue block17;
                }
                case Clones: {
                    this.numClones = p.numClones;
                    continue block17;
                }
                case Enchants: {
                    this.numEnchanted = p.numEnchanted;
                    continue block17;
                }
            }
        }
    }

    public void updatePokemon(NBTTagCompound p) {
        if (p != null) {
            String[] allAbilities;
            Optional<BaseStats> optional;
            if (EnumPokemon.hasPokemon(this.name)) {
                p.func_74778_a("Name", this.name);
            }
            p.func_74778_a("Nickname", this.nickname);
            int currentLevel = p.func_74762_e("Level");
            if (currentLevel != this.lvl) {
                p.func_74768_a("Level", this.lvl);
                p.func_74768_a("EXP", 0);
            }
            p.func_74777_a("Gender", (short)this.gender.ordinal());
            p.func_74757_a("IsFainted", this.isFainted);
            p.func_74757_a("IsShiny", this.isShiny);
            p.func_74777_a("specialTexture", this.specialTexture);
            p.func_74777_a("Growth", (short)this.growth.index);
            p.func_74768_a("PixelmonNumberMoves", this.numMoves);
            p.func_74757_a("isEgg", this.isEgg);
            p.func_74768_a("eggCycles", this.eggCycles);
            p.func_74768_a("steps", this.steps);
            p.func_74768_a("Friendship", this.friendship);
            for (int i = 0; i < this.numMoves; ++i) {
                this.moveset[i].updatePokemon(p, i);
            }
            p.func_74777_a("BossMode", (short)this.bossMode.index);
            p.func_74768_a("EVHP", this.evs[0]);
            p.func_74768_a("EVAttack", this.evs[1]);
            p.func_74768_a("EVDefence", this.evs[2]);
            p.func_74768_a("EVSpecialAttack", this.evs[3]);
            p.func_74768_a("EVSpecialDefence", this.evs[4]);
            p.func_74768_a("EVSpeed", this.evs[5]);
            p.func_74768_a("IVHP", this.ivs[0]);
            p.func_74768_a("IVAttack", this.ivs[1]);
            p.func_74768_a("IVDefence", this.ivs[2]);
            p.func_74768_a("IVSpAtt", this.ivs[3]);
            p.func_74768_a("IVSpDef", this.ivs[4]);
            p.func_74768_a("IVSpeed", this.ivs[5]);
            p.func_74768_a("Nature", this.nature.index);
            p.func_74768_a("CaughtBall", this.pokeball.ordinal());
            p.func_74778_a("Ability", this.ability);
            if (this.heldItem == null || this.heldItem == ItemStack.field_190927_a) {
                if (p.func_74764_b("HeldItemStack")) {
                    p.func_82580_o("HeldItemStack");
                }
            } else {
                p.func_74782_a("HeldItemStack", (NBTBase)this.heldItem.func_77955_b(new NBTTagCompound()));
            }
            if (this.form != -1) {
                p.func_74768_a("Variant", (int)this.form);
            }
            if ((optional = Entity3HasStats.getBaseStats(this.name, (int)this.form)).isPresent() && (allAbilities = optional.get().abilities) != null) {
                for (int i = 0; i < allAbilities.length; ++i) {
                    if (!this.ability.equals(allAbilities[i])) continue;
                    p.func_74778_a("Ability", this.ability);
                    p.func_74768_a("AbilitySlot", i);
                    break;
                }
            }
            if (this.numClones > 0) {
                p.func_74768_a("NumCloned", this.numClones);
            } else {
                p.func_82580_o("NumCloned");
            }
            if (this.numEnchanted > 0) {
                p.func_74768_a("NumEnchanted", this.numEnchanted);
            } else {
                p.func_82580_o("NumEnchanted");
            }
        }
    }

    public void encodeInto(ByteBuf data) {
        data.writeInt(this.pokemonID[0]);
        data.writeInt(this.pokemonID[1]);
        ByteBufUtils.writeUTF8String((ByteBuf)data, (String)this.name);
        ByteBufUtils.writeUTF8String((ByteBuf)data, (String)this.nickname);
        ByteBufUtils.writeUTF8String((ByteBuf)data, (String)this.OT);
        data.writeShort(this.lvl);
        data.writeInt(this.nextLvlXP);
        data.writeShort(this.xp);
        data.writeShort(this.hp);
        data.writeShort(this.friendship);
        data.writeShort(this.health);
        data.writeShort(this.gender.ordinal());
        data.writeBoolean(this.isFainted);
        data.writeBoolean(this.hasOwner);
        data.writeShort(this.order);
        data.writeShort(this.numMoves);
        for (int i = 0; i < this.numMoves; ++i) {
            this.moveset[i].writeData(data);
        }
        data.writeShort(this.HP);
        data.writeShort(this.Speed);
        data.writeShort(this.Attack);
        data.writeShort(this.Defence);
        data.writeShort(this.SpecialAttack);
        data.writeShort(this.SpecialDefence);
        data.writeShort(this.boxNumber);
        data.writeBoolean(this.isShiny);
        data.writeShort(this.nature.index);
        data.writeShort(this.growth.index);
        data.writeShort(this.bossMode.index);
        if (this.pokeball != null) {
            data.writeShort(this.pokeball.getIndex());
        } else {
            data.writeShort(0);
        }
        data.writeBoolean(this.doesLevel);
        if (this.heldItem != ItemStack.field_190927_a && this.heldItem.func_77973_b() != Items.field_190931_a) {
            data.writeBoolean(true);
            ByteBufUtils.writeItemStack((ByteBuf)data, (ItemStack)this.heldItem);
        } else {
            data.writeBoolean(false);
        }
        if (this.status == null) {
            data.writeShort(-1);
        } else {
            data.writeShort(this.status.ordinal());
        }
        ByteBufUtils.writeUTF8String((ByteBuf)data, (String)this.ability);
        data.writeBoolean(this.isEgg);
        data.writeInt(this.eggCycles);
        data.writeInt(this.steps);
        ByteBufUtils.writeUTF8String((ByteBuf)data, (String)this.eggDescription);
        data.writeShort((int)this.specialTexture);
        data.writeBoolean(this.isInRanch);
        data.writeShort((int)this.form);
        for (int ev : this.evs) {
            data.writeShort(ev);
        }
        for (int iv : this.ivs) {
            data.writeShort(iv);
        }
        data.writeShort(this.type1 == null ? -1 : this.type1.getIndex());
        data.writeShort(this.type2 == null ? -1 : this.type2.getIndex());
        data.writeShort(this.eggMoves.length);
        int[] nArray = this.eggMoves;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            Integer eggMove = nArray[i];
            data.writeInt(eggMove.intValue());
        }
        data.writeBoolean(this.inBattle);
        data.writeInt(this.numClones);
        data.writeInt(this.numEnchanted);
    }

    public void decodeInto(ByteBuf data) {
        int i;
        short statusIndex;
        this.pokemonID = new int[]{data.readInt(), data.readInt()};
        this.name = ByteBufUtils.readUTF8String((ByteBuf)data);
        this.nickname = ByteBufUtils.readUTF8String((ByteBuf)data);
        this.OT = ByteBufUtils.readUTF8String((ByteBuf)data);
        this.lvl = data.readShort();
        this.nextLvlXP = data.readInt();
        this.xp = data.readShort();
        this.hp = data.readShort();
        this.friendship = data.readShort();
        this.health = data.readShort();
        this.gender = Gender.getGender(data.readShort());
        this.isFainted = data.readBoolean();
        this.hasOwner = data.readBoolean();
        this.order = data.readShort();
        this.numMoves = data.readShort();
        for (int i2 = 0; i2 < this.numMoves; ++i2) {
            this.moveset[i2] = new PixelmonMovesetData();
            this.moveset[i2].readData(data);
        }
        this.HP = data.readShort();
        this.Speed = data.readShort();
        this.Attack = data.readShort();
        this.Defence = data.readShort();
        this.SpecialAttack = data.readShort();
        this.SpecialDefence = data.readShort();
        this.boxNumber = data.readShort();
        this.isShiny = data.readBoolean();
        this.nature = EnumNature.getNatureFromIndex(data.readShort());
        this.growth = EnumGrowth.getGrowthFromIndex(data.readShort());
        this.bossMode = EnumBossMode.getMode(data.readShort());
        this.pokeball = EnumPokeballs.getFromIndex(data.readShort());
        this.doesLevel = data.readBoolean();
        if (data.readBoolean()) {
            this.heldItem = ByteBufUtils.readItemStack((ByteBuf)data);
        }
        if ((statusIndex = data.readShort()) > -1) {
            this.status = StatusType.getEffect(statusIndex);
        }
        this.ability = ByteBufUtils.readUTF8String((ByteBuf)data);
        this.isEgg = data.readBoolean();
        this.eggCycles = data.readInt();
        this.steps = data.readInt();
        this.eggDescription = ByteBufUtils.readUTF8String((ByteBuf)data);
        this.specialTexture = data.readShort();
        this.isInRanch = data.readBoolean();
        this.form = data.readShort();
        for (i = 0; i < this.evs.length; ++i) {
            this.evs[i] = data.readShort();
        }
        for (i = 0; i < this.ivs.length; ++i) {
            this.ivs[i] = data.readShort();
        }
        short type1 = data.readShort();
        this.type1 = type1 == -1 ? null : EnumType.parseOrNull(type1);
        short type2 = data.readShort();
        this.type2 = type2 == -1 ? null : EnumType.parseOrNull(type2);
        this.eggMoves = new int[data.readShort()];
        for (int i3 = 0; i3 < this.eggMoves.length; ++i3) {
            this.eggMoves[i3] = data.readInt();
        }
        this.inBattle = data.readBoolean();
        this.numClones = data.readInt();
        this.numEnchanted = data.readInt();
    }

    public BaseStats getBaseStats() {
        return Entity3HasStats.getBaseStats(this.name, (int)this.form).get();
    }

    public ExternalMoveData[] getExternalMoves() {
        if (this.resetMoves) {
            ExternalMoveData[] prevExternalMoves = this.externalMoves;
            this.externalMoves = ExternalMoves.load(this);
            if (prevExternalMoves != null) {
                block0: for (ExternalMoveData prevData : prevExternalMoves) {
                    for (ExternalMoveData currentData : this.externalMoves) {
                        if (prevData.moveIndex != currentData.moveIndex) continue;
                        currentData.timeLastUsed = prevData.timeLastUsed;
                        continue block0;
                    }
                }
            }
            this.resetMoves = false;
        }
        return this.externalMoves;
    }

    public float[] getStatusTexture() {
        if (this.status == null) {
            return new float[]{-1.0f, -1.0f};
        }
        return StatusType.getTexturePos(this.status);
    }

    public String getNickname() {
        if (this.isEgg) {
            return Entity1Base.getLocalizedName("Egg");
        }
        if (PixelmonConfig.allowNicknames && this.nickname != null && !this.nickname.isEmpty()) {
            return this.nickname;
        }
        return Entity1Base.getLocalizedName(this.name);
    }

    public String getEscapedNickname() {
        return Matcher.quoteReplacement(this.getNickname());
    }

    public boolean canMegaEvolve() {
        return PixelmonWrapper.canMegaEvolve(this.heldItem, this.getSpecies(), (int)this.form);
    }

    public float getExpFraction() {
        return Level.getExpFraction(this.xp, this.nextLvlXP);
    }
}

