/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.pokedex;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.enums.EnumGui;
import com.pixelmonmod.pixelmon.enums.EnumPokemon;
import com.pixelmonmod.pixelmon.pokedex.EnumPokedexRegisterStatus;
import com.pixelmonmod.pixelmon.pokedex.Pokedex;
import com.pixelmonmod.pixelmon.storage.PixelmonStorage;
import com.pixelmonmod.pixelmon.storage.PlayerStorage;
import io.netty.buffer.ByteBuf;
import java.util.Optional;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class OpenPokedex
implements IMessage {
    EnumPokemon pokemon;
    boolean reload;

    public OpenPokedex() {
    }

    public OpenPokedex(EnumPokemon pokemon) {
        this.pokemon = pokemon;
        this.reload = true;
    }

    public OpenPokedex(boolean reload) {
        this.reload = reload;
    }

    public void fromBytes(ByteBuf buf) {
        this.pokemon = EnumPokemon.getFromOrdinal(buf.readInt());
        this.reload = buf.readBoolean();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.pokemon == null ? -1 : this.pokemon.ordinal());
        buf.writeBoolean(this.reload);
    }

    public static class Handler
    implements IMessageHandler<OpenPokedex, IMessage> {
        public IMessage onMessage(OpenPokedex message, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            Optional<PlayerStorage> optstorage = PixelmonStorage.pokeBallManager.getPlayerStorage(player);
            if (optstorage.isPresent()) {
                PlayerStorage storage = optstorage.get();
                int id = 1;
                Pokedex pokedex = storage.pokedex;
                if (message.pokemon != null) {
                    id = Pokedex.nameToID(message.pokemon.name);
                    pokedex.set(id, EnumPokedexRegisterStatus.seen);
                }
                if (message.reload) {
                    pokedex.sendToPlayer(player);
                }
                int pokedexID = id;
                ctx.getServerHandler().field_147369_b.func_184102_h().func_152344_a(() -> player.openGui((Object)Pixelmon.instance, EnumGui.Pokedex.getIndex().intValue(), player.field_70170_p, pokedexID, 0, 0));
            }
            return null;
        }
    }
}

