/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.pokemoneditor;

import com.pixelmonmod.pixelmon.PixelmonMethods;
import com.pixelmonmod.pixelmon.client.gui.pokemoneditor.GuiPokemonEditorParty;
import com.pixelmonmod.pixelmon.items.ItemPokemonEditor;
import com.pixelmonmod.pixelmon.storage.PixelmonStorage;
import com.pixelmonmod.pixelmon.storage.PlayerStorage;
import io.netty.buffer.ByteBuf;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class DeletePokemon
implements IMessage {
    UUID playerID;
    int slot;

    public DeletePokemon() {
    }

    public DeletePokemon(int position) {
        this.playerID = GuiPokemonEditorParty.editedPlayerUUID;
        this.slot = position;
    }

    public void toBytes(ByteBuf buf) {
        PixelmonMethods.toBytesUUID(buf, this.playerID);
        buf.writeInt(this.slot);
    }

    public void fromBytes(ByteBuf buf) {
        this.playerID = PixelmonMethods.fromBytesUUID(buf);
        this.slot = buf.readInt();
    }

    public static void deletePokemon(UUID playerID, int slot, MessageContext ctx) {
        EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
        Optional<PlayerStorage> optstorage = PixelmonStorage.pokeBallManager.getPlayerStorageFromUUID(player.func_184102_h(), playerID);
        if (optstorage.isPresent()) {
            PlayerStorage storage = optstorage.get();
            storage.removeFromPartyPlayer(slot);
            ItemPokemonEditor.updateSinglePokemon(player, playerID, slot);
        }
    }

    public static class Handler
    implements IMessageHandler<DeletePokemon, IMessage> {
        public IMessage onMessage(DeletePokemon message, MessageContext ctx) {
            if (!ItemPokemonEditor.checkPermission(ctx.getServerHandler().field_147369_b)) {
                return null;
            }
            DeletePokemon.deletePokemon(message.playerID, message.slot, ctx);
            return null;
        }
    }
}

