/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.statueEditor;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.PixelmonMethods;
import com.pixelmonmod.pixelmon.api.events.StatueEvent;
import com.pixelmonmod.pixelmon.comm.EnumUpdateType;
import com.pixelmonmod.pixelmon.comm.packetHandlers.statueEditor.EnumStatuePacketMode;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityStatue;
import com.pixelmonmod.pixelmon.enums.EnumGrowth;
import com.pixelmonmod.pixelmon.enums.EnumStatueTextureType;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class StatuePacketServer
implements IMessage {
    EnumStatuePacketMode mode;
    int[] id;
    String name;
    boolean data;
    int intData;

    public StatuePacketServer() {
    }

    public StatuePacketServer(EnumStatuePacketMode mode, int[] id, String name) {
        this.mode = mode;
        this.id = id;
        this.name = name;
    }

    public StatuePacketServer(EnumStatuePacketMode mode, int[] id, boolean data) {
        this.mode = mode;
        this.id = id;
        this.data = data;
    }

    public StatuePacketServer(EnumStatuePacketMode mode, int[] id, int intData) {
        this.mode = mode;
        this.id = id;
        this.intData = intData;
    }

    public void fromBytes(ByteBuf buf) {
        this.mode = EnumStatuePacketMode.getFromOrdinal(buf.readShort());
        this.id = new int[]{buf.readInt(), buf.readInt()};
        switch (this.mode) {
            case SetGrowth: 
            case SetLabel: 
            case SetTextureType: 
            case SetAnimation: 
            case SetName: {
                this.name = ByteBufUtils.readUTF8String((ByteBuf)buf);
                break;
            }
            case SetModelStanding: {
                this.data = buf.readBoolean();
                break;
            }
            case SetAnimationFrame: 
            case SetForm: {
                this.intData = buf.readInt();
            }
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeShort((int)((short)this.mode.ordinal()));
        buf.writeInt(this.id[0]);
        buf.writeInt(this.id[1]);
        switch (this.mode) {
            case SetGrowth: 
            case SetLabel: 
            case SetTextureType: 
            case SetAnimation: 
            case SetName: {
                ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.name);
                break;
            }
            case SetModelStanding: {
                buf.writeBoolean(this.data);
                break;
            }
            case SetAnimationFrame: 
            case SetForm: {
                buf.writeInt(this.intData);
            }
        }
    }

    public static class Handler
    implements IMessageHandler<StatuePacketServer, IMessage> {
        public IMessage onMessage(StatuePacketServer message, MessageContext ctx) {
            ctx.getServerHandler().field_147369_b.func_184102_h().func_152344_a(() -> {
                EntityStatue statue = null;
                for (int i = 0; i < ctx.getServerHandler().field_147369_b.field_70170_p.field_72996_f.size(); ++i) {
                    Entity e = (Entity)ctx.getServerHandler().field_147369_b.field_70170_p.field_72996_f.get(i);
                    if (!(e instanceof EntityStatue) || !PixelmonMethods.isIDSame(((EntityStatue)e).getPokemonId(), message.id)) continue;
                    statue = (EntityStatue)e;
                    break;
                }
                if (statue == null) {
                    return;
                }
                Object value = message.mode.chooseValueForMode(message.name, message.data, message.intData);
                StatueEvent.ModifyStatue modifyEvent = new StatueEvent.ModifyStatue(ctx.getServerHandler().field_147369_b, statue, message.mode, value);
                if (Pixelmon.EVENT_BUS.post((Event)modifyEvent)) {
                    statue.update(EnumUpdateType.values());
                    ctx.getServerHandler().field_147369_b.func_71053_j();
                    return;
                }
                value = modifyEvent.getValue();
                switch (message.mode) {
                    case SetName: {
                        statue.init((String)value);
                        break;
                    }
                    case SetGrowth: {
                        statue.setGrowth((EnumGrowth)((Object)((Object)value)));
                        break;
                    }
                    case SetLabel: {
                        statue.setLabel((String)value);
                        break;
                    }
                    case SetTextureType: {
                        statue.setTextureType((EnumStatueTextureType)((Object)((Object)value)));
                        break;
                    }
                    case SetAnimation: {
                        statue.setAnimation((String)value);
                        break;
                    }
                    case SetModelStanding: {
                        statue.setIsFlying((Boolean)value);
                        break;
                    }
                    case SetAnimationFrame: {
                        statue.setAnimationFrame((Integer)value);
                        break;
                    }
                    case SetForm: {
                        statue.setForm((Integer)value, false);
                    }
                }
            });
            return null;
        }
    }
}

