/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.commands;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.command.PixelmonCommand;
import com.pixelmonmod.pixelmon.client.PlayerExtraDataStore;
import com.pixelmonmod.pixelmon.comm.packetHandlers.PlayerExtrasPacket;
import com.pixelmonmod.pixelmon.storage.PlayerExtraData;
import com.pixelmonmod.pixelmon.storage.PlayerExtras;
import java.util.Collections;
import java.util.List;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class Redeem
extends PixelmonCommand {
    public Redeem() {
        super(new PixelmonCommand[0]);
    }

    public String func_71517_b() {
        return "redeem";
    }

    public String func_71518_a(ICommandSender icommandsender) {
        return "/redeem <slot number/hat name/remove hat/toggle sash>";
    }

    public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
        return true;
    }

    @Override
    public void execute(ICommandSender sender, String[] args) throws CommandException {
        EntityPlayer player = (EntityPlayer)sender;
        PlayerExtraData data = PlayerExtraDataStore.get(player);
        if (args.length == 0) {
            PlayerExtraDataStore.refreshClient();
        } else if (data.hasData()) {
            if (args.length == 2 && args[0].equalsIgnoreCase("remove") && args[1].equalsIgnoreCase("hat")) {
                if (data.getHatType() != PlayerExtras.HatType.NONE) {
                    data.removeHat();
                    Pixelmon.network.sendToServer((IMessage)new PlayerExtrasPacket(data));
                    PlayerExtraDataStore.saveClientData();
                }
            } else if (args.length == 2 && args[0].equalsIgnoreCase("toggle") && args[1].equalsIgnoreCase("sash")) {
                if (data.hasSash) {
                    data.sashEnabled = !data.sashEnabled;
                    Pixelmon.network.sendToServer((IMessage)new PlayerExtrasPacket(data));
                    PlayerExtraDataStore.saveClientData();
                }
            } else if (args[0].equalsIgnoreCase("trainerhat")) {
                if (data.hasCap) {
                    data.setHatType(PlayerExtras.HatType.TRAINER_HAT);
                    if (args.length == 4) {
                        try {
                            int r = Integer.parseInt(args[1]);
                            int g = Integer.parseInt(args[2]);
                            int b = Integer.parseInt(args[3]);
                            if (r > 255 || r < -1 || g > 255 || g < 0 || b > 255 || b < 0) {
                                this.sendMessage(sender, TextFormatting.RED, "pixelmon.command.trainerhat.invalidcolour", new Object[0]);
                            } else {
                                data.setCapColours(r, g, b);
                            }
                        }
                        catch (NumberFormatException e) {
                            this.sendMessage(sender, TextFormatting.RED, "pixelmon.command.trainerhat.invalidcolour", new Object[0]);
                        }
                    }
                    Pixelmon.network.sendToServer((IMessage)new PlayerExtrasPacket(data));
                    PlayerExtraDataStore.saveClientData();
                }
            } else if (args[0].equalsIgnoreCase("tophat")) {
                if (data.setHatType(PlayerExtras.HatType.TOP_HAT)) {
                    Pixelmon.network.sendToServer((IMessage)new PlayerExtrasPacket(data));
                    PlayerExtraDataStore.saveClientData();
                }
            } else if (args[0].equalsIgnoreCase("fez")) {
                if (data.setHatType(PlayerExtras.HatType.FEZ)) {
                    Pixelmon.network.sendToServer((IMessage)new PlayerExtrasPacket(data));
                    PlayerExtraDataStore.saveClientData();
                }
            } else if (args[0].equalsIgnoreCase("fedora")) {
                if (data.setHatType(PlayerExtras.HatType.FEDORA)) {
                    Pixelmon.network.sendToServer((IMessage)new PlayerExtrasPacket(data));
                    PlayerExtraDataStore.saveClientData();
                }
            } else if (args.length == 1) {
                try {
                    int slot = Integer.parseInt(args[0]);
                    Pixelmon.network.sendToServer((IMessage)PlayerExtrasPacket.getSetTexturePacket(slot));
                }
                catch (NumberFormatException e) {
                    this.sendMessage(sender, TextFormatting.RED, "pixelmon.command.general.invalid", new Object[0]);
                }
            } else {
                this.sendMessage(sender, TextFormatting.RED, "pixelmon.command.general.invalid", new Object[0]);
            }
        }
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos pos) {
        if (args.length == 1) {
            return Redeem.func_71530_a((String[])args, (String[])new String[]{"remove", "toggle", "trainerhat"});
        }
        if (args.length == 2 && args[0].equalsIgnoreCase("remove")) {
            return Redeem.func_71530_a((String[])args, (String[])new String[]{"hat"});
        }
        if (args.length == 2 && args[0].equalsIgnoreCase("toggle")) {
            return Redeem.func_71530_a((String[])args, (String[])new String[]{"sash"});
        }
        return Collections.emptyList();
    }
}

