/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.config;

import com.pixelmonmod.pixelmon.blocks.decorative.BlockUnown;
import com.pixelmonmod.pixelmon.config.PixelmonBlocks;
import com.pixelmonmod.pixelmon.config.PixelmonItems;
import com.pixelmonmod.pixelmon.util.helpers.SpriteHelper;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;

class UnownBlockRecipe
implements IRecipe {
    private ItemStack output;
    private String tagSuffix;
    private ResourceLocation name;

    public UnownBlockRecipe(int damage) {
        int numUnownBlocks = BlockUnown.getNumUnownBlocks();
        int form = damage;
        if (form == numUnownBlocks - 2) {
            form = numUnownBlocks - 3;
        } else if (form == numUnownBlocks - 3) {
            form = numUnownBlocks - 2;
        }
        this.tagSuffix = SpriteHelper.getSpriteExtra("Unown", form);
        Block unownBlock = PixelmonBlocks.blockUnown;
        if (damage >= 16) {
            damage -= 16;
            unownBlock = PixelmonBlocks.blockUnown2;
        }
        this.output = new ItemStack(unownBlock, 1, damage);
        this.setRegistryName(new ResourceLocation("pixelmon", "unown_block" + ((BlockUnown)unownBlock).alphabetInUse[damage]));
    }

    public boolean func_77569_a(InventoryCrafting inv, World worldIn) {
        boolean hasBlock = false;
        boolean hasPhoto = false;
        boolean hasExtra = false;
        String tag = "pixelmon:sprites/pokemon/201" + this.tagSuffix;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack currentItem = inv.func_70301_a(i);
            if (currentItem.func_190926_b()) continue;
            if (currentItem.func_77973_b() == Item.func_150898_a((Block)PixelmonBlocks.blockUnown2) && currentItem.func_77952_i() == BlockUnown.getBlankUnownBlockIndex() && !hasBlock) {
                hasBlock = true;
                continue;
            }
            if (!hasPhoto && currentItem.func_77973_b() == PixelmonItems.itemPixelmonSprite && currentItem.func_77942_o() && tag.equals(currentItem.func_77978_p().func_74779_i("SpriteName"))) {
                hasPhoto = true;
                continue;
            }
            hasExtra = true;
            break;
        }
        return hasBlock && hasPhoto && !hasExtra;
    }

    public ItemStack func_77572_b(InventoryCrafting inv) {
        return this.output.func_77946_l();
    }

    public boolean func_194133_a(int width, int height) {
        return width == 2 && height == 2;
    }

    public ItemStack func_77571_b() {
        return this.output;
    }

    public IRecipe setRegistryName(ResourceLocation name) {
        this.name = name;
        return this;
    }

    @Nullable
    public ResourceLocation getRegistryName() {
        return this.name;
    }

    public Class<IRecipe> getRegistryType() {
        return IRecipe.class;
    }

    public NonNullList<ItemStack> func_179532_b(InventoryCrafting inv) {
        NonNullList nonnulllist = NonNullList.func_191197_a((int)inv.func_70302_i_(), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < nonnulllist.size(); ++i) {
            ItemStack itemStack = inv.func_70301_a(i);
            nonnulllist.set(i, (Object)ForgeHooks.getContainerItem((ItemStack)itemStack));
        }
        return nonnulllist;
    }
}

