/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.pixelmon.externalMoves;

import com.pixelmonmod.pixelmon.comm.PixelmonData;
import com.pixelmonmod.pixelmon.config.PixelmonItemsHeld;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.entities.pixelmon.externalMoves.ExternalMoveBase;
import com.pixelmonmod.pixelmon.entities.pixelmon.helpers.EvolutionQuery;
import com.pixelmonmod.pixelmon.enums.EnumPokemon;
import com.pixelmonmod.pixelmon.enums.forms.EnumGreninja;
import com.pixelmonmod.pixelmon.enums.forms.EnumGroudon;
import com.pixelmonmod.pixelmon.items.ItemHeld;
import com.pixelmonmod.pixelmon.items.heldItems.ItemMegaStone;
import com.pixelmonmod.pixelmon.storage.PlayerStorage;
import net.minecraft.util.math.RayTraceResult;

public class MegaEvolution
extends ExternalMoveBase {
    public MegaEvolution() {
        super("mega", null);
        this.targetted = false;
    }

    @Override
    public boolean execute(EntityPixelmon user, RayTraceResult target, int moveIndex) {
        if (user.func_70902_q() != null && !user.isMega) {
            PlayerStorage storage = user.getStorage().orElse(null);
            if (storage == null) {
                return false;
            }
            if (user.getSpecies() == EnumPokemon.Kyogre && user.getItemHeld() == PixelmonItemsHeld.blueOrb || user.getSpecies() == EnumPokemon.Groudon && user.getItemHeld() == PixelmonItemsHeld.redOrb) {
                new EvolutionQuery(user, EnumGroudon.Primal.getForm());
                user.isMega = true;
            } else if (user.getSpecies() == EnumPokemon.Greninja && user.getFormEnum() == EnumGreninja.BATTLE_BOND) {
                new EvolutionQuery(user, EnumGreninja.ASH.getForm());
                user.isMega = true;
            } else if (user.getSpecies() == EnumPokemon.Rayquaza && EnumPokemon.Rayquaza.hasMega()) {
                if (user.getMoveset().hasAttack("Dragon Ascent", "attack.dragon ascent.name")) {
                    new EvolutionQuery(user, 1);
                    user.isMega = true;
                }
            } else {
                ItemHeld held = user.getItemHeld();
                if (!(held instanceof ItemMegaStone) || ((ItemMegaStone)held).pokemon != user.getSpecies()) {
                    return false;
                }
                ItemMegaStone stone = (ItemMegaStone)held;
                if (!storage.megaData.getMegaItem().canEvolve()) {
                    return false;
                }
                new EvolutionQuery(user, stone.form);
                user.isMega = true;
            }
        }
        return true;
    }

    @Override
    public int getCooldown(EntityPixelmon user) {
        return 20;
    }

    @Override
    public int getCooldown(PixelmonData pixelmonData) {
        return 20;
    }

    @Override
    public boolean isDestructive() {
        return false;
    }
}

