/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.pixelmon.externalMoves;

import com.pixelmonmod.pixelmon.api.spawning.archetypes.spawners.TriggerSpawner;
import com.pixelmonmod.pixelmon.blocks.BlockFossil;
import com.pixelmonmod.pixelmon.blocks.MultiBlock;
import com.pixelmonmod.pixelmon.blocks.spawning.BlockSpawningHandler;
import com.pixelmonmod.pixelmon.comm.PixelmonData;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.entities.pixelmon.externalMoves.ExternalMoveBase;
import com.pixelmonmod.pixelmon.enums.battle.EnumBattleStartTypes;
import com.pixelmonmod.pixelmon.util.PixelBlockSnapshot;
import javax.swing.Timer;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.GameType;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.Event;

public class RockSmash
extends ExternalMoveBase {
    public static TriggerSpawner ROCK_SMASH_SPAWNER = null;

    public RockSmash() {
        super("rocksmash", "Rock Smash");
    }

    @Override
    public boolean execute(EntityPixelmon user, RayTraceResult target, int moveIndex) {
        if (target.field_72313_a == RayTraceResult.Type.BLOCK) {
            World world = user.field_70170_p;
            BlockPos pos = target.func_178782_a();
            IBlockState state = world.func_180495_p(pos);
            if (state.func_185904_a() != Material.field_151576_e || state.func_177230_c() == Blocks.field_150357_h) {
                return false;
            }
            if (state.func_177230_c() instanceof MultiBlock || state.func_177230_c() instanceof BlockFossil) {
                return false;
            }
            if (((EntityPlayerMP)user.func_70902_q()).field_71134_c.func_73081_b() == GameType.ADVENTURE) {
                PixelBlockSnapshot snapshot = new PixelBlockSnapshot(world, pos, state);
                world.func_175698_g(pos);
                Timer timer = new Timer(7000, e -> snapshot.restoreToLocation(world, pos, true, true));
                timer.setRepeats(false);
                timer.start();
            } else {
                if (MinecraftForge.EVENT_BUS.post((Event)new BlockEvent.BreakEvent(world, pos, state, (EntityPlayer)((EntityPlayerMP)user.func_70902_q())))) {
                    return false;
                }
                if (((EntityPlayerMP)user.func_70902_q()).field_71134_c.func_180237_b(pos)) {
                    state.func_177230_c().func_176226_b(world, pos, state, 3);
                }
            }
            BlockSpawningHandler.getInstance().performBattleStartCheck(world, pos, (Entity)user.func_70902_q(), user, "", EnumBattleStartTypes.ROCKSMASH);
            return true;
        }
        return false;
    }

    @Override
    public int getCooldown(EntityPixelmon user) {
        return 800 - user.stats.Speed;
    }

    @Override
    public int getCooldown(PixelmonData user) {
        return 800 - user.Speed;
    }

    @Override
    public boolean isDestructive() {
        return true;
    }
}

