/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.pixelmon.interactions;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.interactions.IInteraction;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.comm.EnumUpdateType;
import com.pixelmonmod.pixelmon.comm.packetHandlers.OpenReplaceMoveScreen;
import com.pixelmonmod.pixelmon.config.PixelmonItems;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.enums.EnumPokemon;
import com.pixelmonmod.pixelmon.enums.forms.EnumPikachu;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class InteractionCostumes
implements IInteraction {
    @Override
    public boolean processInteract(EntityPixelmon pixelmon, EntityPlayer player, EnumHand hand, ItemStack itemStack) {
        Item item = itemStack.func_77973_b();
        if (!this.isCostume(item)) {
            return false;
        }
        if (pixelmon.func_70902_q() != player) {
            return false;
        }
        if (pixelmon.getSpecies() != EnumPokemon.Pikachu) {
            return false;
        }
        EnumPikachu form = (EnumPikachu)pixelmon.getFormEnum();
        EnumPikachu newForm = EnumPikachu.getCosplayForm(item);
        if (newForm == form) {
            return false;
        }
        if (form.canCosplay()) {
            if (player.func_184614_ca().func_190916_E() == 1) {
                player.func_184611_a(EnumHand.MAIN_HAND, new ItemStack(form.getCosplayItem()));
            } else {
                ItemStack newItem = player.func_184614_ca();
                newItem.func_190920_e(newItem.func_190916_E() - 1);
                player.func_184611_a(EnumHand.MAIN_HAND, newItem);
                player.func_191521_c(new ItemStack(form.getCosplayItem()));
            }
            if (this.hasSpecialMove(pixelmon)) {
                for (int i = 0; i < pixelmon.getMoveset().size(); ++i) {
                    Attack attack = pixelmon.getMoveset().get(i);
                    if (attack == null || !this.isSpecial(attack)) continue;
                    TextComponentTranslation text = new TextComponentTranslation("replacemove.replace", new Object[]{pixelmon.getPokemonName(), attack.baseAttack.getLocalizedName(), newForm.getCosplayAttack().baseAttack.getLocalizedName()});
                    text.func_150256_b().func_150238_a(TextFormatting.GRAY);
                    player.func_145747_a((ITextComponent)text);
                    pixelmon.getMoveset().set(i, newForm.getCosplayAttack());
                    pixelmon.update(EnumUpdateType.Moveset);
                }
            } else if (pixelmon.getMoveset().size() == 4) {
                Pixelmon.network.sendTo((IMessage)new OpenReplaceMoveScreen(pixelmon.getPokemonId(), newForm.getCosplayAttack().baseAttack.attackIndex, 0, pixelmon.getLvl().getLevel(), false), (EntityPlayerMP)player);
            } else {
                pixelmon.getMoveset().add(newForm.getCosplayAttack());
                TextComponentTranslation text = new TextComponentTranslation("pixelmon.stats.learnedmove", new Object[]{newForm.getCosplayAttack().baseAttack.getLocalizedName()});
                text.func_150256_b().func_150238_a(TextFormatting.GRAY);
                player.func_145747_a((ITextComponent)text);
            }
            pixelmon.setForm(newForm.getForm());
            player.func_184185_a(SoundEvents.field_187638_cR, 1.0f, 1.0f);
            return true;
        }
        return false;
    }

    private boolean isSpecial(Attack attack) {
        return attack.isAttack("Meteor Mash", "Icicle Crash", "Draining Kiss", "Electric Terrain", "Flying Press", "Thunder Shock", "ThunderShock");
    }

    private boolean hasSpecialMove(EntityPixelmon pixelmon) {
        return pixelmon.getMoveset().hasAttack("Meteor Mash", "Icicle Crash", "Draining Kiss", "Flying Press", "Electric Terrain", "ThunderShock", "Thunder Shock");
    }

    private boolean isCostume(Item item) {
        return item == PixelmonItems.belleCostume || item == PixelmonItems.libreCostume || item == PixelmonItems.phdCostume || item == PixelmonItems.popStarCostume || item == PixelmonItems.rockStarCostume;
    }
}

