/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.pixelmon.interactions.custom;

import com.google.common.collect.Maps;
import com.pixelmonmod.pixelmon.entities.pixelmon.Entity8HoldsItems;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.entities.pixelmon.interactions.custom.CameruptInteraction;
import com.pixelmonmod.pixelmon.entities.pixelmon.interactions.custom.MareepInteraction;
import com.pixelmonmod.pixelmon.entities.pixelmon.interactions.custom.MiltankInteraction;
import java.util.HashMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;

public abstract class PixelmonInteraction {
    public EntityPixelmon pixelmon;
    public int maxInteractions;
    public int maxCount = 400;
    int count = 0;
    private static HashMap<String, Class<? extends PixelmonInteraction>> pixelmonInteractions = Maps.newHashMap();

    public PixelmonInteraction(EntityPixelmon pixelmon, int maxInteractions) {
        this.pixelmon = pixelmon;
        this.maxInteractions = maxInteractions;
        this.setNumInteractions(maxInteractions);
        this.maxCount = pixelmon.func_70681_au().nextInt(1200) + 800;
    }

    public abstract boolean processInteract(EntityPixelmon var1, EntityPlayer var2, EnumHand var3, ItemStack var4);

    public int getNumInteractions() {
        return (Integer)this.pixelmon.func_184212_Q().func_187225_a(EntityPixelmon.dwNumInteractions);
    }

    public void setNumInteractions(int newValue) {
        this.pixelmon.func_184212_Q().func_187227_b(EntityPixelmon.dwNumInteractions, (Object)newValue);
    }

    public void tick() {
        if (!this.pixelmon.field_70170_p.field_72995_K) {
            ++this.count;
            if (this.count > this.maxCount) {
                if (this.getNumInteractions() < this.maxInteractions) {
                    this.setNumInteractions(this.getNumInteractions() + 1);
                }
                this.count = 0;
                this.maxCount = this.pixelmon.func_70681_au().nextInt(600) + 400;
            }
        }
    }

    public void writeEntityToNBT(NBTTagCompound nbt) {
        nbt.func_74777_a("NumInteractions", (short)this.getNumInteractions());
        nbt.func_74777_a("InteractionCount", (short)this.count);
    }

    public void readEntityFromNBT(NBTTagCompound nbt) {
        if (nbt.func_74764_b("NumInteractions")) {
            this.setNumInteractions(nbt.func_74765_d("NumInteractions"));
        }
        if (nbt.func_74764_b("InteractionCount")) {
            this.count = nbt.func_74765_d("InteractionCount");
        }
    }

    public static PixelmonInteraction getInteraction(Entity8HoldsItems pixelmon) {
        if (!pixelmonInteractions.containsKey(pixelmon.getPokemonName())) {
            return null;
        }
        Class<? extends PixelmonInteraction> c = pixelmonInteractions.get(pixelmon.getPokemonName());
        try {
            return c.getConstructor(EntityPixelmon.class).newInstance(new Object[]{pixelmon});
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    static {
        pixelmonInteractions.put("Miltank", MiltankInteraction.class);
        pixelmonInteractions.put("Camerupt", CameruptInteraction.class);
        pixelmonInteractions.put("Mareep", MareepInteraction.class);
    }
}

