/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.pixelmon.tickHandlers;

import com.google.common.collect.Maps;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.entities.pixelmon.tickHandlers.CastformTickHandler;
import com.pixelmonmod.pixelmon.enums.EnumPokemon;
import java.util.HashMap;
import net.minecraft.world.World;

public abstract class TickHandlerBase {
    protected EntityPixelmon pixelmon;
    private int refreshRate;
    private int ticks = 0;
    private static HashMap<EnumPokemon, Class<? extends TickHandlerBase>> tickHandlers = Maps.newHashMap();

    public TickHandlerBase(EntityPixelmon pixelmon, int refreshRate) {
        this.pixelmon = pixelmon;
        this.refreshRate = refreshRate;
    }

    public TickHandlerBase(EntityPixelmon pixelmon) {
        this(pixelmon, 0);
    }

    protected abstract void onTick(World var1);

    public void tick(World world) {
        if (++this.ticks > this.refreshRate) {
            this.ticks = 0;
            this.onTick(world);
        }
    }

    public static TickHandlerBase getTickHandler(EntityPixelmon pixelmon) {
        if (!tickHandlers.containsKey((Object)pixelmon.getSpecies())) {
            return null;
        }
        Class<? extends TickHandlerBase> c = tickHandlers.get((Object)pixelmon.baseStats.pokemon);
        try {
            return c.getConstructor(EntityPixelmon.class).newInstance(new Object[]{pixelmon});
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    static {
        tickHandlers.put(EnumPokemon.Castform, CastformTickHandler.class);
    }
}

