/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.spawning;

import com.google.common.collect.ImmutableList;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.events.PixelmonSpawnEvent;
import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import com.pixelmonmod.pixelmon.config.PixelmonEntityList;
import com.pixelmonmod.pixelmon.database.SpawnLocation;
import com.pixelmonmod.pixelmon.entities.npcs.EntityNPC;
import com.pixelmonmod.pixelmon.entities.npcs.NPCTrainer;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.spawning.spawners.EntityData;
import com.pixelmonmod.pixelmon.spawning.spawners.SpawnerAir;
import com.pixelmonmod.pixelmon.spawning.spawners.SpawnerBase;
import com.pixelmonmod.pixelmon.spawning.spawners.SpawnerBoss;
import com.pixelmonmod.pixelmon.spawning.spawners.SpawnerLand;
import com.pixelmonmod.pixelmon.spawning.spawners.SpawnerLegendary;
import com.pixelmonmod.pixelmon.spawning.spawners.SpawnerNPC;
import com.pixelmonmod.pixelmon.spawning.spawners.SpawnerUnderWater;
import com.pixelmonmod.pixelmon.spawning.spawners.SpawnerUnderground;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;

public class PixelmonSpawner {
    private static final Set<ChunkPos> eligibleChunksForSpawning = new HashSet<ChunkPos>(324);
    public static final ArrayList<SpawnerBase> spawners = new ArrayList();
    public static final SpawnerLand spawnerLand = new SpawnerLand();
    public static final SpawnerUnderground spawnerUnderground = new SpawnerUnderground();
    public static final SpawnerUnderWater spawnerUnderWater = new SpawnerUnderWater();
    public static final SpawnerAir spawnerAir = new SpawnerAir();
    public static final SpawnerLegendary spawnerLegendary = new SpawnerLegendary();
    public static final SpawnerNPC spawnerNPC = new SpawnerNPC();
    public static final SpawnerBoss spawnerBoss = new SpawnerBoss();
    private static final ImmutableList<SpawnerBase> allSpawners = ImmutableList.of((Object)spawnerLand, (Object)spawnerUnderground, (Object)spawnerUnderWater, (Object)spawnerAir, (Object)spawnerLegendary, (Object)spawnerNPC, (Object)spawnerBoss);
    private HashMap<Integer, Integer> spawnerTickArray = new HashMap();

    public static void addNormalSpawners() {
        for (SpawnerBase spawner : allSpawners) {
            if (spawners.contains(spawner)) continue;
            spawners.add(spawner);
        }
    }

    private static BlockPos getRandomSpawningPointInChunk(World world, int x, int z) {
        int xCoord = x * 16 + world.field_73012_v.nextInt(16);
        int zCoord = z * 16 + world.field_73012_v.nextInt(16);
        return new BlockPos(xCoord, 60, zCoord);
    }

    private static void findChunksForSpawning(WorldServer world) {
        eligibleChunksForSpawning.clear();
        for (EntityPlayer player : world.field_73010_i) {
            if (player.func_175149_v()) continue;
            for (int j = -PixelmonConfig.chunkSpawnRadius; j <= PixelmonConfig.chunkSpawnRadius; ++j) {
                for (int k = -PixelmonConfig.chunkSpawnRadius; k <= PixelmonConfig.chunkSpawnRadius; ++k) {
                    boolean isBorder = j == -PixelmonConfig.chunkSpawnRadius || j == PixelmonConfig.chunkSpawnRadius || k == -PixelmonConfig.chunkSpawnRadius || k == PixelmonConfig.chunkSpawnRadius;
                    ChunkPos cc = new ChunkPos(j + player.field_70176_ah, k + player.field_70164_aj);
                    if (eligibleChunksForSpawning.contains(cc) || world.func_175723_af() == null || !world.func_72863_F().func_73149_a(cc.field_77276_a, cc.field_77275_b) || isBorder || !world.func_175723_af().func_177730_a(cc)) continue;
                    eligibleChunksForSpawning.add(cc);
                }
            }
        }
    }

    private static void doSpawning(WorldServer world) {
        if (PixelmonSpawner.countEntities(world)) {
            return;
        }
        int leftoverSpawns = PixelmonConfig.maxSpawnsPerTick;
        BlockPos chunkCoords = world.func_175694_M();
        ArrayList<ChunkPos> tmp = new ArrayList<ChunkPos>(eligibleChunksForSpawning);
        Collections.shuffle(tmp);
        for (ChunkPos ccIntPair : tmp) {
            BlockPos chunkPos = PixelmonSpawner.getRandomSpawningPointInChunk((World)world, ccIntPair.field_77276_a, ccIntPair.field_77275_b);
            Chunk c = world.func_72964_e(ccIntPair.field_77276_a, ccIntPair.field_77275_b);
            if (PixelmonSpawner.countEntitiesInChunk(c, EntityPixelmon.class) > 4) continue;
            int cpX = chunkPos.func_177958_n();
            int cpZ = chunkPos.func_177952_p();
            for (SpawnerBase s : spawners) {
                Integer cpY;
                int maxSpawns = s.getMaxNum();
                if (maxSpawns <= 0 || s.count.get((World)world) > maxSpawns * eligibleChunksForSpawning.size() / 256 || !s.shouldSpawnInThisChunk(eligibleChunksForSpawning.size()) || (cpY = s.getSpawnConditionY((World)world, new BlockPos(cpX, 0, cpZ))) == null) continue;
                PixelmonSpawnEvent spawnEvent = new PixelmonSpawnEvent((World)world, cpX, cpY, cpZ);
                Pixelmon.EVENT_BUS.post((Event)spawnEvent);
                if (spawnEvent.isCanceled()) continue;
                int spawned = PixelmonSpawner.doSpawn(s, s.spawnLocation, (World)world, cpX, cpY, cpZ, chunkCoords);
                s.count.set((World)world, s.count.get((World)world) + spawned);
                if ((leftoverSpawns -= spawned) >= 0) continue;
                return;
            }
        }
    }

    private static int countEntitiesInChunk(Chunk chunk, Class<? extends Entity> entityClass) {
        int entityCount = 0;
        for (int i = 0; i < chunk.func_177429_s().length; ++i) {
            for (Entity entity : chunk.func_177429_s()[i]) {
                if (!entityClass.isAssignableFrom(entity.getClass())) continue;
                ++entityCount;
            }
        }
        return entityCount;
    }

    private static boolean countEntities(WorldServer world) {
        for (SpawnerBase s : spawners) {
            s.count.set((World)world, 0);
        }
        int[] counts = new int[SpawnLocation.values().length];
        for (int i = 0; i < world.field_72996_f.size(); ++i) {
            Entity entity = (Entity)world.field_72996_f.get(i);
            if (entity instanceof EntityPixelmon) {
                EntityPixelmon pixelmon = (EntityPixelmon)entity;
                if (pixelmon.getSpawnLocation() == null) continue;
                int n = pixelmon.getSpawnLocation().ordinal();
                counts[n] = counts[n] + 1;
                continue;
            }
            if (!(entity instanceof EntityNPC)) continue;
            EntityNPC npc = (EntityNPC)entity;
            if (npc.npcLocation == null) continue;
            int n = npc.npcLocation.ordinal();
            counts[n] = counts[n] + 1;
        }
        for (SpawnerBase spawner : spawners) {
            spawner.count.set((World)world, counts[spawner.spawnLocation.ordinal()]);
        }
        for (SpawnerBase s : spawners) {
            if (s.getMaxNum() <= 0 || s.count.get((World)world) >= s.getMaxNum() * eligibleChunksForSpawning.size() / 256) continue;
            return false;
        }
        return true;
    }

    private static int doSpawn(SpawnerBase s, SpawnLocation spawnLocation, World world, int cpX, int cpY, int cpZ, BlockPos pos) {
        int numInChunk = 0;
        block2: for (int count = 0; count < 3; ++count) {
            int cpXtmp = cpX;
            int cpYtmp = cpY;
            int cpZtmp = cpZ;
            int rndmMax = 6;
            String entityName = null;
            int maxInChunk = -1;
            for (int count2 = 0; count2 < 4; ++count2) {
                boolean notColliding;
                EntityLiving entity;
                double distance;
                float z;
                float y;
                float x;
                if (!s.canPokemonSpawnHere(world, new BlockPos(cpXtmp += world.field_73012_v.nextInt(rndmMax) - world.field_73012_v.nextInt(rndmMax), cpYtmp += world.field_73012_v.nextInt(1) - world.field_73012_v.nextInt(1), cpZtmp += world.field_73012_v.nextInt(rndmMax) - world.field_73012_v.nextInt(rndmMax))) || world.func_184137_a((double)(x = (float)cpXtmp + 0.5f), (double)(y = (float)cpYtmp + 0.5f), (double)(z = (float)cpZtmp + 0.5f), 24.0, false) != null) continue;
                float xd = x - (float)pos.func_177958_n();
                float yd = y - (float)pos.func_177956_o();
                float zd = z - (float)pos.func_177952_p();
                float d = xd * xd + yd * yd + zd * zd;
                BlockPos spawnPos = new BlockPos((double)x, (double)y, (double)z);
                String biomeID = world.getBiomeForCoordsBody(spawnPos).getRegistryName().func_110623_a();
                int level = 3;
                if (!(d >= 576.0f)) continue;
                if (PixelmonConfig.spawnLevelsByDistance && (level = (int)((double)level + Math.floor((distance = Math.sqrt(pos.func_177954_c((double)x, (double)pos.func_177956_o(), (double)z))) / (double)PixelmonConfig.distancePerLevel + Math.random() * 3.0))) > PixelmonConfig.maxLevelByDistance) {
                    level = PixelmonConfig.maxLevelByDistance;
                }
                if (entityName == null) {
                    EntityData data = s.getRandomEntity(world, world.field_73012_v, biomeID, spawnPos, level);
                    if (data != null) {
                        entityName = data.name;
                        level = data.level;
                    }
                    if (entityName == null) continue block2;
                }
                try {
                    entity = PixelmonEntityList.createEntityByName(entityName, world, biomeID);
                    if (PixelmonConfig.spawnLevelsByDistance) {
                        if (entity instanceof EntityPixelmon && !(s instanceof SpawnerLegendary)) {
                            ((EntityPixelmon)entity).getLvl().setLevel(level);
                        } else if (entity instanceof NPCTrainer) {
                            ((NPCTrainer)entity).setLevel(level);
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return 0;
                }
                if (entity == null) {
                    return 0;
                }
                Event.Result canSpawn = ForgeEventFactory.canEntitySpawn((EntityLiving)entity, (World)world, (float)x, (float)(y + s.getYOffset(x, y, z, entity)), (float)z, (boolean)true);
                if (canSpawn != Event.Result.ALLOW && canSpawn != Event.Result.DEFAULT) continue;
                EntityPixelmon pixelmon = null;
                if (entity instanceof EntityPixelmon) {
                    pixelmon = (EntityPixelmon)entity;
                }
                if (pixelmon != null) {
                    pixelmon.setSpawnLocation(s.getActualSpawnLocation(pixelmon));
                }
                entity.func_70012_b((double)x, (double)y + (double)s.getYOffset(x, y, z, entity), (double)z, world.field_73012_v.nextFloat() * 360.0f, 0.0f);
                if (entity instanceof EntityNPC) {
                    ((EntityNPC)entity).npcLocation = spawnLocation;
                }
                if (!entity.func_70601_bi()) continue;
                ++numInChunk;
                s.modifyPokemon(entity, cpXtmp, cpZtmp);
                AxisAlignedBB boundingBox = entity.func_174813_aQ();
                boolean bl = notColliding = world.func_72917_a(boundingBox, (Entity)entity) && entity.field_70170_p.func_184144_a((Entity)entity, boundingBox).isEmpty();
                if (notColliding) {
                    world.func_72838_d((Entity)entity);
                    if (maxInChunk == -1) {
                        maxInChunk = entity.func_70641_bl();
                    }
                }
                if (numInChunk < maxInChunk) continue;
                return numInChunk;
            }
        }
        return 0;
    }

    @SubscribeEvent
    public void tickEnd(TickEvent.WorldTickEvent event) {
        if (event.side == Side.SERVER && event.world.func_73046_m().func_71268_U()) {
            try {
                World world = event.world;
                int dimId = world.field_73011_w.getDimension();
                if (this.allowDimension(dimId)) {
                    int spawnerTicks = -1;
                    if (this.spawnerTickArray.containsKey(dimId)) {
                        spawnerTicks = this.spawnerTickArray.get(dimId);
                    }
                    if (++spawnerTicks >= PixelmonConfig.spawnTickRate && PixelmonConfig.maxSpawnsPerTick > 0) {
                        PixelmonSpawner.findChunksForSpawning((WorldServer)world);
                        PixelmonSpawner.doSpawning((WorldServer)world);
                        spawnerTicks = 0;
                    }
                    this.spawnerTickArray.put(dimId, spawnerTicks);
                }
            }
            catch (Exception e) {
                Pixelmon.LOGGER.error("Error in spawning.");
                e.printStackTrace();
            }
        }
    }

    private boolean allowDimension(int dimensionId) {
        return PixelmonConfig.spawnDimensions.contains(dimensionId);
    }
}

